/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.gui;

import fr.profi.mgfboost.ui.command.ui.MzdbCreateMgfPanel;
import fr.profi.mzDBWizard.configuration.ConfigurationManager;
import fr.profi.mzDBWizard.gui.overview.AttributesTableModel;
import fr.profi.mzDBWizard.gui.pendingtask.PendingTask;
import fr.profi.mzDBWizard.gui.pendingtask.PendingTaskTypeRenderer;
import fr.profi.mzDBWizard.gui.pendingtask.PendingTasksTableModel;
import fr.profi.mzDBWizard.gui.util.ComponentTitledBorder;
import fr.profi.mzDBWizard.gui.util.DefaultIcons;
import fr.profi.mzDBWizard.gui.util.GenericTableRenderer;
import fr.profi.mzDBWizard.gui.util.GuiUtil;
import fr.profi.mzDBWizard.processing.CreateMgfCommand;
import fr.profi.mzDBWizard.processing.jms.queue.AbstractJMSCallback;
import fr.profi.mzDBWizard.processing.jms.queue.AccessJMSManagerThread;
import fr.profi.mzDBWizard.processing.jms.queue.JMSConnectionManager;
import fr.profi.mzDBWizard.processing.jms.task.MountingPathJMSTask;
import fr.profi.mzDBWizard.util.FileUtility;
import fr.profi.mzDBWizard.util.JavaVersion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsAndReviewDialog
extends JDialog
implements ActionListener,
KeyListener {
    private static final Logger m_logger = LoggerFactory.getLogger(SettingsAndReviewDialog.class);
    private HashMap<Step, JPanel> m_steps;
    private JButton[] m_button;
    private Answer m_answer;
    private Step m_currentStep;
    private JPanel m_mainPanel;
    private JCheckBox m_processPendingCheckBox;
    private boolean m_processExisting;
    private PendingTasksTableModel m_pendingTasksModel;
    private JTable m_pendingTasksTable;
    private ArrayList<PendingTask> m_pendingTasks;
    private AttributesTableModel m_configurationTableModel;
    private HashSet<String> m_filesIndex;
    private boolean m_hasDuplicates;
    private boolean m_triggerPermission;
    private JTextField m_monitoredDirectory;
    private JCheckBox m_recursiveCheckBox;
    private JCheckBox m_splitMzdbOperationCheckbox;
    private boolean m_doSplit;
    private JCheckBox m_generateMgfOperationCheckbox;
    private boolean m_doGenerateMgf;
    private JTextField m_converterTxtField;
    private JTextField m_converterOptionTxtField;
    private JCheckBox m_convertOperationCheckbox;
    private boolean m_doConvert;
    private JButton m_converterButton;
    private JCheckBox m_uploadOperationCheckbox;
    private boolean m_doUpload;
    private JTextField m_host;
    private JComboBox m_mountingPointComboBox;
    private JButton m_refreshMountingPointsButton;
    private JCheckBox[] m_cleanupOperationCheckboxes;
    private CreateMgfCommand m_createMgfCommand;

    public SettingsAndReviewDialog() {
        this.setModal(true);
        JavaVersion buildInformation = new JavaVersion();
        this.setTitle("Welcome to " + buildInformation.getModuleName() + " (" + buildInformation.getVersion() + ")");
        this.setIconImage(DefaultIcons.getSingleton().getIcon("logo_30.png").getImage());
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.m_answer = Answer.NULL_ANSWER;
        this.m_createMgfCommand = CreateMgfCommand.getInstance();
        JPanel internalPanel = this.init();
        this.add((Component)internalPanel, "Center");
        this.add((Component)this.initButtons(), "South");
        this.addKeyListener(this);
        this.setFocusable(true);
        this.pack();
        if (ConfigurationManager.isReadOnlyCfg()) {
            this.setToReadOnly(internalPanel);
        }
    }

    private void setToReadOnly(JPanel panel) {
        List<JComponent> all = GuiUtil.getAllChildrenOfClass(panel, JComponent.class);
        for (JComponent compo : all) {
            if (compo instanceof JPanel && compo.getBorder() instanceof ComponentTitledBorder) {
                ((ComponentTitledBorder)compo.getBorder()).setEnabledComponent(false);
            } else if ((compo instanceof JPanel || compo instanceof JScrollPane) && compo.getBorder() instanceof CompoundBorder && ((CompoundBorder)compo.getBorder()).getOutsideBorder() instanceof ComponentTitledBorder) {
                ((ComponentTitledBorder)((CompoundBorder)compo.getBorder()).getOutsideBorder()).setEnabledComponent(false);
            }
            compo.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equalsIgnoreCase("Start")) {
            this.startAction();
        } else if (ae.getActionCommand().equalsIgnoreCase("Cancel")) {
            this.cancelAction();
        } else if (ae.getActionCommand().equalsIgnoreCase("Next")) {
            this.nextAction();
        } else if (ae.getActionCommand().equalsIgnoreCase("Previous")) {
            this.previousAction();
        }
    }

    private void cancelAction() {
        this.m_answer = Answer.CANCEL;
        this.setVisible(false);
    }

    private void startAction() {
        if (this.validateJComponents() && this.ensureUniqueness() && this.m_currentStep == Step.REVIEW_STEP) {
            this.m_answer = Answer.OK;
            this.updateConfiguration();
            ConfigurationManager.saveProperties(this.m_createMgfCommand);
            this.setVisible(false);
        }
    }

    private void nextAction() {
        if (this.m_currentStep == Step.CONFIG_STEP && this.validateMgfConfiguration() && this.validateUploadConfiguration() && this.validateOperations()) {
            if (!this.m_steps.containsKey((Object)Step.REVIEW_STEP)) {
                this.m_steps.put(Step.REVIEW_STEP, this.initReviewStep());
            }
            this.reviewStep();
        }
    }

    private void reviewStep() {
        this.m_mainPanel.removeAll();
        this.m_currentStep = Step.REVIEW_STEP;
        this.m_mainPanel.add(this.m_steps.get((Object)Step.REVIEW_STEP));
        this.m_mainPanel.revalidate();
        this.m_mainPanel.repaint();
        File monitoredDirectory = new File(this.m_monitoredDirectory.getText());
        if (monitoredDirectory.exists()) {
            if (this.m_pendingTasks == null) {
                this.m_pendingTasks = new ArrayList();
            } else {
                this.m_pendingTasks.clear();
            }
            this.m_hasDuplicates = false;
            this.m_triggerPermission = false;
            this.m_filesIndex.clear();
            ArrayList<File> recoveredFiles = new ArrayList<File>();
            FileUtility.listFiles(monitoredDirectory.getAbsolutePath(), recoveredFiles, this.m_recursiveCheckBox.isSelected());
            for (int i = 0; i < recoveredFiles.size(); ++i) {
                File f = recoveredFiles.get(i);
                String filename = FilenameUtils.removeExtension((String)f.getAbsolutePath());
                if (this.m_filesIndex.contains(filename)) {
                    this.m_hasDuplicates = true;
                } else {
                    this.m_filesIndex.add(filename);
                }
                if (f.getAbsolutePath().toLowerCase().endsWith(".raw") || f.getAbsolutePath().toLowerCase().endsWith(".wiff")) {
                    if (!this.m_doConvert) continue;
                    this.m_pendingTasks.add(new PendingTask(recoveredFiles.get(i).getAbsolutePath(), PendingTasksTableModel.Action.CONVERSION));
                    continue;
                }
                if (!f.getAbsolutePath().toLowerCase().endsWith(".mzdb")) continue;
                if (this.m_doUpload) {
                    this.m_pendingTasks.add(new PendingTask(recoveredFiles.get(i).getAbsolutePath(), PendingTasksTableModel.Action.UPLOAD));
                    continue;
                }
                if (!this.m_doGenerateMgf) continue;
                this.m_pendingTasks.add(new PendingTask(recoveredFiles.get(i).getAbsolutePath(), PendingTasksTableModel.Action.CONVERSION));
            }
            this.m_pendingTasksModel.update(this.m_pendingTasks);
        }
        this.updateConfiguration();
        this.m_configurationTableModel.update(ConfigurationManager.getConfigurationModelData());
        this.updateButtons();
        this.m_triggerPermission = true;
        this.validate();
    }

    private void previousAction() {
        this.m_mainPanel.removeAll();
        if (this.m_currentStep == Step.REVIEW_STEP) {
            this.m_currentStep = Step.CONFIG_STEP;
            this.m_mainPanel.add(this.m_steps.get((Object)Step.CONFIG_STEP));
        }
        this.m_mainPanel.revalidate();
        this.m_mainPanel.repaint();
        this.updateButtons();
    }

    private JPanel initButtons() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 10, 10, 10);
        panel.add(Box.createHorizontalGlue(), c);
        c.weightx = 0.0;
        String path = new File(".").getAbsolutePath();
        System.out.println(path);
        String[] iconsName = new String[]{"arrow-180.png", "arrow.png", "tick.png", "cross.png"};
        String[] headings = new String[]{"Previous", "Next", "Start", "Cancel"};
        this.m_button = new JButton[headings.length];
        for (int i = 0; i < this.m_button.length; ++i) {
            this.m_button[i] = new JButton(headings[i], DefaultIcons.getSingleton().getIcon(iconsName[i]));
            this.m_button[i].setActionCommand(headings[i]);
            this.m_button[i].addActionListener(this);
            this.m_button[i].setFocusable(false);
            ++c.gridx;
            panel.add((Component)this.m_button[i], c);
        }
        this.updateButtons();
        return panel;
    }

    private void updateButtons() {
        if (this.m_currentStep == Step.CONFIG_STEP) {
            this.m_button[0].setEnabled(false);
            this.m_button[1].setEnabled(true);
            this.m_button[2].setEnabled(false);
        } else if (this.m_currentStep == Step.REVIEW_STEP) {
            this.m_button[0].setEnabled(true);
            this.m_button[1].setEnabled(false);
            this.m_button[2].setEnabled(true);
        }
    }

    private void clearMountingPoints() {
        this.m_mountingPointComboBox.removeAllItems();
        this.m_mountingPointComboBox.addItem("Select..");
    }

    private void reloadMountingPoints() {
        int i;
        Object m_lastMountingPoint = this.m_mountingPointComboBox.getSelectedItem();
        this.clearMountingPoints();
        for (i = 0; i < ConfigurationManager.getMountingPointPathLabels().size(); ++i) {
            this.m_mountingPointComboBox.addItem(ConfigurationManager.getMountingPointPathLabels().get(i));
        }
        if (m_lastMountingPoint != null && this.m_mountingPointComboBox.getSelectedIndex() > 0) {
            this.m_mountingPointComboBox.setSelectedItem(m_lastMountingPoint);
        } else {
            for (i = 0; i < this.m_mountingPointComboBox.getItemCount(); ++i) {
                if (!this.m_mountingPointComboBox.getItemAt(i).toString().equalsIgnoreCase(ConfigurationManager.getMountingPointLabel())) continue;
                this.m_mountingPointComboBox.setSelectedIndex(i);
                break;
            }
        }
    }

    private JPanel initMonitorOperationPanel() {
        JPanel monitorOperationPanel = new JPanel();
        monitorOperationPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel monitoredDirectoryLabel = new JLabel("Directory : ");
        monitoredDirectoryLabel.setHorizontalAlignment(4);
        File directoryFile = new File(ConfigurationManager.getMonitorPath());
        this.m_monitoredDirectory = new JTextField(directoryFile.exists() ? directoryFile.getAbsolutePath() : System.getProperty("user.dir"));
        this.m_monitoredDirectory.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.m_monitoredDirectory.setFocusable(false);
        this.m_monitoredDirectory.setToolTipText("Click to select directory!");
        this.m_monitoredDirectory.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SettingsAndReviewDialog.this.openMonitoredDirectoryChooserDialog();
            }
        });
        JButton m_directoryButton = new JButton(DefaultIcons.getSingleton().getIcon("folder-horizontal-open.png"));
        m_directoryButton.setFocusable(false);
        m_directoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SettingsAndReviewDialog.this.openMonitoredDirectoryChooserDialog();
            }
        });
        this.m_recursiveCheckBox = new JCheckBox("Recursively");
        this.m_recursiveCheckBox.setSelected(ConfigurationManager.getRecursive());
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        monitorOperationPanel.add((Component)monitoredDirectoryLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        monitorOperationPanel.add((Component)this.m_monitoredDirectory, c);
        c.gridx = 2;
        c.weightx = 0.0;
        monitorOperationPanel.add((Component)m_directoryButton, c);
        ++c.gridy;
        c.gridwidth = 2;
        c.gridx = 1;
        c.weightx = 0.0;
        this.m_recursiveCheckBox.setHorizontalAlignment(2);
        monitorOperationPanel.add((Component)this.m_recursiveCheckBox, c);
        monitorOperationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Monitored directory"));
        return monitorOperationPanel;
    }

    private JPanel initConvertOperationPanel() {
        JPanel convertOperationPanel = new JPanel();
        convertOperationPanel.setLayout(new GridBagLayout());
        JLabel converterLabel = new JLabel("Converter : ");
        File converterFile = new File(ConfigurationManager.getConverterPath());
        this.m_converterTxtField = new JTextField(converterFile.exists() ? converterFile.getAbsolutePath() : "Converter not selected!");
        this.m_converterTxtField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.m_converterTxtField.setBackground(Color.WHITE);
        this.m_converterTxtField.setFocusable(false);
        this.m_converterTxtField.setToolTipText("Click to select converter!");
        this.m_converterTxtField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SettingsAndReviewDialog.this.openConverterChooserDialog();
            }
        });
        this.m_converterButton = new JButton(DefaultIcons.getSingleton().getIcon("folder-horizontal-open.png"));
        this.m_converterButton.setFocusable(false);
        this.m_converterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SettingsAndReviewDialog.this.openConverterChooserDialog();
            }
        });
        this.m_doConvert = ConfigurationManager.getConvertMzdbOperation();
        this.m_convertOperationCheckbox = new JCheckBox("Convert");
        this.m_convertOperationCheckbox.setSelected(this.m_doConvert);
        this.m_convertOperationCheckbox.setFocusable(false);
        this.m_convertOperationCheckbox.addItemListener(ie -> {
            this.m_doConvert = this.m_convertOperationCheckbox.isSelected();
            this.enableConversionOptions();
        });
        this.enableConversionOptions();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weighty = 0.0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        convertOperationPanel.add((Component)converterLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        convertOperationPanel.add((Component)this.m_converterTxtField, c);
        c.weightx = 0.0;
        ++c.gridx;
        convertOperationPanel.add((Component)this.m_converterButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        JLabel converterOptionLabel = new JLabel("Options : ");
        convertOperationPanel.add((Component)converterOptionLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        String options = ConfigurationManager.getConverterOptions() != null && !ConfigurationManager.getConverterOptions().isEmpty() ? ConfigurationManager.getConverterOptions() : "";
        this.m_converterOptionTxtField = new JTextField(options);
        this.m_converterOptionTxtField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        convertOperationPanel.add((Component)this.m_converterOptionTxtField, c);
        convertOperationPanel.setBorder(new ComponentTitledBorder(this.m_convertOperationCheckbox, convertOperationPanel, BorderFactory.createEtchedBorder()));
        return convertOperationPanel;
    }

    private void enableConversionOptions() {
        this.m_converterTxtField.setEnabled(this.m_doConvert);
        this.m_converterButton.setEnabled(this.m_doConvert);
    }

    private JPanel initGenerateMgfOperationPanel() {
        JPanel mgfOperationPanel = new JPanel();
        mgfOperationPanel.setLayout(new GridBagLayout());
        this.m_doGenerateMgf = ConfigurationManager.getProcessGenerateMgf();
        this.m_generateMgfOperationCheckbox = new JCheckBox("Generate mgf");
        this.m_generateMgfOperationCheckbox.setSelected(this.m_doGenerateMgf);
        this.m_generateMgfOperationCheckbox.setFocusable(false);
        this.m_generateMgfOperationCheckbox.addItemListener(ie -> {
            this.m_doGenerateMgf = this.m_generateMgfOperationCheckbox.isSelected();
            this.enableMgfOptions();
        });
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        mgfOperationPanel.add(this.m_createMgfCommand.getConfigurationPanel(), c);
        mgfOperationPanel.setBorder(new ComponentTitledBorder(this.m_generateMgfOperationCheckbox, mgfOperationPanel, BorderFactory.createEtchedBorder()));
        this.enableMgfOptions();
        return mgfOperationPanel;
    }

    private void enableMgfOptions() {
        GuiUtil.enableAllChildrenOfClass(this.m_createMgfCommand.getConfigurationPanel(), JComponent.class, this.m_doGenerateMgf);
        if (this.m_doGenerateMgf) {
            ((MzdbCreateMgfPanel)this.m_createMgfCommand.getConfigurationPanel()).updateComponents();
        }
    }

    private JPanel initUploadOperationPanel() {
        JPanel uploadOperationPanel = new JPanel();
        uploadOperationPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_doUpload = ConfigurationManager.getProcessUpload();
        this.m_uploadOperationCheckbox = new JCheckBox("Upload");
        this.m_uploadOperationCheckbox.setSelected(this.m_doUpload);
        this.m_uploadOperationCheckbox.setFocusable(false);
        this.m_uploadOperationCheckbox.addItemListener(ie -> {
            this.m_doUpload = this.m_uploadOperationCheckbox.isSelected();
            this.enableUploadOptions();
            if (this.m_doUpload) {
                this.m_uploadOperationCheckbox.setFocusPainted(false);
                if (this.m_host != null) {
                    this.m_host.requestFocus();
                    if (this.m_doUpload && !this.m_host.getText().equalsIgnoreCase("<host>")) {
                        this.requestMountingPoints();
                    }
                }
            }
        });
        JLabel hostLabel = new JLabel("Host : ");
        hostLabel.setHorizontalAlignment(4);
        this.m_host = new JTextField(ConfigurationManager.getJmsServerHost());
        this.m_host.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SettingsAndReviewDialog.this.m_uploadOperationCheckbox.setSelected(true);
                SettingsAndReviewDialog.this.m_doUpload = true;
                SettingsAndReviewDialog.this.repaint();
            }
        });
        this.m_host.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.m_host.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent ke) {
                SettingsAndReviewDialog.this.clearMountingPoints();
            }

            @Override
            public void keyPressed(KeyEvent ke) {
            }

            @Override
            public void keyReleased(KeyEvent ke) {
            }
        });
        JLabel mountingPointLabel = new JLabel("Mounting Point : ");
        this.m_mountingPointComboBox = new JComboBox();
        this.m_mountingPointComboBox.setModel(new DefaultComboBoxModel());
        this.m_mountingPointComboBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SettingsAndReviewDialog.this.m_uploadOperationCheckbox.setSelected(true);
                SettingsAndReviewDialog.this.m_doUpload = true;
                SettingsAndReviewDialog.this.repaint();
            }
        });
        this.clearMountingPoints();
        this.m_refreshMountingPointsButton = new JButton(DefaultIcons.getSingleton().getIcon("arrow-circle.png"));
        this.m_refreshMountingPointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!SettingsAndReviewDialog.this.m_host.getText().equalsIgnoreCase("<host>")) {
                    SettingsAndReviewDialog.this.requestMountingPoints();
                } else {
                    JOptionPane.showMessageDialog(SettingsAndReviewDialog.this.m_refreshMountingPointsButton, "Please, select the host of the server.", "Error", 0);
                }
            }
        });
        this.enableUploadOptions();
        if (this.m_doUpload && !this.m_host.getText().equalsIgnoreCase("<host>")) {
            this.requestMountingPoints();
        }
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        uploadOperationPanel.add((Component)hostLabel, c);
        c.gridwidth = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        uploadOperationPanel.add((Component)this.m_host, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        uploadOperationPanel.add((Component)mountingPointLabel, c);
        c.gridwidth = 1;
        c.gridx = 1;
        c.weightx = 1.0;
        uploadOperationPanel.add((Component)this.m_mountingPointComboBox, c);
        c.gridwidth = 1;
        c.gridx = 2;
        c.weightx = 0.0;
        uploadOperationPanel.add((Component)this.m_refreshMountingPointsButton, c);
        uploadOperationPanel.setBorder(new ComponentTitledBorder(this.m_uploadOperationCheckbox, uploadOperationPanel, BorderFactory.createEtchedBorder()));
        return uploadOperationPanel;
    }

    private void requestMountingPoints() {
        this.m_refreshMountingPointsButton.setEnabled(false);
        this.m_refreshMountingPointsButton.setIcon(DefaultIcons.getSingleton().getIcon("hourglass.png"));
        JMSConnectionManager.getJMSConnectionManager().closeConnection();
        JMSConnectionManager.getJMSConnectionManager().setJMSServerHost(this.m_host.getText().trim());
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            @Override
            public boolean mustBeCalledInAWT() {
                return true;
            }

            @Override
            public void run(boolean success) {
                SettingsAndReviewDialog.this.m_refreshMountingPointsButton.setEnabled(true);
                SettingsAndReviewDialog.this.m_refreshMountingPointsButton.setIcon(DefaultIcons.getSingleton().getIcon("arrow-circle.png"));
                if (success) {
                    SettingsAndReviewDialog.this.reloadMountingPoints();
                } else {
                    SettingsAndReviewDialog.this.clearMountingPoints();
                }
            }
        };
        MountingPathJMSTask task = new MountingPathJMSTask(callback);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask(task);
    }

    private void enableUploadOptions() {
        this.m_host.setEnabled(this.m_doUpload);
        this.m_mountingPointComboBox.setEnabled(this.m_doUpload);
        this.repaint();
    }

    private JPanel initSplitMzdbOperationPanel() {
        JPanel splitMzdbPanel = new JPanel();
        splitMzdbPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_doSplit = ConfigurationManager.getProcessSplitMzdb();
        this.m_splitMzdbOperationCheckbox = new JCheckBox("Split Exploris mzdb");
        this.m_splitMzdbOperationCheckbox.setSelected(this.m_doSplit);
        this.m_splitMzdbOperationCheckbox.setFocusable(false);
        this.m_splitMzdbOperationCheckbox.addItemListener(ie -> {
            this.m_doSplit = this.m_splitMzdbOperationCheckbox.isSelected();
        });
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        splitMzdbPanel.add((Component)this.m_splitMzdbOperationCheckbox, c);
        JLabel splitExtensionLb = new JLabel("Splitted files extension: ");
        splitExtensionLb.setHorizontalAlignment(4);
        JTextField splitExtension = new JTextField(".split.mzdb");
        splitExtension.setEditable(false);
        ++c.gridy;
        splitMzdbPanel.add((Component)splitExtensionLb, c);
        c.weightx = 1.0;
        ++c.gridx;
        splitMzdbPanel.add((Component)splitExtension, c);
        splitMzdbPanel.setBorder(new ComponentTitledBorder(this.m_splitMzdbOperationCheckbox, splitMzdbPanel, BorderFactory.createEtchedBorder()));
        return splitMzdbPanel;
    }

    private JPanel initCleanupOperationPanel() {
        JPanel cleanupPanel = new JPanel();
        String[] checkHeadings = new String[]{"Raw", "mzDB"};
        cleanupPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = -1;
        c.gridy = 0;
        Boolean[] checkInitialValues = new Boolean[]{ConfigurationManager.getDeleteRaw(), ConfigurationManager.getDeleteMzdb()};
        this.m_cleanupOperationCheckboxes = new JCheckBox[checkHeadings.length];
        for (int i = 0; i < this.m_cleanupOperationCheckboxes.length; ++i) {
            this.m_cleanupOperationCheckboxes[i] = new JCheckBox(checkHeadings[i]);
            this.m_cleanupOperationCheckboxes[i].setSelected(checkInitialValues[i]);
            this.m_cleanupOperationCheckboxes[i].setFocusable(false);
            ++c.gridx;
            cleanupPanel.add((Component)this.m_cleanupOperationCheckboxes[i], c);
        }
        c.weightx = 1.0;
        ++c.gridx;
        cleanupPanel.add((Component)Box.createHorizontalBox(), c);
        cleanupPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Cleanup"));
        return cleanupPanel;
    }

    private JPanel initConfigStep() {
        JPanel configPanel = new JPanel();
        configPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        configPanel.add((Component)this.initMonitorOperationPanel(), c);
        ++c.gridy;
        configPanel.add((Component)this.initConvertOperationPanel(), c);
        ++c.gridy;
        configPanel.add((Component)this.initSplitMzdbOperationPanel(), c);
        ++c.gridy;
        configPanel.add((Component)this.initGenerateMgfOperationPanel(), c);
        ++c.gridy;
        configPanel.add((Component)this.initUploadOperationPanel(), c);
        ++c.gridy;
        configPanel.add((Component)this.initCleanupOperationPanel(), c);
        ++c.gridy;
        c.weighty = 1.0;
        configPanel.add((Component)Box.createVerticalBox(), c);
        return configPanel;
    }

    private void updateConfiguration() {
        ConfigurationManager.setMonitorPath(this.m_monitoredDirectory.getText());
        ConfigurationManager.setRecursiveWatching(this.m_recursiveCheckBox.isSelected());
        ConfigurationManager.setConvertMzdbOperation(this.m_doConvert);
        ConfigurationManager.setConverterPath(this.m_converterTxtField.getText());
        ConfigurationManager.setConverterOptions(this.m_converterOptionTxtField.getText());
        ConfigurationManager.setProcessSplitMzdb(this.m_doSplit);
        ConfigurationManager.setProcessGenerateMgf(this.m_doGenerateMgf);
        ConfigurationManager.setProcessUpload(this.m_doUpload);
        ConfigurationManager.setJmsServerHost(this.m_host.getText());
        ConfigurationManager.setMountingPointLabel(this.m_mountingPointComboBox.getSelectedItem().toString());
        ConfigurationManager.setDeleteRaw(this.m_cleanupOperationCheckboxes[0].isSelected());
        ConfigurationManager.setDeleteMzdb(this.m_cleanupOperationCheckboxes[1].isSelected());
        if (this.m_processPendingCheckBox != null) {
            ConfigurationManager.setProcessPending(this.m_processPendingCheckBox.isSelected());
        }
    }

    private JPanel initReviewStep() {
        JPanel reviewStepPanel = new JPanel();
        reviewStepPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.updateConfiguration();
        this.m_configurationTableModel = new AttributesTableModel(ConfigurationManager.getConfigurationModelData());
        JTable m_configurationTable = new JTable(this.m_configurationTableModel);
        m_configurationTable.setTableHeader(null);
        m_configurationTable.setRowHeight(20);
        m_configurationTable.setRowSelectionAllowed(true);
        m_configurationTable.setDefaultRenderer(Object.class, new GenericTableRenderer());
        JScrollPane configurationScrollPane = new JScrollPane(m_configurationTable);
        configurationScrollPane.getViewport().setBackground(m_configurationTable.getBackground());
        configurationScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Configuration"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        m_configurationTable.setMinimumSize(new Dimension(m_configurationTable.getWidth(), 270));
        configurationScrollPane.setMinimumSize(new Dimension(m_configurationTable.getWidth(), 270));
        configurationScrollPane.setPreferredSize(new Dimension(m_configurationTable.getWidth(), 270));
        this.m_pendingTasksModel = new PendingTasksTableModel();
        this.m_pendingTasksTable = new JTable(this.m_pendingTasksModel);
        this.m_pendingTasksTable.setRowHeight(20);
        this.m_pendingTasksTable.setRowSelectionAllowed(true);
        this.m_pendingTasksTable.setSelectionMode(2);
        this.m_pendingTasksTable.getColumnModel().getColumn(0).setCellRenderer(new GenericTableRenderer());
        this.m_pendingTasksTable.getColumnModel().getColumn(1).setCellRenderer(new PendingTaskTypeRenderer());
        JScrollPane pendingScrollPane = new JScrollPane(this.m_pendingTasksTable);
        pendingScrollPane.getViewport().setBackground(this.m_pendingTasksTable.getBackground());
        this.m_pendingTasksTable.setMinimumSize(new Dimension(this.m_pendingTasksTable.getWidth(), 270));
        pendingScrollPane.setMinimumSize(new Dimension(this.m_pendingTasksTable.getWidth(), 270));
        pendingScrollPane.setPreferredSize(new Dimension(this.m_pendingTasksTable.getWidth(), 270));
        this.m_processPendingCheckBox = new JCheckBox("Process existing files");
        this.m_processPendingCheckBox.setSelected(ConfigurationManager.getProcessPending());
        this.m_processPendingCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                SettingsAndReviewDialog.this.m_processExisting = SettingsAndReviewDialog.this.m_processPendingCheckBox.isSelected();
                SettingsAndReviewDialog.this.m_pendingTasksTable.setEnabled(SettingsAndReviewDialog.this.m_processExisting);
                SettingsAndReviewDialog.this.repaint();
                if (SettingsAndReviewDialog.this.m_hasDuplicates && SettingsAndReviewDialog.this.m_triggerPermission && SettingsAndReviewDialog.this.m_processExisting && SettingsAndReviewDialog.this.m_doUpload) {
                    if (JOptionPane.showConfirmDialog(null, "Are you sure you want to proceed?", "Raw and Mzdb versions of the same file(s)!", 2) == 2) {
                        SettingsAndReviewDialog.this.m_triggerPermission = false;
                        SettingsAndReviewDialog.this.m_processPendingCheckBox.setSelected(false);
                        SettingsAndReviewDialog.this.m_triggerPermission = true;
                    } else {
                        SettingsAndReviewDialog.this.m_triggerPermission = false;
                        SettingsAndReviewDialog.this.m_processPendingCheckBox.setSelected(true);
                        SettingsAndReviewDialog.this.m_triggerPermission = true;
                    }
                    SettingsAndReviewDialog.this.m_processExisting = SettingsAndReviewDialog.this.m_processPendingCheckBox.isSelected();
                }
            }
        });
        this.m_processPendingCheckBox.setSelected(ConfigurationManager.getProcessPending());
        this.m_pendingTasksTable.setEnabled(ConfigurationManager.getProcessPending());
        this.m_triggerPermission = true;
        pendingScrollPane.setBorder(BorderFactory.createCompoundBorder(new ComponentTitledBorder(this.m_processPendingCheckBox, pendingScrollPane, BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        reviewStepPanel.add((Component)configurationScrollPane, c);
        ++c.gridy;
        reviewStepPanel.add((Component)pendingScrollPane, c);
        if (ConfigurationManager.isReadOnlyCfg()) {
            this.setToReadOnly(reviewStepPanel);
        }
        return reviewStepPanel;
    }

    private JPanel init() {
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BorderLayout());
        this.m_filesIndex = new HashSet();
        this.m_hasDuplicates = false;
        this.m_steps = new HashMap();
        this.m_currentStep = Step.CONFIG_STEP;
        this.m_steps.put(Step.CONFIG_STEP, this.initConfigStep());
        this.m_mainPanel.add(this.m_steps.get((Object)Step.CONFIG_STEP));
        return this.m_mainPanel;
    }

    private void openConverterChooserDialog() {
        File exe = FileUtility.chooseConverter();
        if (exe != null) {
            this.m_converterTxtField.setText(exe.getAbsolutePath());
            this.m_convertOperationCheckbox.setSelected(true);
            this.m_doConvert = true;
            this.repaint();
        }
    }

    private void openMonitoredDirectoryChooserDialog() {
        File dir = FileUtility.chooseDirectory();
        if (dir != null) {
            this.m_monitoredDirectory.setText(dir.getAbsolutePath());
        }
    }

    private boolean validateJComponents() {
        if (this.m_monitoredDirectory.getText().length() == 0 || this.m_converterTxtField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "Selected monitored directory or converter is invalid, please review your selections.", "Error", 0);
            return false;
        }
        return true;
    }

    private boolean ensureUniqueness() {
        File rootDirectory = new File(this.m_monitoredDirectory.getText());
        if (!rootDirectory.exists()) {
            return false;
        }
        String[] extensions = new String[]{"lock"};
        Collection files = FileUtils.listFiles((File)rootDirectory, (String[])extensions, (boolean)true);
        for (File file : files) {
            if (!file.getName().equals("mzdb.lock")) continue;
            long lastModified = file.lastModified();
            long currentTimestamp = System.currentTimeMillis();
            if (currentTimestamp - lastModified > 10000L) continue;
            JOptionPane.showMessageDialog(this, "An mzDB-wizard instance is already working on this folder. Choose another one or use the other running instance.", "Error", 0);
            return false;
        }
        return true;
    }

    public Answer getAnswer() {
        return this.m_answer;
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 10) {
            this.startAction();
        } else if (ke.getKeyCode() == 27) {
            this.cancelAction();
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    private boolean validateMgfConfiguration() {
        try {
            if (!this.m_doGenerateMgf) {
                return true;
            }
            if (!this.m_createMgfCommand.buildCommand()) {
                this.m_createMgfCommand.showErrorMessage();
                return false;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Check m/z tolerance and intensity cutoff.", "Invalid values", 0);
            return false;
        }
        return true;
    }

    private boolean validateUploadConfiguration() {
        if (this.m_doUpload && this.m_mountingPointComboBox.getSelectedIndex() == 0) {
            JOptionPane.showMessageDialog(this, "Check your mounting point.", "Invalid values", 0);
            return false;
        }
        return true;
    }

    private boolean validateOperations() {
        if (!(this.m_doConvert || this.m_doGenerateMgf || this.m_doUpload)) {
            JOptionPane.showMessageDialog(this, "Select at least one operation.", "Invalid configuration", 0);
        }
        return this.m_doConvert || this.m_doGenerateMgf || this.m_doUpload;
    }

    public static enum Answer {
        CANCEL,
        OK,
        NULL_ANSWER;

    }

    public static enum Step {
        CONFIG_STEP,
        REVIEW_STEP;

    }
}

