/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.gui.taskmanager;

import fr.profi.mzDBWizard.gui.log.LogsDialog;
import fr.profi.mzDBWizard.gui.taskmanager.TaskManagerTableModel;
import fr.profi.mzDBWizard.gui.taskmanager.renderer.DateTimeRenderer;
import fr.profi.mzDBWizard.gui.taskmanager.renderer.ErrorsNumberRenderer;
import fr.profi.mzDBWizard.gui.taskmanager.renderer.ExecutionStateRenderer;
import fr.profi.mzDBWizard.gui.taskmanager.renderer.FilenameRenderer;
import fr.profi.mzDBWizard.gui.taskmanager.renderer.TaskTypeRenderer;
import fr.profi.mzDBWizard.gui.util.DefaultIcons;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.info.TaskInfoManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerPanel
extends JPanel
implements ActionListener {
    private TaskManagerTableModel m_taskManagerModel;
    private JTable m_table;
    private JPopupMenu m_popupMenu;
    private JMenuItem logsItem;
    private JMenuItem clearItem;
    private JMenuItem clearAllItem;
    private JButton logsButton;
    private JButton clearButton;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().toString());

    public TaskManagerPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.initTasksPanel(), "Center");
    }

    private JPanel initTasksPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.m_taskManagerModel = new TaskManagerTableModel();
        this.m_table = new JTable(this.m_taskManagerModel);
        this.m_table.setFillsViewportHeight(true);
        this.m_table.getColumnModel().getColumn(0).setCellRenderer(new TaskTypeRenderer());
        this.m_table.getColumnModel().getColumn(1).setCellRenderer(new FilenameRenderer());
        this.m_table.getColumnModel().getColumn(2).setCellRenderer(new ExecutionStateRenderer());
        this.m_table.getColumnModel().getColumn(3).setCellRenderer(new DateTimeRenderer());
        this.m_table.getColumnModel().getColumn(4).setCellRenderer(new ErrorsNumberRenderer());
        this.m_table.setRowHeight(20);
        this.m_table.setSelectionMode(2);
        this.m_table.setComponentPopupMenu(this.addPopupMenu());
        JScrollPane scrollPane = new JScrollPane(this.m_table);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(Color.BLACK)));
        panel.add((Component)this.addToolBar(), "West");
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private JToolBar addToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setOrientation(1);
        toolbar.setFloatable(false);
        this.logsButton = new JButton(DefaultIcons.getSingleton().getIcon("document-horizontal-text.png"));
        this.logsButton.setFocusable(false);
        this.logsButton.addActionListener(this);
        this.logsButton.setActionCommand("Logs");
        this.logsButton.setToolTipText("Click to show the logs of the selected task");
        this.logsButton.setFocusPainted(false);
        this.logsButton.setOpaque(true);
        this.logsButton.setBorderPainted(false);
        toolbar.add(this.logsButton);
        this.clearButton = new JButton(DefaultIcons.getSingleton().getIcon("broom.png"));
        this.clearButton.setFocusable(false);
        this.clearButton.addActionListener(this);
        this.clearButton.setActionCommand("Clear");
        this.clearButton.setToolTipText("Click to clear the selected task");
        this.clearButton.setFocusPainted(false);
        this.clearButton.setOpaque(true);
        this.clearButton.setBorderPainted(false);
        toolbar.add(this.clearButton);
        this.updateButtons();
        ListSelectionModel cellSelectionModel = this.m_table.getSelectionModel();
        cellSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TaskManagerPanel.this.updateButtons();
            }
        });
        return toolbar;
    }

    private JPopupMenu addPopupMenu() {
        this.m_popupMenu = new JPopupMenu();
        this.logsItem = new JMenuItem("Logs", DefaultIcons.getSingleton().getIcon("document-horizontal-text.png"));
        this.logsItem.addActionListener(this);
        this.logsItem.setActionCommand("Logs");
        this.m_popupMenu.add(this.logsItem);
        this.clearItem = new JMenuItem("Clear", DefaultIcons.getSingleton().getIcon("broom.png"));
        this.clearItem.addActionListener(this);
        this.clearItem.setActionCommand("Clear");
        this.m_popupMenu.add(this.clearItem);
        this.clearAllItem = new JMenuItem("Clear All");
        this.clearAllItem.addActionListener(this);
        this.clearAllItem.setActionCommand("Clear All");
        this.m_popupMenu.add(this.clearAllItem);
        this.m_popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int[] selectedRows = TaskManagerPanel.this.m_table.getSelectedRows();
                        int nbSelectedRows = selectedRows.length;
                        int rowAtPoint = TaskManagerPanel.this.m_table.rowAtPoint(SwingUtilities.convertPoint(TaskManagerPanel.this.m_popupMenu, new Point(0, 0), TaskManagerPanel.this.m_table));
                        if (rowAtPoint != -1) {
                            boolean rowIsSelected = false;
                            for (int rowSelected : selectedRows) {
                                if (rowAtPoint != rowSelected) continue;
                                rowIsSelected = true;
                                break;
                            }
                            if (!rowIsSelected) {
                                TaskManagerPanel.this.m_table.setRowSelectionInterval(rowAtPoint, rowAtPoint);
                            }
                        }
                        TaskManagerPanel.this.logsItem.setEnabled(nbSelectedRows == 1);
                        boolean clear = nbSelectedRows >= 1;
                        for (int row : selectedRows) {
                            TaskInfo info = TaskManagerPanel.this.m_taskManagerModel.getTaskInfo(row = TaskManagerPanel.this.m_table.convertRowIndexToModel(row));
                            if (info.isFinished() || info.isAborted()) continue;
                            clear = false;
                            break;
                        }
                        TaskManagerPanel.this.clearItem.setEnabled(clear);
                        boolean clearAll = false;
                        int nbInfo = TaskManagerPanel.this.m_taskManagerModel.getRowCount();
                        for (int i = 0; i < nbInfo; ++i) {
                            TaskInfo info = TaskManagerPanel.this.m_taskManagerModel.getTaskInfo(i);
                            if (!info.isFinished() && !info.isAborted()) continue;
                            clearAll = true;
                            break;
                        }
                        TaskManagerPanel.this.clearAllItem.setEnabled(clearAll);
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        return this.m_popupMenu;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        block4: {
            block5: {
                int[] selectedRows;
                block3: {
                    selectedRows = this.m_table.getSelectedRows();
                    if (selectedRows.length == 0) {
                        return;
                    }
                    if (!ae.getActionCommand().equalsIgnoreCase("Logs")) break block3;
                    int row = this.m_table.getSelectedRow();
                    row = this.m_table.convertRowIndexToModel(row);
                    TaskInfo taskInfo = this.m_taskManagerModel.getTaskInfo(row);
                    LogsDialog.setParameters(this, taskInfo, 2);
                    LogsDialog logsDialog = LogsDialog.getInstance();
                    logsDialog.updateLogsDialog();
                    Thread thread = new Thread(logsDialog);
                    thread.start();
                    logsDialog.setVisible(true);
                    logsDialog.setModal(true);
                    break block4;
                }
                if (!ae.getActionCommand().equalsIgnoreCase("Clear")) break block5;
                for (int row : selectedRows) {
                    row = this.m_table.convertRowIndexToModel(row);
                    TaskInfo info = this.m_taskManagerModel.getTaskInfo(row);
                    TaskInfoManager.getTaskInfoManager().cancel(info.getSourceTaskInfo());
                }
                break block4;
            }
            if (!ae.getActionCommand().equalsIgnoreCase("Clear All")) break block4;
            int nbInfo = this.m_taskManagerModel.getRowCount();
            for (int i = 0; i < nbInfo; ++i) {
                TaskInfo info = this.m_taskManagerModel.getTaskInfo(i);
                if (!info.isFinished() && !info.isAborted()) continue;
                TaskInfoManager.getTaskInfoManager().cancel(info.getSourceTaskInfo());
            }
        }
    }

    private void updateButtons() {
        int[] selectedRows = this.m_table.getSelectedRows();
        int nbSelectedRows = selectedRows.length;
        this.logsButton.setEnabled(nbSelectedRows == 1);
        boolean clear = nbSelectedRows >= 1;
        for (int row : selectedRows) {
            TaskInfo info = this.m_taskManagerModel.getTaskInfo(row = this.m_table.convertRowIndexToModel(row));
            if (info.isFinished() || info.isAborted()) continue;
            clear = false;
            break;
        }
        this.clearButton.setEnabled(clear);
    }
}

