/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing;

import fr.profi.mgfboost.ui.command.MzdbCreateMgfCommand;
import fr.profi.mgfboost.ui.command.ui.AbstractCommandPanel;
import fr.profi.mgfboost.ui.command.ui.MzdbCreateMgfPanel;
import fr.profi.mzknife.CommandArguments;
import fr.profi.mzknife.mzdb.MgfBoostConfigTemplate;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateMgfCommand
extends MzdbCreateMgfCommand {
    private static final String INTENSITY_CUTOFF_KEY = "PROCESS_MGF_INTENSITY_CUTOFF";
    private static final String CLEAN_CONFIG_NAME_KEY = "PROCESS_MGF_CLEAN_CONFIG_NAME";
    private static final String PRECURSOR_COMPUTATION_METHOD_KEY = "PROCESS_MGF_PRECURSOR_COMPUTATION_METHOD";
    private static final String EXPORT_PROLINE_TITLE_KEY = "PROCESS_MGF_EXPORT_PROLINE_TITLE";
    private static final String MZ_TOLERANCE_KEY = "PROCESS_MGF_MZ_TOLERANCE";
    private static final String CLEAN_LABEL_METHOD_NAME_KEY = "PROCESS_MGF_CLEAN_LABEL_METHOD_NAME";
    private static final String CLEAN_METHOD_NAME_KEY = "PROCESS_MGF_CLEAN_METHOD_NAME";
    private static final String MGFBOOST_CONFIG_TEMPLATE_KEY = "PROCESS_MGF_MGFBOOST_CONFIG_NAME";
    private static float mz_tolerance = 10.0f;
    private static float intensity_cutoff = 0.0f;
    private static String precursor_computation_method = "main_precursor_mz";
    private static CreateMgfCommand instance;
    private final Logger logger = LoggerFactory.getLogger(CreateMgfCommand.class);
    private MgfBoostConfigTemplate boostConfigTemplate;

    private CreateMgfCommand() {
    }

    public static CreateMgfCommand getInstance() {
        if (instance == null) {
            instance = new CreateMgfCommand();
        }
        return instance;
    }

    @Override
    public AbstractCommandPanel<CommandArguments.MzDBCreateMgfCommand> getConfigurationPanel() {
        if (this.configurationPanel == null) {
            MzdbCreateMgfPanel panel = new MzdbCreateMgfPanel(false);
            panel.updatePanelFromCommand((CommandArguments.MzDBCreateMgfCommand)this.command);
            panel.setMgfBoostConfigTemplate(this.boostConfigTemplate);
            this.configurationPanel = panel;
        }
        return this.configurationPanel;
    }

    public Properties getCommandProperties() {
        Properties prop = new Properties();
        prop.setProperty(MZ_TOLERANCE_KEY, String.valueOf(((CommandArguments.MzDBCreateMgfCommand)this.command).mzTolPPM));
        prop.setProperty(INTENSITY_CUTOFF_KEY, String.valueOf(((CommandArguments.MzDBCreateMgfCommand)this.command).intensityCutoff));
        prop.setProperty(PRECURSOR_COMPUTATION_METHOD_KEY, ((CommandArguments.MzDBCreateMgfCommand)this.command).precMzComputation);
        prop.setProperty(EXPORT_PROLINE_TITLE_KEY, String.valueOf(((CommandArguments.MzDBCreateMgfCommand)this.command).exportProlineTitle));
        prop.setProperty(CLEAN_METHOD_NAME_KEY, ((CommandArguments.MzDBCreateMgfCommand)this.command).cleanMethod);
        prop.setProperty(CLEAN_LABEL_METHOD_NAME_KEY, ((CommandArguments.MzDBCreateMgfCommand)this.command).cleanLabelMethodName);
        prop.setProperty(CLEAN_CONFIG_NAME_KEY, ((CommandArguments.MzDBCreateMgfCommand)this.command).cleanConfig != null ? ((CommandArguments.MzDBCreateMgfCommand)this.command).cleanConfig.getConfigCommandValue() : "");
        if (((CommandArguments.MzDBCreateMgfCommand)this.command).precMzComputation.equalsIgnoreCase("mgf_boost")) {
            prop.setProperty(MGFBOOST_CONFIG_TEMPLATE_KEY, String.valueOf(((MzdbCreateMgfPanel)this.getConfigurationPanel()).getMgfBoostConfigTemplate()));
        } else {
            prop.setProperty(MGFBOOST_CONFIG_TEMPLATE_KEY, "");
        }
        return prop;
    }

    public void loadProperties(Properties prop) {
        CommandArguments.CleanConfig cfg;
        ((CommandArguments.MzDBCreateMgfCommand)this.command).mzTolPPM = Float.valueOf(Float.parseFloat(prop.getOrDefault((Object)MZ_TOLERANCE_KEY, Float.valueOf(mz_tolerance)).toString()));
        this.logger.debug("mz_tolerance: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).mzTolPPM);
        ((CommandArguments.MzDBCreateMgfCommand)this.command).intensityCutoff = Float.valueOf(Float.parseFloat(prop.getOrDefault((Object)INTENSITY_CUTOFF_KEY, Float.valueOf(intensity_cutoff)).toString()));
        this.logger.debug("mz_tolerance: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).intensityCutoff);
        if (prop.getProperty(PRECURSOR_COMPUTATION_METHOD_KEY) != null) {
            ((CommandArguments.MzDBCreateMgfCommand)this.command).precMzComputation = prop.getProperty(PRECURSOR_COMPUTATION_METHOD_KEY);
        }
        this.logger.debug("precMzComputation: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).precMzComputation);
        if (((CommandArguments.MzDBCreateMgfCommand)this.command).precMzComputation.equalsIgnoreCase("mgf_boost")) {
            String boostConfigTemplateStr = prop.getOrDefault((Object)MGFBOOST_CONFIG_TEMPLATE_KEY, MgfBoostConfigTemplate.DISCOVERY.toString()).toString();
            this.boostConfigTemplate = MgfBoostConfigTemplate.valueOf((String)boostConfigTemplateStr);
            ((CommandArguments.MzDBCreateMgfCommand)this.command).useHeader = this.boostConfigTemplate.isUseHeader();
            this.logger.debug("useHeader: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).useHeader);
            ((CommandArguments.MzDBCreateMgfCommand)this.command).useSelectionWindow = this.boostConfigTemplate.isUseSelectionWindow();
            this.logger.debug("useSelectionWindow: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).useSelectionWindow);
            ((CommandArguments.MzDBCreateMgfCommand)this.command).swMaxPrecursorsCount = this.boostConfigTemplate.getSwMaxPrecursorsCount();
            this.logger.debug("swMaxPrecursorsCount: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).swMaxPrecursorsCount);
            ((CommandArguments.MzDBCreateMgfCommand)this.command).swIntensityThreshold = Float.valueOf(this.boostConfigTemplate.getSwIntensityThreshold());
            this.logger.debug("swIntensityThreshold: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).swIntensityThreshold);
            ((CommandArguments.MzDBCreateMgfCommand)this.command).scanSelectorMode = this.boostConfigTemplate.getScanSelector();
            this.logger.debug("scanSelectorMode: " + String.valueOf(((CommandArguments.MzDBCreateMgfCommand)this.command).scanSelectorMode));
            ((CommandArguments.MzDBCreateMgfCommand)this.command).pifThreshold = this.boostConfigTemplate.getPifThreshold();
            this.logger.debug("pifThreshold: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).pifThreshold);
            ((CommandArguments.MzDBCreateMgfCommand)this.command).rankThreshold = this.boostConfigTemplate.getRankThreshold();
            this.logger.debug("rankThreshold: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).rankThreshold);
        }
        ((CommandArguments.MzDBCreateMgfCommand)this.command).exportProlineTitle = Boolean.parseBoolean(prop.getOrDefault((Object)EXPORT_PROLINE_TITLE_KEY, "false").toString());
        this.logger.debug("exportProlineTitle: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).exportProlineTitle);
        ((CommandArguments.MzDBCreateMgfCommand)this.command).cleanMethod = prop.getOrDefault((Object)CLEAN_METHOD_NAME_KEY, "").toString();
        this.logger.debug("cleanMethod: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).cleanMethod);
        ((CommandArguments.MzDBCreateMgfCommand)this.command).cleanLabelMethodName = prop.getOrDefault((Object)CLEAN_LABEL_METHOD_NAME_KEY, "").toString();
        this.logger.debug("cleanLabelMethodName: " + ((CommandArguments.MzDBCreateMgfCommand)this.command).cleanLabelMethodName);
        ((CommandArguments.MzDBCreateMgfCommand)this.command).cleanConfig = CommandArguments.CleanConfig.LABEL_FREE;
        if (prop.containsKey(CLEAN_CONFIG_NAME_KEY) && (cfg = CommandArguments.CleanConfig.getConfigFromCommandValue((String)prop.getProperty(CLEAN_CONFIG_NAME_KEY))) != null) {
            ((CommandArguments.MzDBCreateMgfCommand)this.command).cleanConfig = cfg;
        }
        this.logger.debug("cleanConfig: " + (((CommandArguments.MzDBCreateMgfCommand)this.command).cleanConfig != null ? ((CommandArguments.MzDBCreateMgfCommand)this.command).cleanConfig.getConfigCommandValue() : ""));
    }
}

