/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.info;

import fr.profi.mzDBWizard.processing.info.TaskError;
import fr.profi.mzDBWizard.processing.info.TaskInfoManager;
import java.util.ArrayList;

public class TaskInfo
implements Comparable<TaskInfo> {
    public static final int CONVERTER_TASK = 0;
    public static final int UPLOAD_TASK = 1;
    public static final int DELETE_TASK = 2;
    public static final int MOUNTING_POINT_TASK = 3;
    public static final int GENERATE_TASK = 4;
    public static final int PUBLIC_STATE_WAITING = 0;
    public static final int PUBLIC_STATE_RUNNING = 1;
    public static final int PUBLIC_STATE_ABORTED = 2;
    public static final int PUBLIC_STATE_FINISHED = 3;
    public static final int PUBLIC_STATE_FAILED = 4;
    public static final String[] PUBLIC_STATE_VALUES = new String[]{"Waiting", "Running", "Aborted", "Finished", "Failed"};
    public static final int STATE_WAITING = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_FINISHED = 2;
    public static final int STATE_ABORTED = 3;
    private int m_taskType;
    private String m_taskDescription = null;
    private String m_requestContent = null;
    private VisibilityEnum m_visibility = VisibilityEnum.VISIBLE;
    private int m_state;
    private int m_updateState = -1;
    private long m_askTimestamp = -1L;
    private long m_startTimestamp = -1L;
    private long m_endTimestamp = -1L;
    private float m_percentage = 0.0f;
    private long m_duration = -1L;
    private int m_id;
    private String m_jmsMessageID = null;
    private boolean m_askBeforeExitingApp;
    private boolean m_success;
    private TaskError m_taskError = null;
    private ArrayList<String> m_logs = new ArrayList();
    private int m_warningCount = 0;
    private TaskInfo m_srcTaskInfo = null;
    private static int INC_ID = 0;

    public TaskInfo(String taskDescription, int taskType, boolean askBeforeExitingApp) {
        this(taskDescription, taskType, askBeforeExitingApp, VisibilityEnum.VISIBLE);
    }

    public TaskInfo(String taskDescription, int taskType, boolean askBeforeExitingApp, VisibilityEnum visibility) {
        this.m_taskDescription = taskDescription;
        this.m_taskType = taskType;
        this.m_askBeforeExitingApp = askBeforeExitingApp;
        this.m_visibility = visibility;
        this.m_state = 0;
        this.m_id = INC_ID++;
        this.m_success = true;
        this.m_taskError = null;
        this.m_askTimestamp = System.currentTimeMillis();
    }

    public TaskInfo(TaskInfo src) {
        TaskInfo.copy(src, this);
    }

    public int getTaskType() {
        return this.m_taskType;
    }

    public void addLog(String log) {
        this.m_logs.add(log);
    }

    public void addWarning(String warning) {
        this.m_logs.add(warning);
        ++this.m_warningCount;
    }

    public int getWarningCount() {
        return this.m_warningCount;
    }

    public ArrayList<String> getLogs() {
        return this.m_logs;
    }

    public void insertLogs(ArrayList<String> logs) {
        ArrayList<String> logsConcatenated = new ArrayList<String>(logs);
        logsConcatenated.addAll(this.m_logs);
        this.m_logs = logsConcatenated;
    }

    public String getJmsMessageID() {
        return this.m_jmsMessageID;
    }

    public void setJmsMessageID(String jmsMsgId) {
        this.m_jmsMessageID = jmsMsgId;
    }

    public void setRunning(boolean saveTimestamp) {
        if (this.m_state == 1 || this.m_updateState == 1 || this.m_updateState == 2 || this.m_updateState == 3) {
            return;
        }
        this.m_updateState = 1;
        if (saveTimestamp) {
            this.m_startTimestamp = System.currentTimeMillis();
        }
        TaskInfoManager.getTaskInfoManager().update(this);
    }

    public void setRequestContent(String m_requestContent) {
        this.m_requestContent = m_requestContent;
    }

    public void setAborted() {
        this.m_updateState = 3;
        this.m_percentage = 0.0f;
        TaskInfoManager.getTaskInfoManager().update(this);
    }

    public void setFinished(boolean success, TaskError taskError, boolean saveTimestamp) {
        if (this.m_updateState == 3) {
            return;
        }
        if (this.m_updateState == 2) {
            saveTimestamp = false;
        }
        this.m_updateState = 2;
        if (saveTimestamp) {
            this.m_endTimestamp = this.m_startTimestamp == -1L ? -1L : System.currentTimeMillis();
        }
        this.m_percentage = 100.0f;
        this.m_success = success;
        this.m_taskError = taskError;
        TaskInfoManager.getTaskInfoManager().update(this);
    }

    public void setDuration(long duration) {
        this.m_duration = duration;
        TaskInfoManager.getTaskInfoManager().update(this, false);
    }

    public void update() {
        if (this.m_updateState != -1) {
            this.m_state = this.m_updateState;
            this.m_updateState = -1;
        }
    }

    public boolean isWaiting() {
        return this.m_state == 0;
    }

    public boolean isRunning() {
        return this.m_state == 1;
    }

    public boolean isFinished() {
        return this.m_state == 2;
    }

    public boolean isAborted() {
        return this.m_state == 3;
    }

    public boolean isSuccess() {
        return this.m_success;
    }

    public TaskError getTaskError() {
        return this.m_taskError;
    }

    public boolean hasTaskError() {
        return this.m_taskError != null;
    }

    public int getId() {
        return this.m_id;
    }

    public int getPublicState() {
        if (this.isWaiting()) {
            return 0;
        }
        if (this.isRunning()) {
            return 1;
        }
        if (this.isFinished()) {
            if (this.isSuccess()) {
                return 3;
            }
            return 4;
        }
        if (this.isAborted()) {
            return 2;
        }
        return 0;
    }

    public String getPublicStateAsString() {
        return PUBLIC_STATE_VALUES[this.getPublicState()];
    }

    public boolean askBeforeExitingApplication() {
        return this.m_askBeforeExitingApp;
    }

    public String getTaskDescription() {
        return this.m_taskDescription;
    }

    public String getRequestContent() {
        return this.m_requestContent;
    }

    public long getAskTimestamp() {
        return this.m_askTimestamp;
    }

    public long getStartTimestamp() {
        return this.m_startTimestamp;
    }

    public long getEndTimestamp() {
        return this.m_endTimestamp;
    }

    public boolean isVisible() {
        return this.m_visibility == VisibilityEnum.VISIBLE || this.m_visibility == VisibilityEnum.VISIBLE_IF_ERROR && this.m_taskError != null;
    }

    public long getDuration() {
        if (this.m_duration != -1L) {
            return this.m_duration;
        }
        if (this.m_endTimestamp != -1L && this.m_startTimestamp != -1L) {
            return this.m_endTimestamp - this.m_startTimestamp;
        }
        return -1L;
    }

    public long getDelay() {
        if (this.m_startTimestamp != -1L && this.m_askTimestamp != -1L) {
            return this.m_startTimestamp - this.m_askTimestamp;
        }
        return -1L;
    }

    @Override
    public int compareTo(TaskInfo o) {
        int cmp;
        int o_state;
        int state = this.m_state;
        if (state == 3) {
            state = 2;
        }
        if ((o_state = o.m_state) == 3) {
            o_state = 2;
        }
        if ((cmp = state - o_state) != 0) {
            return cmp;
        }
        return o.m_id - this.m_id;
    }

    public void copyData(TaskInfo dest) {
        TaskInfo.copy(this, dest);
    }

    private static void copy(TaskInfo from, TaskInfo to) {
        to.m_taskDescription = from.m_taskDescription;
        to.m_taskType = from.m_taskType;
        to.m_askBeforeExitingApp = from.m_askBeforeExitingApp;
        to.m_visibility = from.m_visibility;
        to.m_state = from.m_state;
        to.m_id = from.m_id;
        to.m_success = from.m_success;
        to.m_taskError = from.m_taskError;
        to.m_askTimestamp = from.m_askTimestamp;
        to.m_startTimestamp = from.m_startTimestamp;
        to.m_endTimestamp = from.m_endTimestamp;
        to.m_duration = from.m_duration;
        to.m_percentage = from.m_percentage;
        to.m_requestContent = from.m_requestContent;
        to.m_jmsMessageID = from.m_jmsMessageID;
        to.m_srcTaskInfo = from;
        to.m_logs = new ArrayList(from.m_logs.size());
        for (String log : from.m_logs) {
            to.m_logs.add(log);
        }
    }

    public TaskInfo getSourceTaskInfo() {
        return this.m_srcTaskInfo;
    }

    public String toString() {
        return "";
    }

    public static enum VisibilityEnum {
        VISIBLE,
        VISIBLE_IF_ERROR,
        HIDDEN;

    }
}

