/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.jms.task;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.jms.queue.AbstractJMSCallback;
import fr.profi.mzDBWizard.processing.jms.queue.AbstractJMSTask;
import fr.profi.mzDBWizard.processing.jms.queue.AccessJMSManagerThread;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.commons.io.FilenameUtils;

public class UploadFileJMSTask
extends AbstractJMSTask {
    private static final String SERVICE_NAME = "proline/misc/FileUpload";
    private File m_file2Upload;
    private final Path m_monitorDirectoryPath;
    private final String m_pathLabel;

    public UploadFileJMSTask(AbstractJMSCallback callback, File file2Upload, Path monitorDirectoryPath, String pathLabel) {
        super(callback, new TaskInfo("Upload File", 1, false, TaskInfo.VisibilityEnum.HIDDEN));
        this.m_file2Upload = file2Upload;
        this.m_monitorDirectoryPath = monitorDirectoryPath;
        this.m_pathLabel = pathLabel;
    }

    @Override
    public void taskRun() throws JMSException {
        InputStream in = null;
        try {
            BytesMessage message = AccessJMSManagerThread.getAccessJMSManagerThread().getSession().createBytesMessage();
            File uploadFile = this.m_file2Upload;
            String log = "Prepare to upload mzDB file " + this.m_file2Upload.getAbsolutePath();
            m_logger.debug(log);
            this.m_taskInfo.addLog(log);
            message.setJMSReplyTo((Destination)this.m_replyQueue);
            message.setStringProperty("Proline_ServiceName", SERVICE_NAME);
            Object destFileName = uploadFile.getAbsolutePath();
            if (((String)destFileName).endsWith(".mzDB")) {
                destFileName = ((String)destFileName).substring(0, ((String)destFileName).length() - 2) + "db";
            }
            message.setStringProperty("dest_file_name", FilenameUtils.getName((String)destFileName));
            String destFolderPath = this.m_pathLabel + File.separator + ((String)destFileName).substring(((String)destFileName).indexOf(this.m_monitorDirectoryPath.toAbsolutePath().toString()) + this.m_monitorDirectoryPath.toAbsolutePath().toString().length(), ((String)destFileName).lastIndexOf(FilenameUtils.getName((String)destFileName)));
            message.setStringProperty("dest_folder_path", destFolderPath);
            this.addSourceToMessage((Message)message);
            this.addDescriptionToMessage((Message)message);
            in = new FileInputStream(uploadFile);
            BufferedInputStream inBuf = new BufferedInputStream(in);
            message.setObjectProperty("JMS_HQ_InputStream", (Object)inBuf);
            this.setTaskInfoRequest("Call Service proline/misc/FileUpload with dest_file_name " + uploadFile.getName());
            this.m_producer.send((Message)message);
            m_logger.info("Message [{}] sent", (Object)message.getJMSMessageID());
            this.m_taskInfo.addLog("Message [" + message.getJMSMessageID() + "] sent");
            this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
        }
        catch (FileNotFoundException ex) {
            throw new JMSException(ex.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            String log = "JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response";
            m_logger.warn(log);
            this.m_taskInfo.addWarning(log);
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_logger.debug("JSON Response Id: " + String.valueOf(jsonResponse.getID()));
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_logger.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_logger.error("JSON Throwable", (Throwable)jsonError);
                this.m_taskInfo.addWarning("JSON Error code " + jsonError.getMessage() + ", message : \"+jsonError.getCode()+\"");
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !String.class.isInstance(result)) {
                m_logger.error(this.getClass().getSimpleName() + " failed : No returned values");
                throw new Exception("Invalid result " + String.valueOf(result));
            }
            String log = "Uploading for file: " + this.m_file2Upload.getAbsolutePath() + " has come to its end.";
            m_logger.info(log);
            this.m_taskInfo.addLog(log);
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

