/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.threading.task;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzDBWizard.processing.CreateMgfCommand;
import fr.profi.mzDBWizard.processing.info.TaskError;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.threading.AbstractCallback;
import fr.profi.mzDBWizard.processing.threading.task.AbstractFileTask;
import fr.profi.mzDBWizard.util.FileUtility;
import fr.profi.mzknife.CommandArguments;
import fr.profi.mzknife.MzDbProcessing;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public class CreateMgfFromMzdbCmdTask
extends AbstractFileTask {
    public CreateMgfFromMzdbCmdTask(AbstractCallback callback, File mzdbFile) {
        super(callback, new TaskInfo("Generate mgf from  " + mzdbFile.getName(), 4, true, TaskInfo.VisibilityEnum.VISIBLE), mzdbFile);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    protected boolean runTaskImplementation() throws Exception {
        this.logger.info("  -->  Generate MGF file from " + this.getFile().getName());
        FileUtility.checkFileFinalization(this.getFile());
        String log = "Starting to generate " + this.getFile().getAbsolutePath() + " to .mgf format.";
        this.logger.info(log);
        this.m_taskInfo.addLog(log);
        return this.generateMgf(this.getFile());
    }

    private boolean generateMgf(File mzdbFile) {
        try {
            String outputFileName = FilenameUtils.removeExtension((String)mzdbFile.getAbsolutePath()) + ".mgf";
            ((CommandArguments.MzDBCreateMgfCommand)CreateMgfCommand.getInstance().getCommand()).mzdbFile = mzdbFile.getAbsolutePath();
            ((CommandArguments.MzDBCreateMgfCommand)CreateMgfCommand.getInstance().getCommand()).outputFile = outputFileName;
            String log = " mgf file generated from " + mzdbFile.getAbsolutePath() + ".";
            this.logger.info(log);
            this.m_taskInfo.addLog(log);
            MzDbProcessing.mzdbcreateMgf((CommandArguments.MzDBCreateMgfCommand)((CommandArguments.MzDBCreateMgfCommand)CreateMgfCommand.getInstance().getCommand()));
            return true;
        }
        catch (SQLiteException ex) {
            this.m_taskError = new TaskError("Mgf generate Failure", "SQLiteException or ClassNotFoundException while generating mgf file");
            this.logger.error("SQLiteException or ClassNotFoundException while generating mgf file", (Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            this.m_taskError = new TaskError("Mgf Generate Failure", "Generation faced an IOException. Check input file's integrity.");
            this.logger.error("FileNotFoundException while generating mgf file : " + mzdbFile.getAbsolutePath().substring(0, mzdbFile.getAbsolutePath().lastIndexOf(".")) + ".mgf", (Throwable)ex);
        }
        catch (IOException ex) {
            this.m_taskError = new TaskError("Mgf Generate Failure", "Generation faced an IOException. Check input file's integrity.");
            this.logger.error("IOException while generating mgf file : " + mzdbFile.getAbsolutePath().substring(0, mzdbFile.getAbsolutePath().lastIndexOf(".")) + ".mgf", (Throwable)ex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }
}

