/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.ms.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class IsotopePatternInterpolator$
implements LazyLogging {
    public static IsotopePatternInterpolator$ MODULE$;
    private final TreeMap<Object, int[]> lookupTable;
    private final int[] lookupTableMasses;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new IsotopePatternInterpolator$();
    }

    private Logger logger$lzycompute() {
        IsotopePatternInterpolator$ isotopePatternInterpolator$ = this;
        synchronized (isotopePatternInterpolator$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public final String LOOKUP_TABLE_URL() {
        return "/lookup_table.txt";
    }

    public final double avgIsoMassDiff() {
        return 1.0027;
    }

    public TreeMap<Object, int[]> lookupTable() {
        return this.lookupTable;
    }

    public int[] lookupTableMasses() {
        return this.lookupTableMasses;
    }

    public TheoreticalIsotopePattern getTheoreticalPattern(double mz, int charge) {
        int idx;
        Tuple2.mcII.sp sp2;
        Predef$.MODULE$.require(charge > 0, (Function0 & Serializable & scala.Serializable)() -> "charge must be greater than zero");
        int[] keys = this.lookupTableMasses();
        DoubleRef mass = DoubleRef.create((double)fr.profi.util.ms.package$.MODULE$.mozToMass(mz, charge));
        ArrayOps.ofInt ofInt2 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys));
        if (mass.elem > (double)BoxesRunTime.unboxToInt((Object)ofInt2.last())) {
            mass.elem = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys)).last());
        }
        if ((sp2 = new Tuple2.mcII.sp(keys[(idx = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys)).indexWhere((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> (double)x$2 >= mass$1.elem)) - 1], keys[idx])) == null) {
            throw new MatchError((Object)sp2);
        }
        int x1 = sp2._1$mcI$sp();
        int x2 = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(x1, x2);
        Tuple2.mcII.sp sp4 = sp3;
        int x12 = sp4._1$mcI$sp();
        int x22 = sp4._2$mcI$sp();
        Tuple2 tuple2 = new Tuple2(this.lookupTable().apply((Object)BoxesRunTime.boxToInteger((int)x12)), this.lookupTable().apply((Object)BoxesRunTime.boxToInteger((int)x22)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] minArray = (int[])tuple2._1();
        int[] maxArray = (int[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)minArray, (Object)maxArray);
        Tuple2 tuple23 = tuple22;
        int[] minArray2 = (int[])tuple23._1();
        int[] maxArray2 = (int[])tuple23._2();
        ArrayBuffer mzIntPairs = new ArrayBuffer(minArray2.length);
        for (int i = 0; i < minArray2.length; ++i) {
            BoxedUnit boxedUnit;
            Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(minArray2[i], maxArray2[i]);
            if (sp5 == null) {
                throw new MatchError((Object)sp5);
            }
            int y1 = sp5._1$mcI$sp();
            int y2 = sp5._2$mcI$sp();
            Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(y1, y2);
            Tuple2.mcII.sp sp7 = sp6;
            int y12 = sp7._1$mcI$sp();
            int y22 = sp7._2$mcI$sp();
            if (y12 > 0 || y22 > 0) {
                Tuple2 tuple24 = fr.profi.util.math.package$.MODULE$.calcLineParams((double)x12, (double)y12, (double)x22, (double)y22);
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                double slope = tuple24._1$mcD$sp();
                double intercept = tuple24._2$mcD$sp();
                Tuple2.mcDD.sp sp8 = new Tuple2.mcDD.sp(slope, intercept);
                Tuple2.mcDD.sp sp9 = sp8;
                double slope2 = sp9._1$mcD$sp();
                double intercept2 = sp9._2$mcD$sp();
                float abundance = (float)(slope2 * mass.elem + intercept2);
                double isoMz = mz + (double)i * 1.0027 / (double)charge;
                boxedUnit = mzIntPairs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)isoMz)), (Object)BoxesRunTime.boxToFloat((float)abundance)));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return new TheoreticalIsotopePattern((Tuple2[])mzIntPairs.toArray(ClassTag$.MODULE$.apply(Tuple2.class)), charge);
    }

    public double calcAbundancesRmsd(float[] theoInt, float[] obsInt) {
        float maxObsInt = BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(obsInt)).max((Ordering)Ordering.Float$.MODULE$));
        float[] scaledInt = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(obsInt)).map((Function1)(JFunction1.mcFF.sp & Serializable & scala.Serializable)x$7 -> x$7 * (float)100 / maxObsInt, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        double s2 = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(theoInt)).zip((GenIterable)Predef$.MODULE$.wrapFloatArray(scaledInt), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(s, ab) -> BoxesRunTime.boxToDouble((double)IsotopePatternInterpolator$.$anonfun$calcAbundancesRmsd$2(BoxesRunTime.unboxToDouble((Object)s), ab))));
        return package$.MODULE$.sqrt(s2);
    }

    public static final /* synthetic */ int $anonfun$lookupTable$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ double $anonfun$calcAbundancesRmsd$2(double s, Tuple2 ab) {
        return s + package$.MODULE$.pow((double)(BoxesRunTime.unboxToFloat((Object)ab._1()) - BoxesRunTime.unboxToFloat((Object)ab._2())), 2.0);
    }

    private IsotopePatternInterpolator$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        ArrayBuffer rows = new ArrayBuffer();
        Source$.MODULE$.fromURL(this.getClass().getResource("/lookup_table.txt"), Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> rows.$plus$eq(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split("\t"))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)IsotopePatternInterpolator$.$anonfun$lookupTable$2(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))));
        int maxIsotopesCount = ((int[])rows.last()).length - 1;
        Builder tableBuilder = TreeMap$.MODULE$.newBuilder((Ordering)Ordering.Int$.MODULE$);
        rows.foreach((Function1 & Serializable & scala.Serializable)row -> {
            int[] pattern = (int[])Array$.MODULE$.fill(maxIsotopesCount, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
            Array$.MODULE$.copy(row, 1, (Object)pattern, 0, new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(row)).size() - 1);
            return tableBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(row)).head()), (Object)pattern));
        });
        this.lookupTable = (TreeMap)tableBuilder.result();
        this.lookupTableMasses = (int[])this.lookupTable().keys().toArray(ClassTag$.MODULE$.Int());
    }
}

