/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.BBSizes;
import fr.profi.mzdb.XicMethod;
import fr.profi.mzdb.db.model.IMzDBParamNameGetter;
import fr.profi.mzdb.db.model.InstrumentConfiguration;
import fr.profi.mzdb.db.model.MzDbHeader;
import fr.profi.mzdb.db.model.Run;
import fr.profi.mzdb.db.model.Sample;
import fr.profi.mzdb.db.model.SharedParamTree;
import fr.profi.mzdb.db.model.Software;
import fr.profi.mzdb.db.model.SourceFile;
import fr.profi.mzdb.db.model.params.ParamTree;
import fr.profi.mzdb.db.model.params.param.CV;
import fr.profi.mzdb.db.model.params.param.CVEntry;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.model.params.param.CVTerm;
import fr.profi.mzdb.db.model.params.param.CVUnit;
import fr.profi.mzdb.db.model.params.param.UserTerm;
import fr.profi.mzdb.db.model.params.param.UserText;
import fr.profi.mzdb.db.table.BoundingBoxTable;
import fr.profi.mzdb.io.reader.MzDbReaderQueries;
import fr.profi.mzdb.io.reader.bb.BoundingBoxBuilder;
import fr.profi.mzdb.io.reader.bb.IBlobReader;
import fr.profi.mzdb.io.reader.cache.AbstractDataEncodingReader;
import fr.profi.mzdb.io.reader.cache.AbstractRunSliceHeaderReader;
import fr.profi.mzdb.io.reader.cache.AbstractSpectrumHeaderReader;
import fr.profi.mzdb.io.reader.cache.MzDbEntityCache;
import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.BoundingBox;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.IonMobilityMode;
import fr.profi.mzdb.model.IonMobilityType;
import fr.profi.mzdb.model.IsolationWindow;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.RunSliceData;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.mzdb.util.ms.MsUtils;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import fr.profi.mzdb.util.sqlite.SQLiteRecordIterator;
import java.io.File;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMzDbReader {
    public static String ThermoConverterName = "ThermoAccess";
    public static String TimsTofConverterName = "ttofConverter";
    protected final Logger logger = LoggerFactory.getLogger(AbstractMzDbReader.class);
    protected final BBSizes bbSizes = new BBSizes();
    protected File dbLocation = null;
    protected MzDbEntityCache entityCache = null;
    protected MzDbHeader mzDbHeader = null;
    protected IMzDBParamNameGetter _paramNameGetter = null;
    private boolean _loadParamTree = false;
    private boolean _loadScanList = false;
    private boolean _loadPrecursorList = false;
    private boolean _cacheDataAsString = false;
    protected Boolean isNoLossMode;
    protected AcquisitionMode acquisitionMode = null;
    protected Optional<IonMobilityMode> ionMobility = null;
    protected IsolationWindow[] diaIsolationWindows = null;
    protected List<InstrumentConfiguration> instrumentConfigs = null;
    protected List<Run> runs = null;
    protected List<Sample> samples = null;
    protected List<Software> softwareList = null;
    protected List<SourceFile> sourceFiles = null;
    protected List<SharedParamTree> sharedParamTrees = null;
    protected List<CV> allCVs = null;
    protected List<CVTerm> cvTerms = null;
    protected List<CVUnit> cvUnits = null;
    protected List<UserTerm> userTerms = null;

    public abstract void close();

    public abstract AbstractDataEncodingReader getDataEncodingReader();

    public abstract AbstractSpectrumHeaderReader getSpectrumHeaderReader();

    public abstract AbstractRunSliceHeaderReader getRunSliceHeaderReader();

    public boolean isStringRepresentationCacheEnabled() {
        return this._cacheDataAsString;
    }

    public void enableDataStringCache() {
        this._cacheDataAsString = true;
    }

    public boolean isParamTreeLoadingEnabled() {
        return this._loadParamTree;
    }

    public void enableParamTreeLoading() {
        this._loadParamTree = true;
    }

    public boolean isScanListLoadingEnabled() {
        return this._loadScanList;
    }

    public void enableScanListLoading() {
        this._loadScanList = true;
    }

    public boolean isPrecursorListLoadingEnabled() {
        return this._loadPrecursorList;
    }

    public void enablePrecursorListLoading() {
        this._loadPrecursorList = true;
    }

    public MzDbEntityCache getEntityCache() {
        return this.entityCache;
    }

    public String getDbLocation() {
        return this.dbLocation.getAbsolutePath();
    }

    public MzDbHeader getMzDbHeader() throws SQLiteException {
        return this.mzDbHeader;
    }

    public boolean isNoLossMode() throws SQLiteException {
        if (this.isNoLossMode == null) {
            MzDbHeader p = this.getMzDbHeader();
            this.isNoLossMode = p.getUserParam(this._paramNameGetter.getLossStateParamName()).getValue().equals("false") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return this.isNoLossMode;
    }

    public BBSizes getBBSizes() throws SQLiteException {
        return this.bbSizes;
    }

    protected void _setBBSizes(IMzDBParamNameGetter paramNameGetter) {
        this.bbSizes.BB_MZ_HEIGHT_MS1 = Double.parseDouble(this.mzDbHeader.getUserParam(paramNameGetter.getMs1BBMzWidthParamName()).getValue());
        this.bbSizes.BB_MZ_HEIGHT_MSn = Double.parseDouble(this.mzDbHeader.getUserParam(paramNameGetter.getMsnBBMzWidthParamName()).getValue());
        this.bbSizes.BB_RT_WIDTH_MS1 = Float.parseFloat(this.mzDbHeader.getUserParam(paramNameGetter.getMs1BBTimeWidthParamName()).getValue());
        this.bbSizes.BB_RT_WIDTH_MSn = Float.parseFloat(this.mzDbHeader.getUserParam(paramNameGetter.getMs1BBTimeWidthParamName()).getValue());
    }

    protected RunSliceData getRunSliceData(int runSliceId, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        String queryStr = "SELECT * FROM bounding_box WHERE run_slice_id = ? ORDER BY first_spectrum_id";
        SQLiteRecordIterator records = new SQLiteQuery(connection, queryStr).bind(1, runSliceId).getRecordIterator();
        ArrayList<BoundingBox> bbs = new ArrayList<BoundingBox>();
        Map<Long, SpectrumHeader> spectrumHeaderById = this.getSpectrumHeaderReader().getMs1SpectrumHeaderById(connection);
        Map<Long, DataEncoding> dataEncodingBySpectrumId = this.getDataEncodingReader().getDataEncodingBySpectrumId(connection);
        while (records.hasNext()) {
            SQLiteRecord record = records.next();
            int bbId = record.columnInt(BoundingBoxTable.ID);
            byte[] data = record.columnBlob(BoundingBoxTable.DATA);
            int firstSpectrumId = record.columnInt(BoundingBoxTable.FIRST_SPECTRUM_ID);
            int lastSpectrumId = record.columnInt(BoundingBoxTable.LAST_SPECTRUM_ID);
            BoundingBox bb = BoundingBoxBuilder.buildBB(bbId, data, (long)firstSpectrumId, (long)lastSpectrumId, spectrumHeaderById, dataEncodingBySpectrumId);
            bb.setRunSliceId(runSliceId);
            bbs.add(bb);
        }
        ArrayList<SpectrumSlice> spectrumSliceList = new ArrayList<SpectrumSlice>();
        for (BoundingBox bb : bbs) {
            SpectrumSlice[] sl;
            for (SpectrumSlice ss : sl = bb.toSpectrumSlices()) {
                spectrumSliceList.add(ss);
            }
        }
        return new RunSliceData(runSliceId, spectrumSliceList.toArray(new SpectrumSlice[spectrumSliceList.size()]));
    }

    protected SpectrumData getSpectrumData(long spectrumId, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        Map<Long, SpectrumHeader> spectrumHeaderById = this.getSpectrumHeaderReader().getSpectrumHeaderById(connection);
        Map<Long, DataEncoding> dataEncodingBySpectrumId = this.getDataEncodingReader().getDataEncodingBySpectrumId(connection);
        long firstSpectrumId = spectrumHeaderById.get(spectrumId).getBBFirstSpectrumId();
        String sqlString = "SELECT * FROM bounding_box WHERE bounding_box.first_spectrum_id = ?";
        SQLiteRecordIterator records = new SQLiteQuery(connection, sqlString).bind(1, firstSpectrumId).getRecordIterator();
        ArrayList<BoundingBox> bbS = new ArrayList<BoundingBox>();
        while (records.hasNext()) {
            SQLiteRecord r = records.next();
            int lastSpectrumId = r.columnInt(BoundingBoxTable.LAST_SPECTRUM_ID);
            BoundingBox bb = BoundingBoxBuilder.buildBB(r.columnInt(BoundingBoxTable.ID), r.columnBlob(BoundingBoxTable.DATA), firstSpectrumId, (long)lastSpectrumId, spectrumHeaderById, dataEncodingBySpectrumId);
            bb.setRunSliceId(r.columnInt(BoundingBoxTable.RUN_SLICE_ID));
            bbS.add(bb);
        }
        SpectrumData sd = new SpectrumData(new double[0], new float[0]);
        block1: for (BoundingBox bb : bbS) {
            IBlobReader bbReader = bb.getReader();
            int nbSpectra = bb.getSpectraCount();
            for (int spectrumIdx = 0; spectrumIdx < nbSpectra; ++spectrumIdx) {
                if (spectrumId != bbReader.getSpectrumIdAt(spectrumIdx)) continue;
                sd.addSpectrumData(bbReader.readSpectrumSliceDataAt(spectrumIdx));
                continue block1;
            }
        }
        return sd;
    }

    protected Spectrum getSpectrum(long spectrumId, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        SpectrumHeader sh = this.getSpectrumHeaderReader().getSpectrumHeader(spectrumId, connection);
        SpectrumData sd = this.getSpectrumData(spectrumId, connection);
        return new Spectrum(sh, sd);
    }

    protected Peak[] getSpectrumPeaks(int spectrumId, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        return this.getSpectrum(spectrumId, connection).toPeaks();
    }

    protected SpectrumSlice[] getMsSpectrumSlices(double minMz, double maxMz, float minRt, float maxRt, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        return this._getSpectrumSlicesInRanges(minMz, maxMz, minRt, maxRt, 1, 0.0, connection);
    }

    protected SpectrumSlice[] getMsnSpectrumSlices(double parentMz, double minFragMz, double maxFragMz, float minRt, float maxRt, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        return this._getSpectrumSlicesInRanges(minFragMz, maxFragMz, minRt, maxRt, 2, parentMz, connection);
    }

    private SpectrumSlice[] _getSpectrumSlicesInRanges(double minMz, double maxMz, float minRt, float maxRt, int msLevel, double parentMz, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        SQLiteQuery sqliteQuery;
        BBSizes sizes = this.getBBSizes();
        float rtWidth = msLevel == 1 ? sizes.BB_RT_WIDTH_MS1 : sizes.BB_RT_WIDTH_MSn;
        double mzHeight = msLevel == 1 ? sizes.BB_MZ_HEIGHT_MS1 : sizes.BB_MZ_HEIGHT_MSn;
        double _minMz = minMz - mzHeight;
        double _maxMz = maxMz + mzHeight;
        float _minRt = minRt - rtWidth;
        float _maxRt = maxRt + rtWidth;
        if (msLevel == 1) {
            sqlQuery = "SELECT * FROM bounding_box WHERE id IN (SELECT id FROM bounding_box_rtree WHERE min_mz >= ? AND max_mz <= ? AND min_time >= ? AND max_time <= ? ) ORDER BY first_spectrum_id";
            sqliteQuery = new SQLiteQuery(connection, (String)sqlQuery, false).bind(1, _minMz).bind(2, _maxMz).bind(3, _minRt).bind(4, _maxRt);
        } else {
            sqlQuery = "SELECT * FROM bounding_box WHERE id IN (SELECT id FROM bounding_box_msn_rtree WHERE min_ms_level = " + msLevel + " AND max_ms_level = " + msLevel + " AND min_parent_mz <= ? AND max_parent_mz >= ?  AND min_mz >= ? AND max_mz <= ? AND min_time >= ? AND max_time <= ? ) ORDER BY first_spectrum_id";
            sqliteQuery = new SQLiteQuery(connection, (String)sqlQuery, false).bind(1, parentMz).bind(2, parentMz).bind(3, _minMz).bind(4, _maxMz).bind(5, _minRt).bind(6, _maxRt);
        }
        SQLiteRecordIterator recordIter = sqliteQuery.getRecordIterator();
        Map<Long, SpectrumHeader> spectrumHeaderById = null;
        if (msLevel == 1) {
            spectrumHeaderById = this.getSpectrumHeaderReader().getMs1SpectrumHeaderById(connection);
        } else if (msLevel == 2) {
            spectrumHeaderById = this.getSpectrumHeaderReader().getMs2SpectrumHeaderById(connection);
        } else {
            throw new IllegalArgumentException("unsupported MS level: " + msLevel);
        }
        Map<Long, DataEncoding> dataEncodingBySpectrumId = this.getDataEncodingReader().getDataEncodingBySpectrumId(connection);
        TreeMap spectrumDataListById = new TreeMap();
        HashMap<Long, Integer> peaksCountBySpectrumId = new HashMap<Long, Integer>();
        while (recordIter.hasNext()) {
            SQLiteRecord record = recordIter.next();
            int bbId = record.columnInt(BoundingBoxTable.ID);
            byte[] data = record.columnBlob(BoundingBoxTable.DATA);
            long firstSpectrumId = record.columnLong(BoundingBoxTable.FIRST_SPECTRUM_ID);
            long lastSpectrumId = record.columnLong(BoundingBoxTable.LAST_SPECTRUM_ID);
            BoundingBox bb = BoundingBoxBuilder.buildBB(bbId, data, firstSpectrumId, lastSpectrumId, spectrumHeaderById, dataEncodingBySpectrumId);
            IBlobReader bbReader = bb.getReader();
            int bbSpectraCount = bbReader.getSpectraCount();
            long[] bbSpectrumIds = bbReader.getAllSpectrumIds();
            for (int spectrumIdx = 0; spectrumIdx < bbSpectraCount; ++spectrumIdx) {
                SpectrumData spectrumSliceData;
                long spectrumId = bbSpectrumIds[spectrumIdx];
                SpectrumHeader sh = spectrumHeaderById.get(spectrumId);
                float currentRt = sh.getElutionTime();
                if (!(currentRt >= minRt) || !(currentRt <= maxRt) || (spectrumSliceData = bbReader.readFilteredSpectrumSliceDataAt(spectrumIdx, minMz, maxMz)).isEmpty()) continue;
                if (!spectrumDataListById.containsKey(spectrumId)) {
                    spectrumDataListById.put(spectrumId, new ArrayList());
                    peaksCountBySpectrumId.put(spectrumId, 0);
                }
                ((ArrayList)spectrumDataListById.get(spectrumId)).add(spectrumSliceData);
                peaksCountBySpectrumId.put(spectrumId, (Integer)peaksCountBySpectrumId.get(spectrumId) + spectrumSliceData.getPeaksCount());
            }
        }
        SpectrumSlice[] finalSpectrumSlices = new SpectrumSlice[spectrumDataListById.size()];
        int spectrumIdx = 0;
        for (Map.Entry entry : spectrumDataListById.entrySet()) {
            Long spectrumId = (Long)entry.getKey();
            ArrayList spectrumDataList = (ArrayList)entry.getValue();
            int peaksCount = (Integer)peaksCountBySpectrumId.get(spectrumId);
            SpectrumData finalSpectrumData = this._mergeSpectrumDataList(spectrumDataList, peaksCount);
            finalSpectrumSlices[spectrumIdx] = new SpectrumSlice(spectrumHeaderById.get(spectrumId), finalSpectrumData);
            ++spectrumIdx;
        }
        return finalSpectrumSlices;
    }

    private SpectrumData _mergeSpectrumDataList(ArrayList<SpectrumData> spectrumDataList, int peaksCount) {
        double[] finalMzList = new double[peaksCount];
        float[] finalIntensityList = new float[peaksCount];
        float[] finalLeftHwhmList = null;
        float[] finalRightHwhmList = null;
        SpectrumData firstSpectrumData = spectrumDataList.get(0);
        if (firstSpectrumData.getLeftHwhmList() != null && firstSpectrumData.getRightHwhmList() != null) {
            finalLeftHwhmList = new float[peaksCount];
            finalRightHwhmList = new float[peaksCount];
        }
        int finalPeakIdx = 0;
        for (SpectrumData spectrumData : spectrumDataList) {
            double[] mzList = spectrumData.getMzList();
            float[] intensityList = spectrumData.getIntensityList();
            float[] leftHwhmList = spectrumData.getLeftHwhmList();
            float[] rightHwhmList = spectrumData.getRightHwhmList();
            int spectrumDataPeaksCount = spectrumData.getPeaksCount();
            for (int i = 0; i < spectrumDataPeaksCount; ++i) {
                finalMzList[finalPeakIdx] = mzList[i];
                finalIntensityList[finalPeakIdx] = intensityList[i];
                if (finalLeftHwhmList != null && finalRightHwhmList != null) {
                    finalLeftHwhmList[finalPeakIdx] = leftHwhmList[i];
                    finalRightHwhmList[finalPeakIdx] = rightHwhmList[i];
                }
                ++finalPeakIdx;
            }
        }
        return new SpectrumData(finalMzList, finalIntensityList, finalLeftHwhmList, finalRightHwhmList);
    }

    protected AcquisitionMode getAcquisitionMode(SQLiteConnection connection) throws SQLiteException {
        if (this.acquisitionMode == null) {
            List<Run> runs = this.getRuns();
            Run run0 = runs.get(0);
            ParamTree runTree = run0.getParamTree(connection);
            try {
                CVParam cvParam = runTree.getCVParam(CVEntry.ACQUISITION_PARAMETER);
                String value = cvParam.getValue();
                this.acquisitionMode = AcquisitionMode.getAcquisitionMode(value);
            }
            catch (Exception e) {
                this.acquisitionMode = AcquisitionMode.UNKNOWN;
            }
        }
        return this.acquisitionMode;
    }

    protected List<String> extractFromInstrumentMethod(String prefix) throws SQLiteException {
        List<UserText> userParams = this.getMzDbHeader().getUserTexts();
        ArrayList<String> extractedLines = new ArrayList<String>();
        if (userParams != null && !userParams.isEmpty()) {
            for (UserText userText : userParams) {
                String USER_TEXT_TAG = "instrumentMethods";
                if (!"instrumentMethods".equals(userText.getName())) continue;
                String instrumMethods = userText.getText();
                Scanner scanner = new Scanner(instrumMethods);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith(prefix)) continue;
                    extractedLines.add(line);
                }
            }
        }
        return extractedLines;
    }

    protected IonMobilityMode getIonMobilityMode(SQLiteConnection connection) throws SQLiteException {
        if (this.ionMobility == null) {
            this.ionMobility = Optional.empty();
            ArrayList<String> compensationVoltageValues = new ArrayList<String>();
            for (String line : this.extractFromInstrumentMethod("FAIMS CV")) {
                String cvName = line.substring(8).trim();
                if (cvName.startsWith("=")) {
                    cvName = cvName.substring(1);
                }
                compensationVoltageValues.add(cvName.trim());
            }
            if (!compensationVoltageValues.isEmpty()) {
                this.ionMobility = Optional.of(new IonMobilityMode(IonMobilityType.FAIMS, compensationVoltageValues));
            }
        }
        return this.ionMobility.orElse(null);
    }

    protected IsolationWindow[] getDIAIsolationWindows(SQLiteConnection connection) throws SQLiteException {
        if (this.diaIsolationWindows == null) {
            String sqlQuery = "SELECT DISTINCT min_parent_mz, max_parent_mz FROM bounding_box_msn_rtree ORDER BY min_parent_mz";
            SQLiteRecordIterator recordIt = new SQLiteQuery(connection, "SELECT DISTINCT min_parent_mz, max_parent_mz FROM bounding_box_msn_rtree ORDER BY min_parent_mz").getRecordIterator();
            ArrayList<IsolationWindow> isolationWindowList = new ArrayList<IsolationWindow>();
            while (recordIt.hasNext()) {
                SQLiteRecord record = recordIt.next();
                Double minMz = record.columnDouble("min_parent_mz");
                Double maxMz = record.columnDouble("max_parent_mz");
                isolationWindowList.add(new IsolationWindow(minMz, maxMz));
            }
            this.diaIsolationWindows = isolationWindowList.toArray(new IsolationWindow[isolationWindowList.size()]);
        }
        return this.diaIsolationWindows;
    }

    public abstract List<InstrumentConfiguration> getInstrumentConfigurations() throws SQLiteException;

    public abstract List<Run> getRuns() throws SQLiteException;

    public abstract List<Sample> getSamples() throws SQLiteException;

    public abstract List<Software> getSoftwareList() throws SQLiteException;

    public abstract List<SourceFile> getSourceFiles() throws SQLiteException;

    public String getFirstSourceFileName() throws SQLiteException {
        return this.getSourceFiles().get(0).getName();
    }

    protected Peak[] getMsXicInMzRange(double minMz, double maxMz, XicMethod method, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        return this.getMsXicInMzRtRanges(minMz, maxMz, -1.0f, -1.0f, method, connection);
    }

    protected Peak[] getMsXicInMzRtRanges(double minMz, double maxMz, float minRt, float maxRt, XicMethod method, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        double mzCenter = (minMz + maxMz) / 2.0;
        double mzTolInDa = maxMz - mzCenter;
        return this.getMsXic(mzCenter, mzTolInDa, minRt, maxRt, method, connection);
    }

    protected Peak[] getMsXic(double mz, double mzTolInDa, float minRt, float maxRt, XicMethod method, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        double minMz = mz - mzTolInDa;
        double maxMz = mz + mzTolInDa;
        float minRtForRtree = minRt >= 0.0f ? minRt : 0.0f;
        float maxRtForRtree = maxRt > 0.0f ? maxRt : MzDbReaderQueries.getLastTime(connection);
        SpectrumSlice[] spectrumSlices = this.getMsSpectrumSlices(minMz, maxMz, minRtForRtree, maxRtForRtree, connection);
        double mzTolPPM = MsUtils.DaToPPM(mz, mzTolInDa);
        return this._spectrumSlicesToXIC(spectrumSlices, mz, mzTolPPM, method);
    }

    protected Peak[] getMsnXic(double parentMz, double fragmentMz, double fragmentMzTolInDa, float minRt, float maxRt, XicMethod method, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        double minFragMz = fragmentMz - fragmentMzTolInDa;
        double maxFragMz = fragmentMz + fragmentMzTolInDa;
        float minRtForRtree = minRt >= 0.0f ? minRt : 0.0f;
        float maxRtForRtree = maxRt > 0.0f ? maxRt : MzDbReaderQueries.getLastTime(connection);
        SpectrumSlice[] spectrumSlices = this.getMsnSpectrumSlices(parentMz, minFragMz, maxFragMz, minRtForRtree, maxRtForRtree, connection);
        double fragMzTolPPM = MsUtils.DaToPPM(fragmentMz, fragmentMzTolInDa);
        return this._spectrumSlicesToXIC(spectrumSlices, fragmentMz, fragMzTolPPM, method);
    }

    private Peak[] _spectrumSlicesToXIC(SpectrumSlice[] spectrumSlices, double searchedMz, double mzTolPPM, XicMethod method) throws SQLiteException, StreamCorruptedException {
        if (spectrumSlices == null) {
            this.logger.warn("null detected");
        }
        if (spectrumSlices.length == 0) {
            return new Peak[0];
        }
        int spectrumSlicesCount = spectrumSlices.length;
        ArrayList<Peak> xicPeaks = new ArrayList<Peak>(spectrumSlicesCount);
        switch (method) {
            case MAX: {
                for (int i = 0; i < spectrumSlicesCount; ++i) {
                    SpectrumSlice sl = spectrumSlices[i];
                    Peak[] peaks = sl.toPeaks();
                    int peaksCount = peaks.length;
                    if (peaksCount == 0) continue;
                    Arrays.sort(peaks, Peak.getIntensityComp());
                    xicPeaks.add(peaks[peaksCount - 1]);
                }
                return xicPeaks.toArray(new Peak[xicPeaks.size()]);
            }
            case NEAREST: {
                for (int i = 0; i < spectrumSlicesCount; ++i) {
                    SpectrumSlice sl = spectrumSlices[i];
                    SpectrumData slData = sl.getData();
                    if (slData.isEmpty()) continue;
                    Peak nearestPeak = sl.getNearestPeak(searchedMz, mzTolPPM);
                    if (nearestPeak == null) {
                        this.logger.error("nearest peak is null but should not be: searchedMz=" + searchedMz + " minMz=" + slData.getMzList()[0] + " tol=" + mzTolPPM);
                        continue;
                    }
                    xicPeaks.add(nearestPeak);
                }
                return xicPeaks.toArray(new Peak[xicPeaks.size()]);
            }
            case SUM: {
                for (int i = 0; i < spectrumSlicesCount; ++i) {
                    SpectrumSlice sl = spectrumSlices[i];
                    Peak[] peaks = sl.toPeaks();
                    int peaksCount = peaks.length;
                    if (peaksCount == 0) continue;
                    Arrays.sort(peaks, Peak.getIntensityComp());
                    float sum = 0.0f;
                    for (Peak p : peaks) {
                        sum += p.getIntensity();
                    }
                    Peak refPeak = peaks[(int)Math.floor(0.5 * (double)peaksCount)];
                    xicPeaks.add(new Peak(refPeak.getMz(), sum, refPeak.getLeftHwhm(), refPeak.getRightHwhm(), refPeak.getLcContext()));
                }
                return xicPeaks.toArray(new Peak[xicPeaks.size()]);
            }
        }
        this.logger.error("[_spectrumSlicesToXIC]: method must be one of 'MAX', 'NEAREST' or 'SUM', returning null");
        return null;
    }

    protected Peak[] getMsPeaksInMzRtRanges(double minMz, double maxMz, float minRt, float maxRt, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        SpectrumSlice[] spectrumSlices = this.getMsSpectrumSlices(minMz, maxMz, minRt, maxRt, connection);
        return this._spectrumSlicesToPeaks(spectrumSlices);
    }

    protected Peak[] getMsnPeaksInMzRtRanges(double parentMz, double minFragMz, double maxFragMz, float minRt, float maxRt, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        SpectrumSlice[] spectrumSlices = this.getMsnSpectrumSlices(parentMz, minFragMz, maxFragMz, minRt, maxRt, connection);
        return this._spectrumSlicesToPeaks(spectrumSlices);
    }

    private Peak[] _spectrumSlicesToPeaks(SpectrumSlice[] spectrumSlices) {
        this.logger.debug("SpectrumSlice length : {}", (Object)spectrumSlices.length);
        if (spectrumSlices.length == 0) {
            return new Peak[0];
        }
        int mergedPeaksCount = 0;
        for (SpectrumSlice spectrumSlice : spectrumSlices) {
            SpectrumData sd = spectrumSlice.getData();
            mergedPeaksCount += sd.getPeaksCount();
        }
        Peak[] peaks = new Peak[mergedPeaksCount];
        int peakIdx = 0;
        for (SpectrumSlice spectrumSlice : spectrumSlices) {
            Peak[] peakArray = spectrumSlice.toPeaks();
            int n = peakArray.length;
            for (int i = 0; i < n; ++i) {
                Peak peak;
                peaks[peakIdx] = peak = peakArray[i];
                ++peakIdx;
            }
        }
        return peaks;
    }
}

