/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.cli;

import com.almworks.sqlite4java.SQLiteException;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.db.model.params.param.UserParam;
import fr.profi.mzdb.io.writer.mgf.MgfWriter;
import fr.profi.mzdb.io.writer.mgf.PrecursorMzComputationEnum;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.util.patch.DIAIsolationWindowsPatch;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzDbAccess {
    static final Logger logger = LoggerFactory.getLogger(MzDbAccess.class);

    protected static void println(String string) {
        System.out.println(string);
    }

    protected static void print(String string) {
        System.out.print(string);
    }

    public static void main(String[] args) {
        Locale englishLocale = Locale.ENGLISH;
        Locale.setDefault(englishLocale);
        JCommander jc = new JCommander();
        ExtractPeaksCommand xicCmd = new ExtractPeaksCommand();
        CreateMgfCommand mgfCmd = new CreateMgfCommand();
        PatchDIAWindowsCommand patchDIACmd = new PatchDIAWindowsCommand();
        DebugCommand dbgCmd = new DebugCommand();
        jc.addCommand("extract_peaks", (Object)xicCmd);
        jc.addCommand("create_mgf", (Object)mgfCmd);
        jc.addCommand("patch_dia_windows", (Object)patchDIACmd);
        jc.addCommand("debug", (Object)dbgCmd);
        try {
            jc.parse(args);
            String parsedCommand = jc.getParsedCommand();
            if (parsedCommand == null || parsedCommand == "") {
                MzDbAccess.println("No command provided. Exiting");
                MzDbAccess.printAvailableCommands(jc);
                System.exit(1);
            }
            if (parsedCommand.equals("extract_peaks")) {
                MzDbAccess.extractPeaks(xicCmd);
            } else if (parsedCommand.equals("create_mgf")) {
                MzDbAccess.createMgf(mgfCmd);
            } else if (parsedCommand.equals("debug")) {
                MzDbAccess.debug(dbgCmd);
            } else if (parsedCommand.equals("patch_dia_windows")) {
                MzDbAccess.patchDIA(patchDIACmd);
            } else {
                MzDbAccess.println("Unknown command: " + parsedCommand);
                MzDbAccess.printAvailableCommands(jc);
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void patchDIA(PatchDIAWindowsCommand pc) {
        String dbPath = pc.mzdbFile;
        DIAIsolationWindowsPatch.run(dbPath);
    }

    public static void printAvailableCommands(JCommander jc) {
        MzDbAccess.println("Available commands:");
        for (JCommander e : jc.getCommands().values()) {
            e.usage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractPeaks(ExtractPeaksCommand epc) throws FileNotFoundException, SQLiteException, StreamCorruptedException {
        String dbPath = epc.mzdbFile;
        double minMz = epc.minMz;
        double maxMz = epc.maxMz;
        float minTime = epc.minTime.floatValue();
        float maxTime = epc.maxTime.floatValue();
        System.out.println("Running mzDBaccess with following parameters :");
        System.out.println("- min_mz=" + minMz);
        System.out.println("- max_mz=" + maxMz);
        System.out.println("- min_time=" + minTime);
        System.out.println("- max_time=" + maxTime);
        MzDbAccess.println("accessing to mzDB located at " + dbPath);
        try (MzDbReader mzDbInstance = new MzDbReader(new File(dbPath), true);){
            Peak[] peaks = mzDbInstance.getMsPeaksInMzRtRanges(minMz, maxMz, minTime, maxTime);
            if (peaks != null) {
                for (Peak peak : peaks) {
                    MzDbAccess.println(peak.getMz() + "\t" + peak.getIntensity() + "\t" + peak.getLeftHwhm() + "\t" + peak.getRightHwhm());
                }
            }
        }
    }

    private static void createMgf(CreateMgfCommand cmd) throws SQLiteException, IOException {
        logger.info("Creating MGF File for mzDB at: " + cmd.mzdbFile);
        logger.info("Precursor m/z values will be defined using the method: " + cmd.precMzComputation);
        MgfWriter writer = new MgfWriter(cmd.mzdbFile, cmd.msLevel);
        writer.write(cmd.outputFile, cmd.precMzComputation, cmd.mzTolPPM, cmd.intensityCutoff, cmd.exportProlineTitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debug(DebugCommand cmd) throws SQLiteException, FileNotFoundException {
        try (MzDbReader mzDbReader = new MzDbReader(cmd.mzdbFile, true);){
            SpectrumHeader[] ms2SpectrumHeaders;
            SpectrumHeader[] spectrumHeaderArray = ms2SpectrumHeaders = mzDbReader.getMs2SpectrumHeaders();
            int n = spectrumHeaderArray.length;
            int n2 = 0;
            if (n2 < n) {
                SpectrumHeader ms2SpectrumHeader = spectrumHeaderArray[n2];
                ms2SpectrumHeader.loadScanList(mzDbReader.getConnection());
                ms2SpectrumHeader.getParamTree(mzDbReader.getConnection());
                UserParam precMzParam = ms2SpectrumHeader.getScanList().getScans().get(0).getUserParam("[Thermo Trailer Extra]Monoisotopic M/Z:");
                System.out.println(precMzParam.getValue());
            }
        }
    }

    public static class ExtractPeaksCommand {
        @Parameter
        private List<String> parameters = new ArrayList<String>();
        @Parameter(names={"-mzdb", "--mzdb_file_path"}, description="mzDB file to perform extraction", required=true)
        private String mzdbFile = "";
        @Parameter(names={"-mz1", "--minmz"}, description="minimum m/z value", required=true)
        private Double minMz = 0.0;
        @Parameter(names={"-mz2", "--maxmz"}, description="maximum m/z value", required=true)
        private Double maxMz = 0.0;
        @Parameter(names={"-t1", "--mintime"}, description="minimum elution time")
        private Float minTime = Float.valueOf(0.0f);
        @Parameter(names={"-t2", "--maxtime"}, description="maximum elution time")
        private Float maxTime = Float.valueOf(0.0f);
    }

    public static class CreateMgfCommand {
        @Parameter
        private List<String> parameters = new ArrayList<String>();
        @Parameter(names={"-mzdb", "--mzdb_file_path"}, description="mzDB file to perform extraction", required=true)
        private String mzdbFile = "";
        @Parameter(names={"-o", "--output_file_path"}, description="mgf output file path", required=true)
        private String outputFile = "";
        @Parameter(names={"-ms", "--ms_level"}, description="the MS level to export", required=false)
        private int msLevel = 2;
        @Parameter(names={"-precmz", "--precursor_mz"}, description="must be one of 'main_precursor_mz, selected_ion_mz, refined, refined_thermo'", required=false)
        private PrecursorMzComputationEnum precMzComputation = PrecursorMzComputationEnum.MAIN_PRECURSOR_MZ;
        @Parameter(names={"-mztol", "--mz_tol_ppm"}, description="m/z tolerance used for precursor m/z value definition", required=false)
        private float mzTolPPM = 20.0f;
        @Parameter(names={"-cutoff", "--intensity_cutoff"}, description="optional intensity cutoff to use", required=false)
        private float intensityCutoff = 0.0f;
        @Parameter(names={"-ptitle", "--proline_title"}, description="export TITLE using the Proline convention", required=false)
        private boolean exportProlineTitle = false;
    }

    public static class PatchDIAWindowsCommand {
        @Parameter
        private List<String> parameters = new ArrayList<String>();
        @Parameter(names={"-mzdb", "--mzdb_file_path"}, description="mzDB file to patch", required=true)
        private String mzdbFile = "";
    }

    public static class DebugCommand {
        @Parameter
        private List<String> parameters = new ArrayList<String>();
        @Parameter(names={"-mzdb", "--mzdb_file_path"}, description="mzDB file to perform extraction", required=true)
        private String mzdbFile = "";
    }
}

