/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.iterator;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.io.reader.cache.AbstractDataEncodingReader;
import fr.profi.mzdb.io.reader.cache.AbstractSpectrumHeaderReader;
import fr.profi.mzdb.io.reader.iterator.BoundingBoxIterator;
import fr.profi.mzdb.model.BoundingBox;
import fr.profi.mzdb.util.sqlite.ISQLiteStatementConsumer;
import java.io.StreamCorruptedException;

public abstract class AbstractSpectrumSliceIterator {
    protected final SQLiteStatement statement;
    protected final BoundingBoxIterator boundingBoxIterator;
    protected BoundingBox firstBB;

    public AbstractSpectrumSliceIterator(AbstractSpectrumHeaderReader spectrumHeaderReader, AbstractDataEncodingReader dataEncodingReader, SQLiteConnection connection, String sqlQuery) throws SQLiteException, StreamCorruptedException {
        SQLiteStatement stmt = connection.prepare(sqlQuery, true);
        this.boundingBoxIterator = new BoundingBoxIterator(spectrumHeaderReader, dataEncodingReader, connection, stmt);
        this.statement = stmt;
        this.initBB();
    }

    public AbstractSpectrumSliceIterator(AbstractSpectrumHeaderReader spectrumHeaderReader, AbstractDataEncodingReader dataEncodingReader, SQLiteConnection connection, String sqlQuery, int msLevel, ISQLiteStatementConsumer stmtBinder) throws SQLiteException, StreamCorruptedException {
        SQLiteStatement stmt = connection.prepare(sqlQuery, true);
        stmtBinder.accept(stmt);
        this.boundingBoxIterator = new BoundingBoxIterator(spectrumHeaderReader, dataEncodingReader, connection, stmt, msLevel);
        this.statement = stmt;
        this.initBB();
    }

    public SQLiteStatement getStatement() {
        return this.statement;
    }

    protected void initBB() {
        this.firstBB = this.boundingBoxIterator.hasNext() ? (BoundingBox)this.boundingBoxIterator.next() : null;
    }

    public void closeStatement() {
        this.statement.dispose();
    }

    public boolean hasNext() {
        if (this.firstBB != null) {
            return true;
        }
        this.closeStatement();
        return false;
    }

    public void remove() {
        throw new UnsupportedOperationException("Unsuported Operation");
    }
}

