/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.ms.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.util.ms.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class IsotopePatternEstimator$
implements LazyLogging {
    public static IsotopePatternEstimator$ MODULE$;
    private final double[][] coeffs;
    private final int coeffsMatrixLen;
    private final int coeffsRowLen;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new IsotopePatternEstimator$();
    }

    private Logger logger$lzycompute() {
        IsotopePatternEstimator$ isotopePatternEstimator$ = this;
        synchronized (isotopePatternEstimator$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public final double avgIsoMassDiff() {
        return 1.0027;
    }

    public final double[][] coeffs() {
        return this.coeffs;
    }

    private final int coeffsMatrixLen() {
        return this.coeffsMatrixLen;
    }

    private final int coeffsRowLen() {
        return this.coeffsRowLen;
    }

    public TheoreticalIsotopePattern getTheoreticalPattern(double mz, int charge) {
        Predef$.MODULE$.require(charge > 0, (Function0 & java.io.Serializable & Serializable)() -> "charge must be greater than zero");
        double mass = package$.MODULE$.mozToMass(mz, charge);
        double[] m = new double[this.coeffsRowLen()];
        m[0] = 1.0;
        m[1] = mass;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), this.coeffsRowLen()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            m$1[i] = m[i - 1] * mass;
        });
        Tuple2<double[], Object> tuple2 = this.mult(this.coeffs(), m);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double[] r = (double[])tuple2._1();
        double max = tuple2._2$mcD$sp();
        Tuple2 tuple22 = new Tuple2((Object)r, (Object)BoxesRunTime.boxToDouble((double)max));
        Tuple2 tuple23 = tuple22;
        double[] r2 = (double[])tuple23._1();
        double max2 = tuple23._2$mcD$sp();
        double relativeFactor = (double)100 / max2;
        Tuple2[] mzIntPairs = new Tuple2[this.coeffsMatrixLen()];
        for (int i2 = 0; i2 < this.coeffsMatrixLen(); ++i2) {
            double isoMz = mz + (double)i2 * 1.0027 / (double)charge;
            double isoRelInt = r2[i2] * relativeFactor;
            mzIntPairs[i2] = new Tuple2((Object)BoxesRunTime.boxToDouble((double)isoMz), (Object)BoxesRunTime.boxToFloat((float)((float)isoRelInt)));
        }
        return new TheoreticalIsotopePattern(mzIntPairs, charge);
    }

    private Tuple2<double[], Object> mult(double[][] aMatrix, double[] b) {
        int len = aMatrix.length;
        double[] result = new double[len];
        double max = 0.0;
        for (int i = 0; i < len; ++i) {
            double value;
            result[i] = value = this.dotProduct(aMatrix[i], b);
            if (!(value > max)) continue;
            max = value;
        }
        return new Tuple2((Object)result, (Object)BoxesRunTime.boxToDouble((double)max));
    }

    private double dotProduct(double[] a, double[] b) {
        double value = 0.0;
        double sum = 0.0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            value = a[i] * b[i];
            sum += value;
        }
        return sum;
    }

    private IsotopePatternEstimator$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.coeffs = (double[][])((Object[])new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 5.55674E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 4.94405E-5, 1.54387E-7, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 2.74728E-8, 2.85962E-11, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.22218E-9, 7.63295E-12, 3.97254E-15, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 6.79135E-13, 1.41381E-15, 4.41487E-19, 0.0, 0.0}, {0.0, 0.0, 0.0, 2.01418E-14, 1.88689E-16, 1.96404E-19, 4.08871E-23, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.11923E-17, 3.49498E-20, 2.18273E-23, 3.2457E-27}});
        this.coeffsMatrixLen = this.coeffs().length;
        this.coeffsRowLen = this.coeffs()[0].length;
    }
}

