/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife.mgf;

import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzknife.mgf.MGFECleaner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import scala.Tuple2;

class IsotopicPatternMatch {
    final double score;
    final TheoreticalIsotopePattern theoreticalPattern;
    int matchingCount;
    List<Optional<Integer>> matchingPeaks;

    public IsotopicPatternMatch(double score, TheoreticalIsotopePattern theoreticalPattern) {
        this.score = score;
        this.theoreticalPattern = theoreticalPattern;
    }

    public IsotopicPatternMatch(double score, TheoreticalIsotopePattern theoreticalPattern, List<Optional<Integer>> peaks) {
        this(score, theoreticalPattern);
        this.matchingPeaks = peaks;
        this.matchingCount = (int)peaks.stream().filter(p -> p.isPresent()).count();
    }

    public IsotopicPatternMatch(double score, TheoreticalIsotopePattern theoreticalPattern, double[] masses, double tolPPM) {
        this(score, theoreticalPattern);
        ArrayList<Optional<Integer>> peaks = new ArrayList<Optional<Integer>>(3);
        int count = 0;
        for (int k = 0; k < 3; ++k) {
            Tuple2 p = theoreticalPattern.mzAbundancePairs()[k];
            int index = MGFECleaner.getPeakIndex(masses, (Double)p._1, tolPPM);
            if (index >= 0 && index < masses.length) {
                peaks.add(Optional.of(index));
                ++count;
                continue;
            }
            peaks.add(Optional.empty());
        }
        this.matchingPeaks = peaks;
        this.matchingCount = count;
    }
}

