/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife.mgf;

import fr.profi.mzknife.mgf.MGFWriter;
import fr.profi.mzscope.InvalidMGFFormatException;
import fr.profi.mzscope.MGFReader;
import fr.profi.mzscope.MSMSSpectrum;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGFRewriter {
    protected final List<MSMSSpectrum> m_msmsSpectra;
    protected final File m_dstFile;
    private static final Logger LOG = LoggerFactory.getLogger(MGFRewriter.class);

    protected MGFRewriter() {
        this.m_msmsSpectra = Collections.emptyList();
        this.m_dstFile = null;
    }

    public MGFRewriter(File srcFile, File m_dstFile) throws InvalidMGFFormatException {
        MGFReader reader = new MGFReader();
        this.m_msmsSpectra = reader.read(srcFile);
        this.m_dstFile = m_dstFile;
    }

    public void rewriteMGF() throws IOException {
        PrintWriter mgfWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.m_dstFile)));
        for (MSMSSpectrum spectrum : this.m_msmsSpectra) {
            MSMSSpectrum outSpectrum = this.getSpectrum2Export(spectrum);
            if (outSpectrum == null) continue;
            String spectrumAsStr = MGFWriter.stringifySpectrum(outSpectrum);
            mgfWriter.print(spectrumAsStr);
            mgfWriter.println();
        }
        mgfWriter.flush();
        mgfWriter.close();
    }

    protected MSMSSpectrum getSpectrum2Export(MSMSSpectrum inSpectrum) {
        return inSpectrum;
    }
}

