/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.table;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.db.model.InstrumentConfiguration;
import fr.profi.mzdb.db.table.InstrumentConfigurationTable;
import fr.profi.mzdb.io.reader.table.AbstractTableModelReader;
import fr.profi.mzdb.io.reader.table.ParamTreeParser;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.util.List;

public class InstrumentConfigReader
extends AbstractTableModelReader<InstrumentConfiguration> {
    public InstrumentConfigReader(SQLiteConnection connection) {
        super(connection);
    }

    @Override
    protected ISQLiteRecordExtraction<InstrumentConfiguration> buildRecordExtractor() {
        return new ISQLiteRecordExtraction<InstrumentConfiguration>(){

            @Override
            public InstrumentConfiguration extract(SQLiteRecord r) throws SQLiteException {
                int id = r.columnInt(InstrumentConfigurationTable.ID);
                String name = r.columnString(InstrumentConfigurationTable.NAME);
                int softwareId = r.columnInt(InstrumentConfigurationTable.SOFTWARE_ID);
                String paramTreeAsStr = r.columnString(InstrumentConfigurationTable.PARAM_TREE);
                String insConfAsStr = r.columnString(InstrumentConfigurationTable.COMPONENT_LIST);
                return new InstrumentConfiguration(id, name, softwareId, ParamTreeParser.parseParamTree(paramTreeAsStr), ParamTreeParser.parseComponentList(insConfAsStr));
            }
        };
    }

    public InstrumentConfiguration getInstrumentConfig(int id) throws SQLiteException {
        return (InstrumentConfiguration)this.getRecord("instrument_configuration", id);
    }

    public List<InstrumentConfiguration> getInstrumentConfigList() throws SQLiteException {
        return this.getRecordList("instrument_configuration");
    }
}

