/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard;

import fr.profi.mzDBWizard.configuration.ConfigurationManager;
import fr.profi.mzDBWizard.filelookup.WatcherExecution;
import fr.profi.mzDBWizard.gui.MainFrame;
import fr.profi.mzDBWizard.gui.SettingsAndReviewDialog;
import fr.profi.mzDBWizard.gui.util.DefaultIcons;
import fr.profi.mzDBWizard.processing.info.TaskError;
import fr.profi.mzDBWizard.processing.threading.AbstractCallback;
import fr.profi.mzDBWizard.processing.threading.queue.TaskManagerThread;
import fr.profi.mzDBWizard.processing.threading.task.ConvertRawFile2MzdbTask;
import fr.profi.mzDBWizard.util.FileUtility;
import fr.profi.util.StringUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MZDBWizard {
    static Logger logger = LoggerFactory.getLogger((String)"mzDBWizard");

    public static void main(String[] args) throws InvocationTargetException, InterruptedException {
        logger.info("Start mzDBWWizard. Read configuration");
        ConfigurationManager.loadProperties();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    logger.warn("Error setting L&FG :" + e.getMessage());
                }
                SettingsAndReviewDialog settingsAndReviewDialog = new SettingsAndReviewDialog();
                settingsAndReviewDialog.setVisible(true);
                settingsAndReviewDialog.setLocationRelativeTo(null);
                if (settingsAndReviewDialog.getAnswer() == SettingsAndReviewDialog.Answer.OK) {
                    File tempFile;
                    final JDialog waitDialog = new JDialog();
                    waitDialog.setUndecorated(true);
                    JLabel waitLabel = new JLabel("Please wait..", DefaultIcons.getSingleton().getIcon("hourglass.png"), 2);
                    waitLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    waitDialog.add(waitLabel);
                    waitDialog.setSize(160, 60);
                    waitDialog.setResizable(false);
                    waitDialog.setLocationRelativeTo(null);
                    waitDialog.setVisible(true);
                    WatcherExecution.initInstance(new File(ConfigurationManager.getMonitorPath()));
                    File mzdbFile = new File("test.mzdb");
                    if (mzdbFile.exists()) {
                        FileUtility.forceDeleteFile(mzdbFile);
                    }
                    if ((tempFile = new File("test.mzdb.tmp")).exists()) {
                        FileUtility.forceDeleteFile(tempFile);
                    }
                    if (ConfigurationManager.getConvertMzdbOperation()) {
                        File rawFile = new File("./samples/test.raw");
                        if (rawFile.exists()) {
                            AbstractCallback callback = new AbstractCallback(){

                                @Override
                                public boolean mustBeCalledInAWT() {
                                    return true;
                                }

                                @Override
                                public void run(boolean success, long taskId) {
                                    if (success) {
                                        waitDialog.setVisible(false);
                                        MainFrame frame = new MainFrame();
                                        frame.setVisible(true);
                                        if (!ConfigurationManager.getFullscreen()) {
                                            frame.setLocationRelativeTo(null);
                                        }
                                    } else {
                                        waitDialog.setVisible(false);
                                        MZDBWizard.showErrorMsgAndExit(this.getTaskError());
                                    }
                                }
                            };
                            ConvertRawFile2MzdbTask task = new ConvertRawFile2MzdbTask(callback, rawFile, true);
                            TaskManagerThread.getTaskManagerThread().addTask(task);
                        } else {
                            TaskError err = new TaskError("No test.raw file to validate converter.");
                            MZDBWizard.showErrorMsgAndExit(err);
                        }
                    } else {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                waitDialog.setVisible(false);
                                MainFrame frame = new MainFrame();
                                frame.setVisible(true);
                                if (!ConfigurationManager.getFullscreen()) {
                                    frame.setLocationRelativeTo(null);
                                }
                            }
                        });
                    }
                } else {
                    System.exit(0);
                }
            }
        });
    }

    private static void showErrorMsgAndExit(TaskError err) {
        Object msg = "Something is wrong initializing mzDbWizard. See your system administrator...";
        if (err != null) {
            msg = (String)msg + "\nError: ";
            msg = StringUtils.isNotEmpty((String)err.getErrorText()) ? (String)msg + err.getErrorText() : (String)msg + err.getErrorTitle();
        }
        JOptionPane.showMessageDialog(null, msg, "mzDbWizard initialization error", 0);
        logger.error((String)msg);
        System.exit(1);
    }
}

