/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.configuration;

import fr.profi.mzDBWizard.gui.overview.AttributeEntry;
import fr.profi.mzDBWizard.processing.CreateMgfCommand;
import fr.profi.mzDBWizard.processing.jms.queue.JMSConnectionManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    public static final String PROCESS_GENERATE_MGF_KEY = "PROCESS_GENERATE_MGF";
    public static final String FULLSCREEN_KEY = "FULLSCREEN";
    public static final String READ_ONLY_KEY = "READ_ONLY";
    public static final String DEBUG_MODE_KEY = "DEBUG_MODE";
    public static final String DELETE_RAW_KEY = "DELETE_RAW";
    public static final String DELETE_MZDB_KEY = "DELETE_MZDB";
    public static final String MONITOR_PATH_KEY = "MONITOR_PATH";
    public static final String RECURSIVE_WATCHING_KEY = "RECURSIVE_WATCHING";
    public static final String PROCESS_CONVERT_KEY = "PROCESS_CONVERT";
    public static final String CONVERTER_PATH_KEY = "CONVERTER_PATH";
    public static final String CONVERTER_OPTIONS_KEY = "CONVERTER_OPTIONS";
    public static final String PROCESS_SPLIT_MZDB_KEY = "PROCESS_SPLIT_MZDB";
    public static final String PROCESS_UPLOAD_KEY = "PROCESS_UPLOAD";
    public static final String MOUNTING_POINT_LABEL_KEY = "MOUNTING_POINT_LABEL";
    public static final String JMS_SERVER_PORT_KEY = "JMS_SERVER_PORT";
    public static final String JMS_SERVER_HOST_KEY = "JMS_SERVER_HOST";
    public static final String SERVICE_REQUEST_QUEUE_NAME_KEY = "SERVICE_REQUEST_QUEUE_NAME";
    public static final String PROCESS_PENDING_KEY = "PROCESS_PENDING";
    private static final Logger logger = LoggerFactory.getLogger((String)"ApplicationProperties");
    private static boolean fullscreen = false;
    private static boolean read_only_cfg = false;
    public static final String HOST_TO_SELECT = "<host>";
    private static String jms_server_host = "<host>";
    private static int jms_server_port = 5445;
    private static String service_request_queue_name = "ProlineServiceRequestQueue";
    private static ArrayList<String> mounting_point_path_labels;
    private static boolean upload_operation;
    private static boolean delete_raw;
    private static boolean delete_mzdb;
    private static boolean recursive_watching;
    private static String monitor_path;
    private static String mounting_point_label;
    private static String converter_exec;
    private static String converter_path;
    private static String converter_options;
    private static boolean convert_mzdb_operation;
    private static boolean split_mzdb_operation;
    private static boolean generate_mgf_operation;
    private static boolean process_pending;
    private static boolean debug_mode;

    public static void setConvertMzdbOperation(boolean b) {
        convert_mzdb_operation = b;
    }

    public static boolean getConvertMzdbOperation() {
        return convert_mzdb_operation;
    }

    public static void setProcessGenerateMgf(boolean b) {
        generate_mgf_operation = b;
    }

    public static boolean getProcessGenerateMgf() {
        return generate_mgf_operation;
    }

    public static void setProcessSplitMzdb(boolean b) {
        split_mzdb_operation = b;
    }

    public static boolean getProcessSplitMzdb() {
        return split_mzdb_operation;
    }

    public static void setProcessUpload(boolean b) {
        upload_operation = b;
    }

    public static boolean getProcessUpload() {
        return upload_operation;
    }

    public static void setJmsServerHost(String s) {
        jms_server_host = s;
    }

    public static String getJmsServerHost() {
        return jms_server_host;
    }

    public static void setJmsServerPort(int i) {
        jms_server_port = i;
    }

    public static int getJmsServerPort() {
        return jms_server_port;
    }

    public static void setServiceRequestQueueName(String s) {
        service_request_queue_name = s;
    }

    public static String getServiceRequestQueueName() {
        return service_request_queue_name;
    }

    public static String getProlineServiceNameKey() {
        return "Proline_ServiceName";
    }

    public static void setDeleteRaw(boolean b) {
        delete_raw = b;
    }

    public static boolean getDeleteRaw() {
        return delete_raw;
    }

    public static boolean isReadOnlyCfg() {
        return read_only_cfg;
    }

    public static void setReadOnlyCfg(boolean read_only_cfg) {
        ConfigurationManager.read_only_cfg = read_only_cfg;
    }

    public static void setDeleteMzdb(boolean b) {
        delete_mzdb = b;
    }

    public static boolean getDeleteMzdb() {
        return delete_mzdb;
    }

    public static void setRecursiveWatching(boolean b) {
        recursive_watching = b;
    }

    public static boolean getRecursive() {
        return recursive_watching;
    }

    public static void setFullscreen(boolean b) {
        fullscreen = b;
    }

    public static boolean getFullscreen() {
        return fullscreen;
    }

    public static void setMoutingPointPathLabels(ArrayList<String> labels) {
        mounting_point_path_labels = labels;
    }

    public static ArrayList<String> getMountingPointPathLabels() {
        return mounting_point_path_labels;
    }

    public static void setConverterOptions(String s) {
        converter_options = s;
    }

    public static String getConverterOptions() {
        return converter_options;
    }

    public static void setConverterPath(String s) {
        converter_path = s;
    }

    public static String getConverterPath() {
        return converter_path;
    }

    public static String getEmbeddedmzDBConverterExec() {
        return converter_exec;
    }

    public static void setMonitorPath(String s) {
        monitor_path = s;
    }

    public static String getMonitorPath() {
        return monitor_path;
    }

    public static void setMountingPointLabel(String label) {
        mounting_point_label = label;
    }

    public static String getMountingPointLabel() {
        return mounting_point_label;
    }

    public static void setProcessPending(boolean b) {
        process_pending = b;
    }

    public static boolean getProcessPending() {
        return process_pending;
    }

    public static void setDebugMode(boolean b) {
        debug_mode = b;
    }

    public static boolean getDebugMode() {
        return debug_mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties() {
        Properties prop = new Properties();
        InputStream is = null;
        try {
            File cfgFile = new File("./config/config.properties");
            is = new FileInputStream(cfgFile);
            logger.debug("Loading Configuration File: " + cfgFile.getAbsolutePath() + " ..");
            prop.load(is);
            String property = prop.getOrDefault((Object)READ_ONLY_KEY, "false").toString();
            ConfigurationManager.setReadOnlyCfg(Boolean.parseBoolean(property));
            logger.debug("ReadOnly : " + ConfigurationManager.isReadOnlyCfg());
            ConfigurationManager.setJmsServerHost(prop.getOrDefault((Object)JMS_SERVER_HOST_KEY, jms_server_host).toString());
            JMSConnectionManager.getJMSConnectionManager().setJMSServerHost(ConfigurationManager.getJmsServerHost());
            logger.debug("jms_server_host: " + jms_server_host);
            ConfigurationManager.setJmsServerPort(Integer.parseInt(prop.getOrDefault((Object)JMS_SERVER_PORT_KEY, (Object)jms_server_port).toString()));
            logger.debug("jms_server_port: " + jms_server_port);
            ConfigurationManager.setServiceRequestQueueName(prop.getOrDefault((Object)SERVICE_REQUEST_QUEUE_NAME_KEY, service_request_queue_name).toString());
            logger.debug("service_request_queue_name: " + service_request_queue_name);
            ConfigurationManager.setDeleteRaw(Boolean.parseBoolean(prop.getOrDefault((Object)DELETE_RAW_KEY, (Object)delete_raw).toString()));
            logger.debug("delete_raw: " + delete_raw);
            ConfigurationManager.setDeleteMzdb(Boolean.parseBoolean(prop.getOrDefault((Object)DELETE_MZDB_KEY, (Object)delete_mzdb).toString()));
            logger.debug("delete_mzdb: " + delete_mzdb);
            ConfigurationManager.setRecursiveWatching(Boolean.parseBoolean(prop.getOrDefault((Object)RECURSIVE_WATCHING_KEY, (Object)recursive_watching).toString()));
            logger.debug("recursive_watching: " + recursive_watching);
            ConfigurationManager.setFullscreen(Boolean.parseBoolean(prop.getOrDefault((Object)FULLSCREEN_KEY, (Object)fullscreen).toString()));
            logger.debug("fullscreen: " + fullscreen);
            ConfigurationManager.setConverterPath(prop.getOrDefault((Object)CONVERTER_PATH_KEY, converter_path).toString());
            logger.debug("converter_path: " + converter_path);
            ConfigurationManager.setConverterOptions(prop.getOrDefault((Object)CONVERTER_OPTIONS_KEY, "").toString());
            logger.debug("converter_options: " + converter_options);
            ConfigurationManager.setProcessSplitMzdb(Boolean.parseBoolean(prop.getOrDefault((Object)PROCESS_SPLIT_MZDB_KEY, (Object)split_mzdb_operation).toString()));
            logger.debug("split_mzdb_operation: " + split_mzdb_operation);
            ConfigurationManager.setMonitorPath(prop.getOrDefault((Object)MONITOR_PATH_KEY, monitor_path).toString());
            logger.debug("monitor_path: " + monitor_path);
            ConfigurationManager.setProcessGenerateMgf(Boolean.parseBoolean(prop.getOrDefault((Object)PROCESS_GENERATE_MGF_KEY, (Object)generate_mgf_operation).toString()));
            logger.debug("generate_mgf_operation: " + generate_mgf_operation);
            ConfigurationManager.setConvertMzdbOperation(Boolean.parseBoolean(prop.getOrDefault((Object)PROCESS_CONVERT_KEY, (Object)convert_mzdb_operation).toString()));
            logger.debug("convert_mzdb_operation: " + convert_mzdb_operation);
            ConfigurationManager.setProcessUpload(Boolean.parseBoolean(prop.getOrDefault((Object)PROCESS_UPLOAD_KEY, (Object)upload_operation).toString()));
            logger.debug("upload_operation: " + upload_operation);
            if (prop.getProperty(MOUNTING_POINT_LABEL_KEY) != null) {
                ConfigurationManager.setMountingPointLabel(prop.getProperty(MOUNTING_POINT_LABEL_KEY));
            }
            logger.debug("mounting_point_label: " + mounting_point_label);
            ConfigurationManager.setProcessPending(Boolean.parseBoolean(prop.getOrDefault((Object)PROCESS_PENDING_KEY, (Object)process_pending).toString()));
            logger.debug("process_pending: " + process_pending);
            ConfigurationManager.setDebugMode(Boolean.parseBoolean(prop.getOrDefault((Object)DEBUG_MODE_KEY, (Object)debug_mode).toString()));
            logger.debug("debug_mode: " + debug_mode);
            CreateMgfCommand.getInstance().loadProperties(prop);
        }
        catch (FileNotFoundException ex) {
            logger.error("FileNotFoundException while loading properties!", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error("IOException while loading properties!", (Throwable)ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                logger.error("Finally IOException while loading properties!", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(CreateMgfCommand command) {
        Properties prop = new Properties();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream("./config/config.properties");
            prop.setProperty(READ_ONLY_KEY, String.valueOf(ConfigurationManager.isReadOnlyCfg()));
            prop.setProperty(JMS_SERVER_HOST_KEY, ConfigurationManager.getJmsServerHost());
            prop.setProperty(JMS_SERVER_PORT_KEY, String.valueOf(ConfigurationManager.getJmsServerPort()));
            prop.setProperty(SERVICE_REQUEST_QUEUE_NAME_KEY, ConfigurationManager.getServiceRequestQueueName());
            prop.setProperty(DELETE_RAW_KEY, String.valueOf(ConfigurationManager.getDeleteRaw()));
            prop.setProperty(DELETE_MZDB_KEY, String.valueOf(ConfigurationManager.getDeleteMzdb()));
            prop.setProperty(RECURSIVE_WATCHING_KEY, String.valueOf(ConfigurationManager.getRecursive()));
            prop.setProperty(PROCESS_PENDING_KEY, String.valueOf(ConfigurationManager.getProcessPending()));
            prop.setProperty(FULLSCREEN_KEY, String.valueOf(ConfigurationManager.getFullscreen()));
            prop.setProperty(CONVERTER_PATH_KEY, ConfigurationManager.getConverterPath());
            prop.setProperty(CONVERTER_OPTIONS_KEY, ConfigurationManager.getConverterOptions());
            prop.setProperty(MONITOR_PATH_KEY, ConfigurationManager.getMonitorPath());
            prop.setProperty(PROCESS_GENERATE_MGF_KEY, String.valueOf(ConfigurationManager.getProcessGenerateMgf()));
            prop.setProperty(PROCESS_CONVERT_KEY, String.valueOf(ConfigurationManager.getConvertMzdbOperation()));
            prop.setProperty(PROCESS_UPLOAD_KEY, String.valueOf(ConfigurationManager.getProcessUpload()));
            prop.setProperty(PROCESS_SPLIT_MZDB_KEY, String.valueOf(ConfigurationManager.getProcessSplitMzdb()));
            prop.setProperty(MOUNTING_POINT_LABEL_KEY, ConfigurationManager.getMountingPointLabel());
            prop.setProperty(DEBUG_MODE_KEY, String.valueOf(ConfigurationManager.getDebugMode()));
            prop.putAll((Map<?, ?>)command.getCommandProperties());
            prop.store(output, null);
        }
        catch (IOException io) {
            logger.error("IOException while saving all properties!", (Throwable)io);
        }
        finally {
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    logger.error("IOException while saving all properties! (Finally)", (Throwable)e);
                }
            }
        }
    }

    public static ArrayList<AttributeEntry> getConfigurationModelData() {
        ArrayList<AttributeEntry> modelData = new ArrayList<AttributeEntry>();
        modelData.add(new AttributeEntry("Monitored URL", ConfigurationManager.getMonitorPath()));
        modelData.add(new AttributeEntry("Recursive Monitoring", String.valueOf(ConfigurationManager.getRecursive())));
        modelData.add(new AttributeEntry("Process Pending", String.valueOf(ConfigurationManager.getProcessPending())));
        modelData.add(new AttributeEntry("Convert mzDb", String.valueOf(ConfigurationManager.getConvertMzdbOperation())));
        if (ConfigurationManager.getConvertMzdbOperation()) {
            modelData.add(new AttributeEntry("Converter", ConfigurationManager.getConverterPath()));
            modelData.add(new AttributeEntry("Converter Options", ConfigurationManager.getConverterOptions()));
        }
        modelData.add(new AttributeEntry("Split Exploris mzDb", String.valueOf(ConfigurationManager.getProcessSplitMzdb())));
        if (ConfigurationManager.getProcessSplitMzdb()) {
            modelData.add(new AttributeEntry("Split mzDb extension", ".split.mzdb"));
        }
        modelData.add(new AttributeEntry("Export mgf", String.valueOf(ConfigurationManager.getProcessGenerateMgf())));
        if (ConfigurationManager.getProcessGenerateMgf()) {
            Properties p = CreateMgfCommand.getInstance().getCommandProperties();
            for (Map.Entry<Object, Object> nextP : p.entrySet()) {
                modelData.add(new AttributeEntry(nextP.getKey().toString(), nextP.getValue().toString()));
            }
        }
        modelData.add(new AttributeEntry("Upload", String.valueOf(ConfigurationManager.getProcessUpload())));
        if (ConfigurationManager.getProcessUpload()) {
            modelData.add(new AttributeEntry("Host", ConfigurationManager.getJmsServerHost()));
            modelData.add(new AttributeEntry("Mounting Point", ConfigurationManager.getMountingPointLabel()));
        }
        modelData.add(new AttributeEntry("Delete raw", String.valueOf(ConfigurationManager.getDeleteRaw())));
        modelData.add(new AttributeEntry("Delete mzdb", String.valueOf(ConfigurationManager.getDeleteMzdb())));
        return modelData;
    }

    static {
        upload_operation = true;
        delete_raw = false;
        delete_mzdb = true;
        recursive_watching = true;
        monitor_path = "." + File.separator;
        mounting_point_label = "";
        converter_exec = "mzdbConverter.bat";
        converter_path = "." + File.separator + "converter" + File.separator + "mzdb-converter" + File.separator + converter_exec;
        convert_mzdb_operation = true;
        split_mzdb_operation = true;
        generate_mgf_operation = false;
        process_pending = false;
        debug_mode = false;
    }
}

