/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.filelookup;

import fr.profi.mzDBWizard.configuration.ConfigurationManager;
import fr.profi.mzDBWizard.filelookup.WatcherExecution;
import fr.profi.mzDBWizard.processing.threading.FileProcessingExec;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher
implements Runnable {
    private final WatchService m_watcher;
    private final Map<WatchKey, Path> m_keys;
    private boolean m_trace;
    private boolean m_run = true;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().toString());

    public DirectoryWatcher() throws IOException {
        this.m_watcher = FileSystems.getDefault().newWatchService();
        this.m_keys = new HashMap<WatchKey, Path>();
        this.m_trace = ConfigurationManager.getProcessPending();
        if (ConfigurationManager.getRecursive()) {
            this.registerDirectoriesRecursively(WatcherExecution.getInstance().getMonitoringDirectory().toPath());
        } else {
            this.registerSingleDirectory(WatcherExecution.getInstance().getMonitoringDirectory().toPath());
        }
        this.m_trace = true;
    }

    private void registerSingleDirectory(Path dir) throws IOException {
        File[] listOfFiles;
        Path prev;
        WatchKey key = dir.register(this.m_watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        if (this.m_trace && (prev = this.m_keys.get(key)) == null && (listOfFiles = dir.toFile().listFiles()) != null) {
            this.logger.debug("Directory " + dir.toString() + " was registered. The folder contains " + listOfFiles.length + " files.");
            for (int i = 0; i < listOfFiles.length; ++i) {
                File f = listOfFiles[i];
                if (!f.isFile()) continue;
                String lowerPath = f.getAbsolutePath().toLowerCase();
                if (lowerPath.endsWith(".raw") || lowerPath.endsWith(".wiff")) {
                    FileProcessingExec.launchRawFileTasks(f);
                    continue;
                }
                if (!lowerPath.endsWith(".mzdb")) continue;
                FileProcessingExec.launchMzdbFileTasks(f);
            }
        }
        this.m_keys.put(key, dir);
    }

    private void registerDirectoriesRecursively(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                DirectoryWatcher.this.registerSingleDirectory(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    void watch() {
        while (this.m_run) {
            WatchKey key;
            try {
                key = this.m_watcher.take();
            }
            catch (InterruptedException x) {
                this.m_run = false;
                return;
            }
            Path dir = this.m_keys.get(key);
            if (dir == null) {
                this.logger.error("WatchKey: " + key.toString() + " was not recognized!");
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = event;
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    this.logger.info(event.kind().name() + " : " + child.toString());
                }
                if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                    if (ConfigurationManager.getRecursive()) {
                        if (kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                        try {
                            this.registerDirectoriesRecursively(child);
                        }
                        catch (IOException ex) {
                            this.logger.error("IOException on recursive directory registering!", (Throwable)ex);
                        }
                        continue;
                    }
                    this.logger.debug("... Do not consider sub folder ... ");
                    continue;
                }
                String fileName = child.toString();
                String fileNameLowerCase = fileName.toLowerCase();
                if (!fileNameLowerCase.endsWith(".raw") && !fileNameLowerCase.endsWith(".wiff") && !fileNameLowerCase.endsWith(".mzdb")) continue;
                File f = new File(fileName);
                if (kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                if (fileNameLowerCase.endsWith(".raw") || fileNameLowerCase.endsWith(".wiff")) {
                    FileProcessingExec.launchRawFileTasks(f);
                    continue;
                }
                if (!fileNameLowerCase.endsWith(".mzdb")) continue;
                FileProcessingExec.launchMzdbFileTasks(f);
            }
            boolean valid = key.reset();
            if (!valid) {
                this.m_keys.remove(key);
                if (this.m_keys.isEmpty()) {
                    this.m_run = false;
                    break;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                this.logger.warn("InterruptedException during Directory watching");
            }
        }
    }

    @Override
    public void run() {
        this.watch();
    }
}

