/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.gui;

import fr.profi.mzDBWizard.configuration.ConfigurationManager;
import fr.profi.mzDBWizard.gui.about.AboutDialog;
import fr.profi.mzDBWizard.gui.log.LogPanel;
import fr.profi.mzDBWizard.gui.overview.AttributesTableModel;
import fr.profi.mzDBWizard.gui.overview.OverviewScrollPane;
import fr.profi.mzDBWizard.gui.taskmanager.TaskManagerPanel;
import fr.profi.mzDBWizard.gui.util.DefaultIcons;
import fr.profi.mzDBWizard.gui.util.GenericTableRenderer;
import fr.profi.mzDBWizard.processing.info.TaskInfoManager;
import fr.profi.mzDBWizard.util.JavaVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.slf4j.LoggerFactory;

public class MainFrame
extends JFrame
implements WindowListener,
ActionListener {
    public MainFrame() {
        this.setIconImage(DefaultIcons.getSingleton().getIcon("logo_30.png").getImage());
        JavaVersion buildInformation = new JavaVersion();
        this.setTitle(buildInformation.getModuleName() + " (" + buildInformation.getVersion() + ")");
        this.setDefaultCloseOperation(0);
        this.setLayout(new GridLayout(1, 1));
        this.addWindowListener(this);
        if (ConfigurationManager.getFullscreen()) {
            this.setExtendedState(6);
        }
        JTabbedPane m_tabbedPane = new JTabbedPane();
        m_tabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        TaskManagerPanel m_taskManager = new TaskManagerPanel();
        m_tabbedPane.addTab("Tasks", m_taskManager);
        if (ConfigurationManager.getDebugMode()) {
            m_tabbedPane.addTab("Debug", new LogPanel());
        }
        this.setJMenuBar(this.initJMenuBar());
        JSplitPane m_splitPane = new JSplitPane(1, m_tabbedPane, this.getExecutionPanel());
        m_splitPane.setOneTouchExpandable(true);
        this.add(m_splitPane);
        this.pack();
        m_splitPane.setDividerLocation(0.65);
    }

    private JPanel getExecutionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 11;
        c.fill = 1;
        c.insets = new Insets(5, 0, 5, 0);
        c.weighty = 0.0;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        OverviewScrollPane executionOverview = OverviewScrollPane.getSingleton();
        executionOverview.setBorder(BorderFactory.createTitledBorder("Current Execution"));
        panel.add((Component)executionOverview, c);
        ++c.gridy;
        c.weighty = 1.0;
        AttributesTableModel m_configurationTableModel = new AttributesTableModel(ConfigurationManager.getConfigurationModelData());
        JTable configurationTable = new JTable(m_configurationTableModel);
        configurationTable.setTableHeader(null);
        configurationTable.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        configurationTable.setRowHeight(20);
        configurationTable.setRowSelectionAllowed(true);
        configurationTable.setDefaultRenderer(Object.class, new GenericTableRenderer());
        JScrollPane confScrollPane = new JScrollPane(configurationTable);
        confScrollPane.setBorder(BorderFactory.createTitledBorder("Configuration"));
        panel.add((Component)confScrollPane, c);
        ++c.gridy;
        c.weighty = 0.0;
        panel.add((Component)Box.createVerticalBox(), c);
        return panel;
    }

    private JMenuBar initJMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenuItem exitItem = new JMenuItem("Exit", 69);
        exitItem.addActionListener(this);
        exitItem.setActionCommand("Exit");
        fileMenu.add(exitItem);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        menuBar.add(helpMenu);
        JMenuItem userGuideItem = new JMenuItem("User Guide", 85);
        userGuideItem.addActionListener(this);
        userGuideItem.setActionCommand("User Guide");
        helpMenu.add(userGuideItem);
        helpMenu.addSeparator();
        JMenuItem aboutItem = new JMenuItem("About", 65);
        aboutItem.addActionListener(this);
        aboutItem.setActionCommand("About");
        helpMenu.add(aboutItem);
        return menuBar;
    }

    @Override
    public void windowOpened(WindowEvent we) {
    }

    @Override
    public void windowClosing(WindowEvent we) {
        this.exitAction();
    }

    @Override
    public void windowClosed(WindowEvent we) {
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowActivated(WindowEvent we) {
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equalsIgnoreCase("Exit")) {
            this.exitAction();
        } else if (ae.getActionCommand().equalsIgnoreCase("About")) {
            AboutDialog about = AboutDialog.getInstance();
            about.setVisible(true);
        } else if (ae.getActionCommand().equalsIgnoreCase("User Guide") && Desktop.isDesktopSupported()) {
            try {
                File myFile = new File("." + File.separator + "documentation" + File.separator + "user_guide.pdf");
                Desktop.getDesktop().open(myFile);
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).warn(" Unable to read user_guide.pdf");
                JOptionPane.showMessageDialog(this, "Unable to read user guide", "Documentation access error", 0);
            }
        }
    }

    private void exitAction() {
        if (TaskInfoManager.getTaskInfoManager().askBeforeExitingApp()) {
            if (JOptionPane.showConfirmDialog(this, "There are still active tasks.", "Do you really want to exit?", 0, 3) == 0) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }
}

