/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.gui.log;

import fr.profi.mzDBWizard.processing.info.TaskError;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;

public class LogsDialog
extends JDialog
implements Runnable,
WindowListener {
    private static int m_delayInSeconds;
    private final JTextArea m_textArea;
    private static TaskInfo m_taskInfo;
    private boolean m_run = true;
    private static LogsDialog m_instance;
    private static JComponent m_parent;

    public static LogsDialog getInstance() {
        if (m_instance == null) {
            m_instance = new LogsDialog();
        }
        return m_instance;
    }

    public static void setParameters(JComponent parent, TaskInfo taskInfo, int delayInSeconds) {
        m_parent = parent;
        m_taskInfo = taskInfo;
        m_delayInSeconds = delayInSeconds;
    }

    public void updateLogsDialog() {
        this.m_run = true;
        this.setTitle("Logs - " + m_taskInfo.getTaskDescription());
        StringBuilder sb = new StringBuilder();
        TaskError taskError = m_taskInfo.getTaskError();
        if (taskError != null) {
            sb.append("------------------ ERROR : ").append(taskError.getErrorTitle()).append("\n").append(taskError.getErrorText()).append("\n\n");
        }
        for (String log : m_taskInfo.getLogs()) {
            sb.append(log).append("\n");
        }
        this.m_textArea.setText(sb.toString());
        this.repaint();
    }

    private LogsDialog() {
        this.setLocationRelativeTo(m_parent);
        this.setTitle("Logs for " + m_taskInfo.getTaskDescription());
        this.setSize(new Dimension(640, 480));
        this.setLayout(new BorderLayout());
        this.m_textArea = new JTextArea();
        this.m_textArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.m_textArea.setEditable(false);
        JScrollPane m_scrollPane = new JScrollPane(this.m_textArea);
        DefaultCaret caret = (DefaultCaret)this.m_textArea.getCaret();
        caret.setUpdatePolicy(1);
        m_scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createLineBorder(Color.DARK_GRAY)));
        this.add((Component)m_scrollPane, "Center");
    }

    @Override
    public void run() {
        while (this.m_run) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogsDialog.this.updateLogsDialog();
                }
            });
            if (m_taskInfo.isFinished() || m_taskInfo.isAborted()) {
                this.terminate();
                break;
            }
            try {
                Thread.sleep(1000 * m_delayInSeconds);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(LogsDialog.class.getName()).log(Level.SEVERE, null, ex);
                this.terminate();
            }
        }
    }

    public void terminate() {
        this.m_run = false;
    }

    @Override
    public void windowOpened(WindowEvent we) {
    }

    @Override
    public void windowClosing(WindowEvent we) {
        this.terminate();
    }

    @Override
    public void windowClosed(WindowEvent we) {
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowActivated(WindowEvent we) {
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }
}

