/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.gui.taskmanager;

import fr.profi.mzDBWizard.gui.overview.AttributeEntry;
import fr.profi.mzDBWizard.gui.overview.OverviewScrollPane;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.info.TaskInfoListener;
import fr.profi.mzDBWizard.processing.info.TaskInfoManager;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class TaskManagerTableModel
extends AbstractTableModel
implements TaskInfoListener {
    public static final int TASK_TYPE_INDEX = 0;
    public static final int FILE_INDEX = 1;
    public static final int STATE_INDEX = 2;
    public static final int DISPATCH_TIME_INDEX = 3;
    public static final int ERROR_LIST_INDEX = 4;
    private static final int COLUMN_COUNT = 5;
    private ArrayList<TaskInfo> m_infoList = new ArrayList(5000);

    public TaskManagerTableModel() {
        TaskInfoManager.getTaskInfoManager().setListener(this);
    }

    @Override
    public void update() {
        SwingUtilities.invokeLater(() -> {
            if (TaskInfoManager.getTaskInfoManager().copyData(this.m_infoList, false)) {
                ArrayList<AttributeEntry> attributes = TaskInfoManager.getTaskInfoManager().getExecutionModelData();
                OverviewScrollPane.getSingleton().update(attributes);
                this.fireTableDataChanged();
            }
        });
    }

    @Override
    public int getRowCount() {
        return this.m_infoList.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.m_infoList.get(row);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 1: {
                return "File";
            }
            case 0: {
                return "Type";
            }
            case 3: {
                return "Dispatch Time";
            }
            case 2: {
                return "State";
            }
            case 4: {
                return "Logs";
            }
        }
        return "??";
    }

    public TaskInfo getTaskInfo(int row) {
        return this.m_infoList.get(row);
    }
}

