/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.gui.taskmanager.renderer;

import fr.profi.mzDBWizard.gui.util.DefaultColors;
import fr.profi.mzDBWizard.processing.info.TaskError;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ErrorsNumberRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        TaskInfo taskInfo = (TaskInfo)value;
        TaskError taskError = taskInfo.getTaskError();
        int errors = taskError != null ? 1 : 0;
        int warnings = taskInfo.getWarningCount();
        int logSize = taskInfo.getLogs().size();
        if (errors > 0) {
            this.setBackground(DefaultColors.ALIZARIN);
            this.setForeground(Color.WHITE);
            this.setToolTipText("Critical: " + errors + " , Non-Critical: " + warnings);
            this.setText("Error");
        } else if (warnings > 0) {
            this.setBackground(DefaultColors.SUNFLOWER);
            this.setForeground(Color.WHITE);
            this.setToolTipText("Warnings: " + warnings);
        } else {
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            this.setToolTipText("No error");
            this.setText(logSize > 0 ? "Info" : "");
        }
        this.setHorizontalAlignment(0);
        if (isSelected && this.getBackground() != null) {
            this.setBackground(this.getBackground().darker());
        }
        return this;
    }
}

