/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.jms.queue;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import fr.profi.mzDBWizard.processing.info.TaskError;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.jms.queue.AbstractJMSCallback;
import fr.profi.mzDBWizard.processing.jms.queue.AccessJMSManagerThread;
import fr.profi.mzDBWizard.processing.jms.queue.JMSConnectionManager;
import fr.profi.mzDBWizard.processing.jms.queue.JMSMessageUtil;
import fr.profi.mzDBWizard.processing.threading.queue.AbstractTaskWithInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMSTask
extends AbstractTaskWithInfo
implements MessageListener {
    protected AbstractJMSCallback m_callback;
    protected MessageProducer m_producer = null;
    protected MessageConsumer m_responseConsumer = null;
    protected TemporaryQueue m_replyQueue = null;
    protected JMSState m_currentState = null;
    protected TaskError m_taskError = null;
    protected boolean m_synchronous;
    private int responseTimeout = 10000;
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"mzDB-Task");
    private boolean m_taskFinished = false;
    public final AtomicInteger MESSAGE_COUNT_SEQUENCE = new AtomicInteger(0);

    public AbstractJMSTask(AbstractJMSCallback callback, TaskInfo taskInfo) {
        super(taskInfo);
        this.m_callback = callback;
        this.m_synchronous = false;
    }

    public AbstractJMSTask(AbstractJMSCallback callback, boolean synchronous, TaskInfo taskInfo) {
        super(taskInfo);
        this.m_callback = callback;
        this.m_synchronous = synchronous;
    }

    protected void setResponseTimeout(int timeout) {
        this.responseTimeout = timeout;
    }

    public void askJMS() {
        try {
            Session m_session = AccessJMSManagerThread.getAccessJMSManagerThread().getSession();
            this.m_producer = m_session.createProducer((Destination)JMSConnectionManager.getJMSConnectionManager().getServiceQueue());
            this.m_replyQueue = m_session.createTemporaryQueue();
            this.m_responseConsumer = m_session.createConsumer((Destination)this.m_replyQueue);
            if (!this.m_synchronous) {
                this.m_responseConsumer.setMessageListener((MessageListener)this);
            }
            this.m_currentState = JMSState.STATE_WAITING;
            this.getTaskInfo().setRunning(true);
            this.taskRun();
            if (this.m_synchronous) {
                Message responseMsg = this.m_responseConsumer.receive((long)this.responseTimeout);
                this.onMessage(responseMsg);
            }
        }
        catch (Exception ex) {
            m_logger.error("Error sending JMS Message", (Throwable)ex);
            this.m_currentState = JMSState.STATE_FAILED;
            this.m_taskError = new TaskError(ex);
            this.callback(false);
        }
    }

    public abstract void taskRun() throws JMSException;

    public void setTaskInfoRequest(String content) {
        this.m_taskInfo.setRequestContent(content);
    }

    protected void addSourceToMessage(Message message) throws JMSException {
        String hostIP;
        StringBuilder userLoginSB = new StringBuilder();
        userLoginSB.append("mzDbWizard user");
        try {
            hostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            hostIP = "Unknown";
        }
        userLoginSB.append(" (host  ").append(hostIP).append(")");
        message.setStringProperty("Proline_ServiceSource", userLoginSB.toString());
    }

    protected void addDescriptionToMessage(Message message) throws JMSException {
        message.setStringProperty("Proline_ServiceDescription", this.m_taskInfo.getTaskDescription());
    }

    public abstract void taskDone(Message var1) throws Exception;

    public JMSState getJMSState() {
        return this.m_currentState;
    }

    public final void onMessage(Message jmsMessage) {
        long endRun = System.currentTimeMillis();
        this.m_taskInfo.setDuration(endRun - this.m_taskInfo.getStartTimestamp());
        if (jmsMessage != null) {
            m_logger.info("Receiving message n\u00b0 " + this.MESSAGE_COUNT_SEQUENCE.incrementAndGet() + " : " + JMSMessageUtil.formatMessage(jmsMessage));
            try {
                this.taskDone(jmsMessage);
            }
            catch (JSONRPC2Error jsonErr) {
                this.m_currentState = JMSState.STATE_FAILED;
                m_logger.error("Error handling JMS Message", (Throwable)jsonErr);
                if (jsonErr.getCode() == -32004) {
                    this.m_taskInfo.setAborted();
                }
                this.m_taskError = new TaskError((Exception)((Object)jsonErr));
            }
            catch (Exception e) {
                this.m_currentState = JMSState.STATE_FAILED;
                m_logger.error("Error handling JMS Message", (Throwable)e);
                this.m_taskError = new TaskError(e);
            }
        } else {
            String msg = "Error receiving message n\u00b0 " + this.MESSAGE_COUNT_SEQUENCE.incrementAndGet() + ": timeout should have occured ";
            m_logger.info(msg);
            this.m_currentState = JMSState.STATE_FAILED;
            this.m_taskError = new TaskError(new RuntimeException(msg));
        }
        if (this.m_currentState == JMSState.STATE_FAILED) {
            this.callback(false);
        } else if (this.m_currentState == JMSState.STATE_DONE) {
            this.callback(true);
        } else {
            this.m_taskError = new TaskError("Task with State not set");
            this.m_currentState = JMSState.STATE_FAILED;
            this.callback(false);
        }
        try {
            if (jmsMessage != null) {
                jmsMessage.acknowledge();
            }
        }
        catch (JMSException ex) {
            m_logger.error("Error running JMS Message acknowledge", (Throwable)ex);
        }
    }

    protected void callback(final boolean success) {
        if (this.m_callback == null) {
            this.getTaskInfo().setFinished(success, this.m_taskError, true);
            this.taskFinished();
            return;
        }
        this.m_callback.setTaskInfo(this.m_taskInfo);
        this.m_callback.setTaskError(this.m_taskError);
        if (this.m_callback.mustBeCalledInAWT()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractJMSTask.this.m_callback.run(success);
                        AbstractJMSTask.this.getTaskInfo().setFinished(success, AbstractJMSTask.this.m_taskError, true);
                    }
                    finally {
                        AbstractJMSTask.this.taskFinished();
                    }
                }
            });
        } else {
            try {
                this.m_callback.run(success);
                this.getTaskInfo().setFinished(success, this.m_taskError, true);
            }
            finally {
                this.taskFinished();
            }
        }
    }

    public boolean isTaskFinished() {
        return this.m_taskFinished;
    }

    public synchronized void taskFinished() {
        this.m_taskFinished = true;
        this.notifyAll();
    }

    public Object getMutex() {
        return this;
    }

    public static enum JMSState {
        STATE_FAILED,
        STATE_WAITING,
        STATE_DONE;

    }
}

