/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.jms.queue;

import fr.profi.mzDBWizard.processing.jms.queue.AbstractJMSTask;
import fr.profi.mzDBWizard.processing.jms.queue.JMSConnectionManager;
import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.Session;
import org.slf4j.LoggerFactory;

public class AccessJMSManagerThread
extends Thread {
    private static AccessJMSManagerThread m_instance;
    private Connection m_connection;
    private Session m_session;
    private LinkedList<AbstractJMSTask> m_taskList = new LinkedList();

    public static AccessJMSManagerThread getAccessJMSManagerThread() {
        if (m_instance == null) {
            m_instance = new AccessJMSManagerThread();
            m_instance.start();
        }
        return m_instance;
    }

    private AccessJMSManagerThread() {
        super("AccessJMSManagerThread");
        this.initSession();
    }

    public Session getSession() {
        return this.m_session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                AbstractJMSTask task = null;
                AccessJMSManagerThread accessJMSManagerThread = this;
                synchronized (accessJMSManagerThread) {
                    while (true) {
                        if (!this.m_taskList.isEmpty()) break;
                        this.wait();
                    }
                    task = this.m_taskList.poll();
                    this.notifyAll();
                }
                this.initSession();
                task.askJMS();
            }
        }
        catch (InterruptedException t) {
            LoggerFactory.getLogger((String)"mzDB-Task").debug("Unexpected exception in main loop of AccessServiceThread", (Throwable)t);
            m_instance = null;
            return;
        }
    }

    private void initSession() {
        if (this.m_connection == null) {
            try {
                this.m_connection = JMSConnectionManager.getJMSConnectionManager().getJMSConnection();
                this.m_connection.start();
                this.m_session = this.m_connection.createSession(false, 2);
            }
            catch (Exception je) {
                LoggerFactory.getLogger((String)"mzDB-Task").error("Unexpected exception when initializing JMS Connection", (Throwable)je);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTask(AbstractJMSTask task) {
        AccessJMSManagerThread accessJMSManagerThread = this;
        synchronized (accessJMSManagerThread) {
            this.m_taskList.add(task);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.m_session != null) {
            AccessJMSManagerThread accessJMSManagerThread = this;
            synchronized (accessJMSManagerThread) {
                try {
                    this.m_session.close();
                    this.m_taskList.clear();
                }
                catch (Exception exception) {
                }
                finally {
                    this.m_session = null;
                    this.m_connection = null;
                }
            }
        }
    }
}

