/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.threading.queue;

import fr.profi.mzDBWizard.processing.threading.queue.AbstractTask;
import fr.profi.mzDBWizard.processing.threading.queue.TaskManagerThread;
import fr.profi.mzDBWizard.processing.threading.queue.WorkerPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerThread
extends Thread {
    private final Logger m_logger = LoggerFactory.getLogger((String)this.getClass().toString());
    private AbstractTask m_action = null;
    private static int m_threadCounter = 0;
    private WorkerPool m_workerPool;

    public WorkerThread(WorkerPool workerPool) {
        super("WorkerThread" + m_threadCounter);
        ++m_threadCounter;
        this.m_workerPool = workerPool;
    }

    public synchronized boolean isAvailable() {
        return this.m_action == null;
    }

    public synchronized void setAction(AbstractTask action) {
        this.m_action = action;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                AbstractTask action;
                WorkerThread workerThread = this;
                synchronized (workerThread) {
                    while (true) {
                        if (this.m_action != null) break;
                        this.wait();
                    }
                    action = this.m_action;
                    this.notifyAll();
                }
                action.getTaskInfo().setRunning(true);
                try {
                    boolean success = action.runTask();
                    action.callback(success);
                }
                finally {
                    TaskManagerThread.getTaskManagerThread().actionDone(action);
                }
                workerThread = this;
                synchronized (workerThread) {
                    this.m_action = null;
                }
                this.m_workerPool.threadFinished();
            }
        }
        catch (Throwable t) {
            this.m_logger.debug("Unexpected exception in main loop of WorkerThread", t);
            return;
        }
    }
}

