/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.threading.task;

import fr.profi.mzDBWizard.processing.info.TaskError;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.threading.AbstractCallback;
import fr.profi.mzDBWizard.processing.threading.queue.AbstractTask;
import java.io.File;

public abstract class AbstractFileTask
extends AbstractTask {
    private File m_file;

    public AbstractFileTask(AbstractCallback callback, TaskInfo taskInfo, File file) {
        super(callback, taskInfo);
        this.m_file = file;
    }

    protected abstract boolean runTaskImplementation() throws Exception;

    public File getFile() {
        return this.m_file;
    }

    @Override
    public String getUniqueKey() {
        return this.m_file.getName().toLowerCase();
    }

    @Override
    public boolean precheck() throws Exception {
        boolean result = true;
        if (this.m_file == null) {
            this.m_taskError = new TaskError("File is not defined.");
            result = false;
        } else if (!this.m_file.exists()) {
            this.m_taskError = new TaskError("File " + this.m_file.getAbsolutePath() + " does not exist.");
            result = false;
        }
        return result;
    }

    @Override
    public boolean runTask() {
        try {
            if (!this.precheck()) {
                return false;
            }
            return this.runTaskImplementation();
        }
        catch (Exception e) {
            this.m_taskError = new TaskError(e);
            return false;
        }
    }
}

