/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.threading.task;

import fr.profi.mzDBWizard.configuration.ConfigurationManager;
import fr.profi.mzDBWizard.processing.info.TaskError;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.threading.AbstractCallback;
import fr.profi.mzDBWizard.processing.threading.task.AbstractFileTask;
import fr.profi.mzDBWizard.processing.threading.task.callback.ConvertRawFile2MzdbCallback;
import fr.profi.mzDBWizard.util.FileUtility;
import fr.profi.mzDBWizard.util.GenericUtil;
import fr.profi.mzdb.util.patch.DIAIsolationWindowsPatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;

public class ConvertRawFile2MzdbTask
extends AbstractFileTask {
    private Process m_conversionProcess = null;
    private boolean m_testMode = false;
    private String m_outputTempFilePath = null;
    private String m_outputMzdbFilePath = null;
    private static final int AVAILABLE_SPACE_THRESHOLD = 3000;

    public ConvertRawFile2MzdbTask(AbstractCallback callback, File f) {
        super(callback, new TaskInfo("Convert to mzdb : " + f.getName(), 0, true, TaskInfo.VisibilityEnum.VISIBLE), f);
    }

    public ConvertRawFile2MzdbTask(AbstractCallback callback, File f, boolean testMode) {
        super(callback, new TaskInfo("Convert to mzdb : " + f.getName(), 0, true, testMode ? TaskInfo.VisibilityEnum.VISIBLE_IF_ERROR : TaskInfo.VisibilityEnum.VISIBLE), f);
        this.m_testMode = testMode;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean precheck() throws Exception {
        boolean superResult = super.precheck();
        if (!superResult) {
            return false;
        }
        if (this.m_testMode) {
            File mzdbFile = new File("test.mzdb");
            if (mzdbFile.exists()) {
                this.m_taskError = new TaskError("Test mzdb file corresponding to " + this.getFile().getAbsolutePath() + " already exists.");
                return false;
            }
            this.m_outputMzdbFilePath = mzdbFile.getAbsolutePath();
            File tempFile = new File("test.mzdb.tmp");
            if (tempFile.exists()) {
                FileUtility.forceDeleteFile(tempFile);
            }
            this.m_outputTempFilePath = tempFile.getAbsolutePath();
        } else {
            int index;
            String path = this.getFile().getAbsolutePath();
            String mzdbFilePath = path.substring(0, (index = path.lastIndexOf(".")) + 1) + "mzdb";
            File mzdbFile = new File(mzdbFilePath);
            if (mzdbFile.exists()) {
                this.m_taskError = new TaskError("Mzdb file corresponding to " + this.getFile().getAbsolutePath() + " already exists.");
                return false;
            }
            this.m_outputMzdbFilePath = mzdbFilePath;
            String mzdbTmpFilePath = path.substring(0, index + 1) + "mzdb.tmp";
            File tempFile = new File(mzdbTmpFilePath);
            if (tempFile.exists()) {
                FileUtility.forceDeleteFile(tempFile);
            }
            this.m_outputTempFilePath = mzdbTmpFilePath;
        }
        return true;
    }

    @Override
    protected boolean runTaskImplementation() throws Exception {
        FileUtility.checkFileFinalization(this.getFile());
        if (!this.checkSufficientDiskSpace()) {
            this.m_taskError = new TaskError("Insufficient disk space to convert " + this.getFile().getAbsolutePath());
            return false;
        }
        if (!this.convertFile()) {
            return false;
        }
        try {
            while (this.m_conversionProcess != null && this.m_conversionProcess.isAlive()) {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException ex) {
            this.logger.error("File Finalization Interrupted!");
        }
        if (this.m_conversionProcess != null && this.m_conversionProcess.exitValue() == 0) {
            File tmpFile = new File(this.m_outputTempFilePath);
            File mzdbFile = new File(this.m_outputMzdbFilePath);
            if (tmpFile.exists()) {
                String log = tmpFile.getAbsolutePath() + " size is " + tmpFile.length() + " bytes";
                this.logger.debug(log);
                this.m_taskInfo.addLog(log);
                if (!tmpFile.renameTo(mzdbFile)) {
                    this.m_taskError = new TaskError("Temp File Renaming Failure", "File " + tmpFile.getAbsolutePath() + " could not be renamed.");
                    String log2 = "File " + tmpFile.getAbsolutePath() + " could not be renamed.";
                    this.logger.debug(log2);
                    this.m_taskInfo.addLog(log2);
                    return false;
                }
            } else {
                mzdbFile.renameTo(mzdbFile);
            }
            if (this.m_callback instanceof ConvertRawFile2MzdbCallback) {
                ((ConvertRawFile2MzdbCallback)this.m_callback).setRawFile(this.getFile());
            }
        } else {
            this.m_taskError = new TaskError("Converter Failure", "Non-zero exit value.");
            String log = "File converter for file " + this.getFile().getAbsolutePath() + " is not responding.";
            this.m_taskInfo.addLog(log);
            this.logger.info(log);
            return false;
        }
        String log = "Patching file " + this.m_outputMzdbFilePath;
        DIAIsolationWindowsPatch.run((String)this.m_outputMzdbFilePath);
        this.m_taskInfo.addLog(log);
        this.logger.info(log);
        log = "Converting for file: " + this.getFile().getAbsolutePath() + " has come to its end.";
        this.m_taskInfo.addLog(log);
        this.logger.info(log);
        return true;
    }

    private boolean convertFile() {
        try {
            String errorLine;
            String line;
            String workingFolder;
            ArrayList<String> command;
            String architecture = GenericUtil.getSystemArchitecture();
            if (architecture.contains("64")) {
                command = new ArrayList<String>();
                String converterPath = ConfigurationManager.getConverterPath();
                workingFolder = FilenameUtils.getFullPath((String)converterPath);
                workingFolder = workingFolder.isEmpty() ? "./" : workingFolder;
                command.add(converterPath);
                if (ConfigurationManager.getConverterOptions() != null && !ConfigurationManager.getConverterOptions().trim().isEmpty()) {
                    String options = ConfigurationManager.getConverterOptions();
                    String[] eachOptions = options.split(" ");
                    for (int i = 0; i < eachOptions.length; ++i) {
                        if (eachOptions[i].trim().isEmpty()) continue;
                        command.add(eachOptions[i].trim());
                    }
                }
            } else {
                this.m_taskError = new TaskError("This installation package is not supported by this processor type. Contact your administrator.");
                return false;
            }
            command.add("-i");
            command.add(this.getFile().getAbsolutePath());
            command.add("-o");
            command.add(this.m_outputTempFilePath);
            this.m_conversionProcess = new ProcessBuilder(new String[0]).command(command).directory(new File(workingFolder)).start();
            String usedConverter = ConfigurationManager.getConverterPath();
            this.m_taskInfo.addLog("------------------------------------------------------------------------");
            this.m_taskInfo.addLog("CONVERSION");
            this.m_taskInfo.addLog("------------------------------------------------------------------------");
            this.m_taskInfo.addLog("");
            String log = "Converter: " + usedConverter;
            this.logger.info(log);
            this.m_taskInfo.addLog(log);
            InputStream standardOutputStream = this.m_conversionProcess.getInputStream();
            BufferedReader standardReader = new BufferedReader(new InputStreamReader(standardOutputStream));
            while ((line = standardReader.readLine()) != null) {
                this.logger.info(line);
                this.m_taskInfo.addLog(line);
            }
            InputStream errorStream = this.m_conversionProcess.getErrorStream();
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(errorStream));
            while ((errorLine = errorReader.readLine()) != null) {
                this.logger.info("Warning:");
                this.logger.info(errorLine);
                this.m_taskInfo.addWarning("warning:");
                this.m_taskInfo.addLog(errorLine);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.m_taskError = new TaskError("Converter faced an IOException during conversion of " + this.getFile().getAbsolutePath() + ". Check input file's integrity.");
            this.logger.error("File convertion failed!");
            return false;
        }
        return true;
    }

    private boolean checkSufficientDiskSpace() {
        return this.getFile().getUsableSpace() / 1024L / 1024L > 3000L;
    }
}

