/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.threading.task;

import fr.profi.mzDBWizard.processing.info.TaskError;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.threading.AbstractCallback;
import fr.profi.mzDBWizard.processing.threading.task.AbstractFileTask;
import fr.profi.mzDBWizard.util.FileUtility;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;

public class DeleteFileTask
extends AbstractFileTask {
    public DeleteFileTask(AbstractCallback callback, File f) {
        super(callback, new TaskInfo("Delete file : " + f.getName(), 2, true, TaskInfo.VisibilityEnum.VISIBLE_IF_ERROR), f);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean precheck() throws Exception {
        boolean superResult = super.precheck();
        if (!superResult) {
            return false;
        }
        FileUtility.checkFileFinalization(this.getFile());
        this.getFile().setWritable(true);
        if (!this.getFile().canWrite()) {
            this.m_taskError = new TaskError("File is not writable : " + this.getFile().getAbsolutePath());
            return false;
        }
        return true;
    }

    @Override
    protected boolean runTaskImplementation() throws Exception {
        String log = "Starting to delete " + this.getFile().getAbsolutePath() + " file.";
        this.logger.info(log);
        this.m_taskInfo.addLog(log);
        return this.deleteFile(this.getFile());
    }

    private boolean deleteFile(File f) {
        return this.deleteFile(f, 0);
    }

    private boolean deleteFile(File f, int retry) {
        int MAX_RETRY = 5;
        try {
            Files.delete(f.toPath());
        }
        catch (NoSuchFileException x) {
            this.m_taskError = new TaskError("Trying to delete file " + f.getAbsolutePath() + ", which does not exist!");
            this.logger.error(this.m_taskError.getErrorTitle(), (Throwable)x);
            return false;
        }
        catch (DirectoryNotEmptyException x) {
            this.m_taskError = new TaskError("Directory " + f.getAbsolutePath() + " is not empty!");
            this.logger.error(this.m_taskError.getErrorTitle(), (Throwable)x);
            return false;
        }
        catch (IOException x) {
            if (retry < 5) {
                try {
                    Thread.sleep(1000 * retry);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.deleteFile(f, retry + 1);
            }
            this.m_taskError = new TaskError("You do not have the right to delete: " + f.toPath().toString() + "!");
            this.logger.error(this.m_taskError.getErrorTitle(), (Throwable)x);
            return false;
        }
        String log = "Finished to delete " + this.getFile().getAbsolutePath() + " file.";
        this.logger.info(log);
        this.m_taskInfo.addLog(log);
        return true;
    }
}

