/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.threading.task;

import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.jms.queue.AbstractJMSTask;
import fr.profi.mzDBWizard.processing.jms.queue.AccessJMSManagerThread;
import fr.profi.mzDBWizard.processing.jms.task.UploadFileJMSTask;
import fr.profi.mzDBWizard.processing.threading.AbstractCallback;
import fr.profi.mzDBWizard.processing.threading.task.AbstractFileTask;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;

public class UploadMzdbTask
extends AbstractFileTask {
    private Path m_directoryPath;
    private String m_pathLabel;

    public UploadMzdbTask(AbstractCallback callback, File f, File directory, String pathLabel) {
        super(callback, new TaskInfo("Updload : " + f.getName(), 1, true, TaskInfo.VisibilityEnum.VISIBLE), f);
        this.m_directoryPath = directory.toPath();
        this.m_pathLabel = pathLabel;
    }

    @Override
    public int getType() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean runTaskImplementation() {
        boolean m_uploadResult;
        this.logger.info("  -->  Upload file " + this.getFile().getName());
        UploadFileJMSTask task = new UploadFileJMSTask(null, this.getFile(), this.m_directoryPath, this.m_pathLabel);
        Object mutex = task.getMutex();
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask(task);
        try {
            Object object = mutex;
            synchronized (object) {
                while (!task.isTaskFinished()) {
                    mutex.wait();
                }
                m_uploadResult = task.getJMSState() == AbstractJMSTask.JMSState.STATE_DONE;
                TaskInfo jmsTaskInfo = task.getTaskInfo();
                this.m_taskError = jmsTaskInfo.getTaskError();
                ArrayList<String> logs = jmsTaskInfo.getLogs();
                if (logs.size() > 0) {
                    this.m_taskInfo.insertLogs(logs);
                }
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        return m_uploadResult;
    }
}

