/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.util;

import fr.profi.mzDBWizard.configuration.ConfigurationManager;
import fr.profi.mzDBWizard.util.GenericUtil;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtility {
    private static final Logger logger = LoggerFactory.getLogger((String)"FileUtil");

    public static void listFiles(String directoryName, ArrayList<File> files, boolean recursive) {
        File[] fList;
        File directory = new File(directoryName);
        for (File file : fList = directory.listFiles()) {
            if (file.isFile()) {
                files.add(file);
                continue;
            }
            if (!file.isDirectory() || !recursive) continue;
            FileUtility.listFiles(file.getAbsolutePath(), files, recursive);
        }
    }

    public static boolean forceDeleteFile(File f) {
        if (f.delete()) {
            return true;
        }
        try {
            Process process = new ProcessBuilder("rm -f " + f.getAbsolutePath()).start();
            while (process.isAlive()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(FileUtility.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return false;
    }

    public static boolean deleteFile(File f) {
        try {
            Files.delete(f.toPath());
        }
        catch (NoSuchFileException x) {
            logger.error("Trying to delete file " + f.getAbsolutePath() + ", which does not exist!", (Throwable)x);
            return false;
        }
        catch (DirectoryNotEmptyException x) {
            logger.error("Directory " + f.getAbsolutePath() + " is not empty!", (Throwable)x);
            return false;
        }
        catch (IOException x) {
            logger.error("You do not have the right to delete: " + f.toPath().toString() + "!", (Throwable)x);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompletelyWrittenOld(File file) {
        RandomAccessFile stream = null;
        try {
            stream = new RandomAccessFile(file, "rw");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.debug("Skipping file " + file.getName() + " for this iteration due it's not completely written");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.error("Exception during closing file " + file.getName());
                }
            }
        }
        return false;
    }

    public static boolean isCompletelyWritten(File file) {
        try {
            boolean success = file.renameTo(file);
            if (!success) {
                logger.debug("1. Skipping file " + file.getName() + " for this iteration due it's not completely written");
            }
            return success;
        }
        catch (Exception e) {
            logger.debug("2. Skipping file " + file.getName() + " for this iteration due it's not completely written");
            return false;
        }
    }

    public static void checkFileFinalization(File f) throws Exception {
        try {
            int nbTimesFileIdentical = 0;
            long previousSize = 0L;
            while (!FileUtility.isCompletelyWritten(f)) {
                Thread.sleep(5000L);
                long currentSize = f.length();
                if (currentSize == previousSize) {
                    if (++nbTimesFileIdentical != 120) continue;
                    throw new Exception("The file " + f.getAbsolutePath() + " is locked for 10 minutes without being modified");
                }
                nbTimesFileIdentical = 0;
            }
        }
        catch (InterruptedException ex) {
            logger.error("File Finalization Interrupted!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileUnlocked(File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file.getAbsolutePath());
            FileLock fl = fos.getChannel().tryLock();
            if (fl != null) {
                boolean bl = false;
                return bl;
            }
        }
        catch (FileNotFoundException ex) {
            java.util.logging.Logger.getLogger(GenericUtil.class.getName()).log(Level.SEVERE, null, ex);
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(GenericUtil.class.getName()).log(Level.SEVERE, null, ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(GenericUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return true;
    }

    public static void touch(File file) throws IOException {
        long timestamp = System.currentTimeMillis();
        FileUtility.touch(file, timestamp);
    }

    public static void touch(File file, long timestamp) throws IOException {
        if (!file.exists()) {
            new FileOutputStream(file).close();
        }
        file.setLastModified(timestamp);
    }

    public static File chooseDirectory() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setCurrentDirectory(new File(ConfigurationManager.getMonitorPath()));
        int result = jFileChooser.showOpenDialog(null);
        if (result == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static File chooseConverter() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter(".exe", "exe", "bat"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setCurrentDirectory(new File(ConfigurationManager.getConverterPath()));
        int result = jFileChooser.showOpenDialog(null);
        if (result == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyMzdbFile(File file) {
        boolean pass = true;
        try (MzDbReader reader = null;){
            long ms2SpectrumId;
            double[] mzList;
            reader = new MzDbReader(file, true);
            SpectrumHeader[] ms2Headers = reader.getMs2SpectrumHeaders();
            SpectrumHeader[] ms1Headers = reader.getMs1SpectrumHeaders();
            if (ms1Headers == null || ms1Headers.length < 1) {
                boolean bl = false;
                return bl;
            }
            long ms1SpectrumId = ms1Headers[0].getSpectrumId();
            if (ms1SpectrumId != 0L) {
                Spectrum ms1RawSpectrum = reader.getSpectrum(ms1SpectrumId);
                if (ms1RawSpectrum != null) {
                    SpectrumData ms1SpectrumData = ms1RawSpectrum.getData();
                    if (ms1SpectrumData != null) {
                        mzList = ms1SpectrumData.getMzList();
                        if (mzList == null || mzList.length < 1) {
                            pass = false;
                        }
                    } else {
                        pass = false;
                    }
                } else {
                    pass = false;
                }
            }
            if (ms2Headers != null && ms2Headers.length > 0 && (ms2SpectrumId = ms2Headers[0].getSpectrumId()) != 0L) {
                Spectrum ms2RawSpectrum = reader.getSpectrum(ms2SpectrumId);
                if (ms2RawSpectrum != null) {
                    SpectrumData ms2SpectrumData = ms2RawSpectrum.getData();
                    if (ms2SpectrumData != null) {
                        mzList = ms2SpectrumData.getMzList();
                        if (mzList == null || mzList.length < 1) {
                            pass = false;
                        }
                    } else {
                        pass = false;
                    }
                } else {
                    pass = false;
                }
            }
        }
        return pass;
    }
}

