/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.threading.queue;

import fr.profi.mzscope.threading.queue.AbstractCallback;
import fr.profi.mzscope.threading.task.TaskError;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask {
    protected AbstractCallback m_callback;
    protected Long m_id;
    private static long m_idIncrement = 0L;
    protected TaskError m_taskError = null;
    protected int m_errorId = -1;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().toString());

    public AbstractTask(AbstractCallback callback) {
        this.m_callback = callback;
        if (++m_idIncrement == Long.MAX_VALUE) {
            m_idIncrement = 0L;
        }
        this.m_id = m_idIncrement;
    }

    public abstract int getType();

    public abstract String getUniqueKey();

    public abstract boolean precheck();

    public abstract boolean runTask();

    public void callback(final boolean success) {
        if (this.m_callback == null) {
            return;
        }
        this.m_callback.setErrorMessage(this.m_taskError, this.m_errorId);
        if (this.m_callback.mustBeCalledInAWT()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractTask.this.m_callback.run(success, AbstractTask.this.m_id);
                }
            });
        } else {
            this.m_callback.run(success, this.m_id);
        }
    }

    public TaskError getTaskError() {
        return this.m_taskError;
    }
}

