/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.export;

import fr.proline.studio.export.CheckboxTabPanel;
import fr.proline.studio.export.CustomExportDialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

class TabTitleEditListener
extends MouseAdapter
implements MouseListener {
    private final JTextField editor = new JTextField();
    private final JTabbedPane tabbedPane;
    private int editingIdx = -1;
    private int len = -1;
    private Dimension dim;
    private CheckboxTabPanel tabComponent;
    private HashMap<String, String> m_tabTitleIdHashMap;
    CustomExportDialog m_customEd;
    private String m_formerTitle;

    public TabTitleEditListener(final JTabbedPane tabbedPane, CustomExportDialog ced) {
        this.m_tabTitleIdHashMap = ced.m_tabTitleIdHashMap;
        this.m_customEd = ced;
        this.tabbedPane = tabbedPane;
        this.editor.setBorder(BorderFactory.createEmptyBorder());
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TabTitleEditListener.this.renameTabTitle();
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TabTitleEditListener.this.renameTabTitle();
                } else if (e.getKeyCode() == 27) {
                    TabTitleEditListener.this.cancelEditing();
                } else {
                    TabTitleEditListener.this.editor.setPreferredSize(TabTitleEditListener.this.editor.getText().length() > TabTitleEditListener.this.len ? null : TabTitleEditListener.this.dim);
                    tabbedPane.revalidate();
                }
            }
        });
        tabbedPane.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "start-editing");
        tabbedPane.getActionMap().put("start-editing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabTitleEditListener.this.startEditing();
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        Rectangle rect = this.tabbedPane.getUI().getTabBounds(this.tabbedPane, this.tabbedPane.getSelectedIndex());
        if (rect != null && rect.contains(me.getPoint()) && me.getClickCount() == 2) {
            this.startEditing();
        } else {
            this.renameTabTitle();
        }
    }

    private void startEditing() {
        this.editingIdx = this.tabbedPane.getSelectedIndex();
        this.tabComponent = (CheckboxTabPanel)this.tabbedPane.getTabComponentAt(this.editingIdx);
        this.tabbedPane.setTabComponentAt(this.editingIdx, this.editor);
        this.editor.setVisible(true);
        this.m_formerTitle = this.tabComponent.getText();
        this.editor.setText(this.m_formerTitle);
        this.editor.selectAll();
        this.editor.requestFocusInWindow();
        this.len = this.editor.getText().length();
        this.dim = this.editor.getPreferredSize();
        this.editor.setMinimumSize(this.dim);
    }

    private void cancelEditing() {
        if (this.editingIdx >= 0) {
            this.tabbedPane.setTabComponentAt(this.editingIdx, this.tabComponent);
            this.editor.setVisible(false);
            this.editingIdx = -1;
            this.len = -1;
            this.tabComponent = null;
            this.editor.setPreferredSize(null);
            this.tabbedPane.requestFocusInWindow();
        }
    }

    private void renameTabTitle() {
        String title = this.editor.getText().trim();
        boolean canConfirmTitleChange = true;
        if (this.editingIdx >= 0 && !title.isEmpty()) {
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (this.editingIdx == i || !((CheckboxTabPanel)this.tabbedPane.getTabComponentAt(i)).getText().equals(title)) continue;
                this.cancelEditing();
                canConfirmTitleChange = false;
            }
            if (canConfirmTitleChange) {
                ((JTextField)this.tabbedPane.getTabComponentAt(this.editingIdx)).setText(title);
                this.tabComponent.setText(title);
                this.tabbedPane.setTabComponentAt(this.editingIdx, this.tabComponent);
                String sheetId = this.m_tabTitleIdHashMap.get(this.m_formerTitle);
                this.m_tabTitleIdHashMap.remove(this.m_formerTitle);
                this.m_tabTitleIdHashMap.put(title, sheetId);
            }
        }
        this.cancelEditing();
    }
}

