/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.venndiagram;

import fr.proline.studio.graphics.PlotVennDiagram;
import fr.proline.studio.graphics.venndiagram.Circle;
import fr.proline.studio.graphics.venndiagram.Set;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;

public class IntersectArea
implements Comparable<IntersectArea> {
    private final HashSet<Set> m_setIntersectedMap = new HashSet();
    private final HashSet<Set> m_setIntersectionsOriginMap = new HashSet();
    private Area m_intersectionArea = null;
    private String m_displayName = null;
    private static final Color[] DEFAULT_BASE_PALETTE = new Color[]{new Color(252, 180, 46), new Color(0, 147, 221), new Color(221, 18, 123), new Color(10, 255, 43), new Color(42, 23, 234), new Color(225, 43, 10)};
    private static Comparator m_specificSetComparator = null;

    public IntersectArea(Area a) {
        this.m_intersectionArea = a;
    }

    public Color getColor() {
        if (this.hasOneSet()) {
            return CyclicColorPalette.getColor(this.getOnlySet().getId(), DEFAULT_BASE_PALETTE);
        }
        int nb = this.m_setIntersectedMap.size();
        Color[] colors = new Color[nb];
        int index = 0;
        for (Set s : this.m_setIntersectedMap) {
            colors[index] = CyclicColorPalette.getColor(s.getId(), DEFAULT_BASE_PALETTE);
            ++index;
        }
        Color c = this.blend(colors);
        for (int i = 0; i < nb; ++i) {
            c = c.darker();
        }
        return c;
    }

    private Color blend(Color[] colors) {
        int nb = colors.length;
        float[] hsv = new float[3];
        for (int i = 0; i < 3; ++i) {
            hsv[i] = 0.0f;
        }
        float[] hsvTemp = new float[3];
        for (Color c : colors) {
            Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsvTemp);
            for (int i = 0; i < 3; ++i) {
                int n = i;
                hsv[n] = hsv[n] + hsvTemp[i];
            }
        }
        int i = 0;
        while (i < 3) {
            int n = i++;
            hsv[n] = hsv[n] / (float)nb;
        }
        return new Color(Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]));
    }

    public boolean isPotentialIntersect(IntersectArea intersectArea) {
        for (Set set1 : this.m_setIntersectedMap) {
            for (Set set2 : intersectArea.m_setIntersectedMap) {
                if (set1.intersect(set2)) continue;
                return false;
            }
        }
        return true;
    }

    public String getDisplayName(PlotVennDiagram vennDiagram) {
        if (this.m_displayName != null) {
            return this.m_displayName;
        }
        if (this.hasOneSet()) {
            this.m_displayName = this.getOnlySet().getDisplayName();
        } else {
            StringBuilder sb = new StringBuilder();
            Set[] setArray = new Set[this.m_setIntersectedMap.size()];
            setArray = this.m_setIntersectedMap.toArray(setArray);
            Arrays.sort(setArray, IntersectArea.getSpectificSetComparator());
            for (int i = 0; i < setArray.length; ++i) {
                sb.append(setArray[i].getName());
                if (i >= setArray.length - 1) continue;
                sb.append(' ').append(String.valueOf("\u2229")).append(' ');
            }
            sb.append(": ");
            sb.append(vennDiagram.getIntersectionSize(setArray));
            this.m_displayName = sb.toString();
        }
        return this.m_displayName;
    }

    public HashSet<Set> getIntersectedMap() {
        return this.m_setIntersectedMap;
    }

    public boolean hasOneSet() {
        return this.m_setIntersectedMap.size() == 1;
    }

    public Set getOnlySet() {
        if (!this.hasOneSet()) {
            return null;
        }
        return this.m_setIntersectedMap.iterator().next();
    }

    public IntersectArea(Set s) {
        this.m_setIntersectedMap.add(s);
        this.m_setIntersectionsOriginMap.add(s);
        Circle c = s.getCircle();
        double x = c.getX() - c.getRadius();
        double y = (int)Math.round(c.getY() - c.getRadius());
        double size = c.getRadius() * 2.0;
        Ellipse2D.Double ellipse = new Ellipse2D.Double(x, y, size, size);
        this.m_intersectionArea = new Area(ellipse);
    }

    public void addSet(Set s) {
        this.m_setIntersectedMap.add(s);
        this.m_setIntersectionsOriginMap.add(s);
    }

    public void addOriginSet(Set s) {
        this.m_setIntersectionsOriginMap.add(s);
    }

    public Area getArea() {
        return this.m_intersectionArea;
    }

    public ArrayList<IntersectArea> intersect(IntersectArea otherArea) {
        int size2;
        int size1 = this.m_setIntersectionsOriginMap.size();
        if (size1 <= (size2 = otherArea.m_setIntersectionsOriginMap.size()) ? this.testIntersectionDone(this.m_setIntersectionsOriginMap, otherArea.m_setIntersectionsOriginMap) : this.testIntersectionDone(otherArea.m_setIntersectionsOriginMap, this.m_setIntersectionsOriginMap)) {
            return null;
        }
        Area a1 = new Area(this.m_intersectionArea);
        a1.intersect(otherArea.getArea());
        if (a1.isEmpty()) {
            return null;
        }
        ArrayList<IntersectArea> resultList = new ArrayList<IntersectArea>();
        IntersectArea ia1 = new IntersectArea(a1);
        for (Set s : this.m_setIntersectedMap) {
            ia1.addSet(s);
        }
        for (Set s : otherArea.m_setIntersectedMap) {
            ia1.addSet(s);
        }
        for (Set s : this.m_setIntersectionsOriginMap) {
            ia1.addOriginSet(s);
        }
        for (Set s : otherArea.m_setIntersectionsOriginMap) {
            ia1.addOriginSet(s);
        }
        resultList.add(ia1);
        return resultList;
    }

    private boolean testIntersectionDone(HashSet<Set> hashSet1, HashSet<Set> hashSet2) {
        for (Set s1 : hashSet1) {
            if (hashSet2.contains(s1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(IntersectArea o) {
        int sizeB;
        int sizeA = this.m_setIntersectedMap.size();
        if (sizeA != (sizeB = o.m_setIntersectedMap.size())) {
            return sizeA - sizeB;
        }
        Object[] arrayA = this.m_setIntersectedMap.toArray();
        Arrays.sort(arrayA, IntersectArea.getSpectificSetComparator());
        Object[] arrayB = o.m_setIntersectedMap.toArray();
        Arrays.sort(arrayB, IntersectArea.getSpectificSetComparator());
        for (int i = 0; i < sizeA; ++i) {
            Set setA = (Set)arrayA[i];
            Set setB = (Set)arrayB[i];
            int delta = setA.getId() - setB.getId();
            if (delta == 0) continue;
            return delta;
        }
        return 0;
    }

    private static Comparator getSpectificSetComparator() {
        if (m_specificSetComparator == null) {
            m_specificSetComparator = new Comparator<Set>(){

                @Override
                public int compare(Set setA, Set setB) {
                    return setA.getId() - setB.getId();
                }
            };
        }
        return m_specificSetComparator;
    }
}

