/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class JCheckBoxList<E>
extends JList {
    private DefaultListModel<CheckListItem<E>> m_model;
    private ArrayList<ActionListener> m_listenerList = new ArrayList(1);

    public JCheckBoxList(List<? extends E> list, List<Boolean> visibilityList) {
        int size = list.size();
        CheckListItem[] items = new CheckListItem[size];
        this.m_model = new DefaultListModel();
        for (int i = 0; i < list.size(); ++i) {
            items[i] = new CheckListItem<E>(list.get(i), visibilityList.get(i));
            this.m_model.addElement(items[i]);
        }
        super.setModel(this.m_model);
        this.setCellRenderer(new CheckBoxListRenderer());
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                JCheckBoxList.this.selectItem(event.getPoint());
            }
        });
    }

    public void setModel(ListModel model) {
        throw new UnsupportedOperationException("Can't change model");
    }

    public int getListSize() {
        return this.getModel().getSize();
    }

    public boolean isVisible(int i) {
        return ((CheckListItem)this.getModel().getElementAt(i)).isSelected();
    }

    public void addItem(int index, E item, Boolean isVisible) {
        CheckListItem<E> cItem = new CheckListItem<E>(item, isVisible);
        this.m_model.add(index, cItem);
    }

    public E getElementAt(int index) {
        CheckListItem item = (CheckListItem)this.getModel().getElementAt(index);
        return item.getItem();
    }

    private void selectItem(Point point) {
        int index = this.locationToIndex(point);
        if (index >= 0) {
            CheckListItem item;
            item.setSelected(!(item = (CheckListItem)this.getModel().getElementAt(index)).isSelected());
            this.repaint(this.getCellBounds(index, index));
            for (int i = 0; i < this.m_listenerList.size(); ++i) {
                ActionEvent e = new ActionEvent(item, 1001, null, 0L, 0);
                this.m_listenerList.get(i).actionPerformed(e);
            }
        }
    }

    public void reinitSelection() {
        int size = this.getListSize();
        for (int i = 0; i < size; ++i) {
            CheckListItem item = (CheckListItem)this.getModel().getElementAt(i);
            item.setSelected(false);
        }
    }

    public void unselectAll() {
        this.selectAll(false);
    }

    public void selectAll() {
        this.selectAll(true);
    }

    private void selectAll(boolean selection) {
        ListModel m = this.getModel();
        int nb = m.getSize();
        for (int i = 0; i < nb; ++i) {
            CheckListItem item = (CheckListItem)m.getElementAt(i);
            item.setSelected(selection);
        }
    }

    public void selectItem(int index) {
        CheckListItem item = (CheckListItem)this.getModel().getElementAt(index);
        item.setSelected(true);
        this.repaint(this.getCellBounds(index, index));
    }

    public void selectItem(int index, boolean v) {
        CheckListItem item = (CheckListItem)this.getModel().getElementAt(index);
        item.setSelected(v);
        this.repaint(this.getCellBounds(index, index));
    }

    public List<E> getSelectedItems() {
        ArrayList list = new ArrayList();
        int size = this.getListSize();
        for (int i = 0; i < size; ++i) {
            CheckListItem item = (CheckListItem)this.getModel().getElementAt(i);
            if (!item.isSelected()) continue;
            list.add(item.getItem());
        }
        return list;
    }

    @Override
    public int[] getSelectedIndices() {
        int nbSelected = 0;
        int size = this.getListSize();
        for (int i = 0; i < size; ++i) {
            CheckListItem item = (CheckListItem)this.getModel().getElementAt(i);
            if (!item.isSelected()) continue;
            ++nbSelected;
        }
        int[] rv = new int[nbSelected];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            CheckListItem item = (CheckListItem)this.getModel().getElementAt(i);
            if (!item.isSelected()) continue;
            rv[j] = i;
            ++j;
        }
        return rv;
    }

    public int[] getNonSelectedIndices() {
        int nbNonSelected = 0;
        int size = this.getListSize();
        for (int i = 0; i < size; ++i) {
            CheckListItem item = (CheckListItem)this.getModel().getElementAt(i);
            if (item.isSelected()) continue;
            ++nbNonSelected;
        }
        int[] rv = new int[nbNonSelected];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            CheckListItem item = (CheckListItem)this.getModel().getElementAt(i);
            if (item.isSelected()) continue;
            rv[j] = i;
            ++j;
        }
        return rv;
    }

    public void addActionListener(ActionListener l) {
        this.m_listenerList.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.m_listenerList.remove(l);
    }

    public static class CheckListItem<E> {
        private E m_item;
        private boolean m_selected;

        public CheckListItem(E item, boolean selected) {
            this.m_item = item;
            this.m_selected = selected;
        }

        public E getItem() {
            return this.m_item;
        }

        public boolean isSelected() {
            return this.m_selected;
        }

        public void setSelected(boolean isSelected) {
            this.m_selected = isSelected;
        }

        public String toString() {
            return this.m_item.toString();
        }
    }

    private class CheckBoxListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private CheckBoxListRenderer() {
        }

        public Component getListCellRendererComponent(JList comp, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.setEnabled(comp.isEnabled());
            this.setSelected(((CheckListItem)value).isSelected());
            this.setFont(comp.getFont());
            this.setText(value.toString());
            this.setBackground(comp.getBackground());
            this.setForeground(comp.getForeground());
            return this;
        }
    }
}

