/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.parameter.ParameterError;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractParameter {
    protected String m_key;
    protected String m_name;
    protected Class m_type;
    protected Class m_graphicalType;
    protected JComponent m_parameterComponent = null;
    protected boolean m_used = true;
    protected boolean m_compulsory = true;
    protected Object m_associatedData = null;
    protected LabelVisibility m_labelVisibility = LabelVisibility.VISIBLE;
    protected ActionListener m_externalActionListener = null;
    protected List<String> m_backwardCompatibleKeys = new ArrayList<String>(1);

    protected AbstractParameter(String key, String name, Class type, Class graphicalType) {
        this.m_key = key;
        this.m_name = name;
        this.m_type = type;
        this.m_graphicalType = graphicalType;
    }

    public void setCompulsory(boolean v) {
        this.m_compulsory = v;
    }

    public String getName() {
        return this.m_name;
    }

    public String getKey() {
        return this.m_key;
    }

    public void addBackwardCompatibleKey(String backwardCompatibleKey) {
        this.m_backwardCompatibleKeys.add(backwardCompatibleKey);
    }

    public List<String> getBackwardCompatibleKeys() {
        return this.m_backwardCompatibleKeys;
    }

    public JComponent getComponent() {
        return this.m_parameterComponent;
    }

    public boolean componentNeedsScrollPane() {
        return false;
    }

    public abstract JComponent getComponent(Object var1);

    public abstract void initDefault();

    public abstract ParameterError checkParameter();

    public abstract boolean isEdited();

    public abstract String getStringValue();

    public abstract Object getObjectValue();

    public abstract void setValue(String var1);

    public Boolean hasComponent() {
        return true;
    }

    public LabelVisibility showLabel() {
        return this.m_labelVisibility;
    }

    public void forceShowLabel(LabelVisibility labelVisibility) {
        this.m_labelVisibility = labelVisibility;
    }

    public void clean() {
    }

    public boolean isUsed() {
        return this.m_used;
    }

    public void setUsed(boolean used) {
        this.m_used = used;
    }

    public boolean isCompulsory() {
        return this.m_compulsory;
    }

    public String toString() {
        return this.getName();
    }

    public void setAssociatedData(Object associatedData) {
        this.m_associatedData = associatedData;
    }

    public Object getAssociatedData() {
        return this.m_associatedData;
    }

    public void setExternalActionListener(ActionListener a) {
        this.m_externalActionListener = a;
    }

    public static enum LabelVisibility {
        NO_VISIBLE,
        VISIBLE,
        AS_BORDER_TITLE;

    }
}

