/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePreferences
extends AbstractPreferences {
    private static final Logger log = LoggerFactory.getLogger((String)"ProlineStudio.Commons");
    private Map<String, String> root;
    private Map<String, FilePreferences> children;
    private boolean isRemoved = false;
    private File m_file = null;

    public FilePreferences(File f, AbstractPreferences parent, String name) {
        super(parent, name);
        this.m_file = f;
        this.root = new TreeMap<String, String>();
        this.children = new TreeMap<String, FilePreferences>();
        try {
            this.sync();
        }
        catch (BackingStoreException e) {
            log.error("Unable to sync on creation of node " + name, (Throwable)e);
        }
    }

    @Override
    public void put(String key, String value) {
        int size = value.length();
        if (size > 8192) {
            int cnt = 1;
            int idx = 0;
            while (idx < size) {
                if (size - idx > 8192) {
                    super.put(key + "." + cnt, value.substring(idx, idx + 8192));
                    idx += 8192;
                } else {
                    super.put(key + "." + cnt, value.substring(idx));
                    idx = size;
                }
                ++cnt;
            }
        } else {
            super.put(key, value);
        }
    }

    @Override
    public String get(String key, String def) {
        String s;
        String value = super.get(key, null);
        if (value != null) {
            return value;
        }
        int cnt = 1;
        StringBuilder sb = new StringBuilder();
        while ((s = super.get(key + "." + cnt, null)) != null) {
            sb.append(s);
            ++cnt;
        }
        value = sb.length() > 0 ? sb.toString() : def;
        return value;
    }

    @Override
    protected void putSpi(String key, String value) {
        this.root.put(key, value);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            log.error("Unable to flush after putting " + key, (Throwable)e);
        }
    }

    @Override
    protected String getSpi(String key) {
        return this.root.get(key);
    }

    @Override
    protected void removeSpi(String key) {
        this.root.remove(key);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            log.error("Unable to flush after removing " + key, (Throwable)e);
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.isRemoved = true;
        this.flush();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        return this.root.keySet().toArray(new String[this.root.keySet().size()]);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return this.children.keySet().toArray(new String[this.children.keySet().size()]);
    }

    @Override
    protected FilePreferences childSpi(String name) {
        FilePreferences child = this.children.get(name);
        if (child == null || child.isRemoved()) {
            child = new FilePreferences(this.m_file, this, name);
            this.children.put(name, child);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncSpi() throws BackingStoreException {
        if (this.isRemoved()) {
            return;
        }
        if (!this.m_file.exists()) {
            return;
        }
        File file = this.m_file;
        synchronized (file) {
            Properties p = new Properties();
            try {
                p.load(new FileInputStream(this.m_file));
                StringBuilder sb = new StringBuilder();
                this.getPath(sb);
                String path = sb.toString();
                Enumeration<?> pnen = p.propertyNames();
                while (pnen.hasMoreElements()) {
                    String propKey = (String)pnen.nextElement();
                    if (!propKey.startsWith(path)) continue;
                    String subKey = propKey.substring(path.length());
                    this.root.put(subKey, p.getProperty(propKey));
                }
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
    }

    private void getPath(StringBuilder sb) {
        FilePreferences parent = (FilePreferences)this.parent();
        if (parent == null) {
            return;
        }
        parent.getPath(sb);
        sb.append(this.name()).append('.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        File file = this.m_file;
        synchronized (file) {
            Properties p = new Properties();
            try {
                StringBuilder sb = new StringBuilder();
                this.getPath(sb);
                String path = sb.toString();
                if (this.m_file.exists()) {
                    p.load(new FileInputStream(this.m_file));
                    ArrayList<String> toRemove = new ArrayList<String>();
                    Enumeration<?> pnen = p.propertyNames();
                    while (pnen.hasMoreElements()) {
                        String propKey = (String)pnen.nextElement();
                        if (!propKey.startsWith(path)) continue;
                        String subKey = propKey.substring(path.length());
                        toRemove.add(propKey);
                    }
                    for (String propKey : toRemove) {
                        p.remove(propKey);
                    }
                }
                if (!this.isRemoved) {
                    for (String s : this.root.keySet()) {
                        p.setProperty(path + s, this.root.get(s));
                    }
                }
                p.store(new FileOutputStream(this.m_file), "FilePreferences");
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
    }
}

