/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock.container;

import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.dock.container.DockComponent;
import fr.proline.studio.dock.container.DockContainer;
import fr.proline.studio.dock.container.DockContainerMulti;
import fr.proline.studio.dock.container.DockException;
import fr.proline.studio.dock.container.DockMultiInterface;
import fr.proline.studio.dock.container.DockPosition;
import fr.proline.studio.dock.container.DockReplaceInterface;
import fr.proline.studio.dock.dragdrop.OverArea;
import fr.proline.studio.dock.gui.DraggingOverlayPanel;
import fr.proline.studio.dock.gui.InfoLabel;
import fr.proline.studio.dock.gui.MemoryPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class DockContainerRoot
extends DockContainer
implements DockMultiInterface,
DockReplaceInterface {
    private final HashMap<DockContainerMulti, DockPosition> m_containerMap = new HashMap();
    private final DraggingOverlayPanel m_draggingOverlayPanel;
    private JPanel m_mainPanel;
    private InfoLabel m_infoLabel;
    private MemoryPanel m_memoryPanel;
    private boolean firstDrag = true;

    public DockContainerRoot() {
        this.m_component = new JPanel(new BorderLayout());
        this.m_draggingOverlayPanel = new DraggingOverlayPanel(this);
        this.initComponents();
    }

    private void initComponents() {
        this.m_mainPanel = new JPanel(new BorderLayout());
        this.m_mainPanel.add((Component)this.m_component, "Center");
        JPanel southPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.m_memoryPanel = new MemoryPanel();
        southPanel.add((Component)this.m_memoryPanel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_infoLabel = new InfoLabel();
        southPanel.add((Component)this.m_infoLabel, c);
        this.m_mainPanel.add((Component)southPanel, "South");
    }

    public JPanel getMainPanel() {
        return this.m_mainPanel;
    }

    public InfoLabel getInfoLabel() {
        return this.m_infoLabel;
    }

    public MemoryPanel getMemoryPanel() {
        return this.m_memoryPanel;
    }

    @Override
    public void getTopPanels(HashSet<AbstractTopPanel> set) {
        for (DockContainerMulti c : this.m_containerMap.keySet()) {
            c.getTopPanels(set);
        }
    }

    @Override
    public DockContainer search(String windowKey) {
        for (DockContainerMulti c : this.m_containerMap.keySet()) {
            DockContainer containerSearched = c.search(windowKey);
            if (containerSearched == null) continue;
            return containerSearched;
        }
        return null;
    }

    @Override
    public DockContainer searchZoneArea(String zoneArea) {
        for (DockContainerMulti c : this.m_containerMap.keySet()) {
            DockContainer containerSearched = c.searchZoneArea(zoneArea);
            if (containerSearched == null) continue;
            return containerSearched;
        }
        return null;
    }

    @Override
    public void findAllDockComponents(ArrayList<DockComponent> components) {
        for (DockContainerMulti c : this.m_containerMap.keySet()) {
            c.findAllDockComponents(components);
        }
    }

    public void add(DockContainer container, DockPosition position) throws DockException {
        if (!(container instanceof DockContainerMulti)) {
            throw new DockException("Must add DockContainerMulti to DockContainerRoot");
        }
        this.m_containerMap.put((DockContainerMulti)container, position);
        ((JPanel)this.m_component).add((Component)container.getComponent(), position.getBorderLayout());
        container.setParent(this);
    }

    @Override
    public OverArea getOverArea(Point screenPoint) {
        for (DockContainerMulti container : this.m_containerMap.keySet()) {
            OverArea overArea = container.getOverArea(screenPoint);
            if (overArea == null) continue;
            return overArea;
        }
        return null;
    }

    public void startDragging() {
        if (this.firstDrag) {
            this.firstDrag = false;
            JRootPane rootPane = this.m_component.getRootPane();
            rootPane.setGlassPane(this.m_draggingOverlayPanel);
        }
        this.m_draggingOverlayPanel.setVisible(true);
        this.m_component.repaint();
    }

    public void stopDragging() {
        this.m_draggingOverlayPanel.setVisible(false);
        this.m_component.repaint();
    }

    @Override
    public void replace(DockContainerMulti previous, DockContainerMulti next) {
        DockPosition position = this.m_containerMap.remove(previous);
        JPanel panel = (JPanel)this.m_component;
        panel.remove(previous.getComponent());
        panel.add((Component)next.getComponent(), position.getBorderLayout());
        this.m_containerMap.put(next, position);
        next.setParent(this);
        panel.revalidate();
        panel.repaint();
    }

    @Override
    public void check() {
        for (DockContainer dockContainer : this.m_containerMap.keySet()) {
            if (dockContainer.getParent() != this) {
                System.err.println("Wrong Parent");
            }
            if (dockContainer.getComponent().getParent() != this.getComponent()) {
                System.err.println("Wrong Parent AWT");
            }
            dockContainer.check();
        }
    }
}

