/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.export;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class CheckboxTabPanel
extends JPanel {
    private String m_sheetId = null;
    private JCheckBox m_checkBox;
    private JLabel m_label;
    private JTabbedPane ctrlPane;

    public CheckboxTabPanel(JTabbedPane tabbedPane, String title, String sheetId) {
        this.setLayout(new FlowLayout());
        this.setOpaque(false);
        this.ctrlPane = tabbedPane;
        this.m_sheetId = sheetId;
        this.m_checkBox = new JCheckBox();
        this.m_checkBox.setOpaque(false);
        this.m_label = new JLabel(title);
        this.add(this.m_checkBox);
        this.add(this.m_label);
        final CheckboxTabPanel _this = this;
        this.m_checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = CheckboxTabPanel.this.m_checkBox.isSelected();
                int indexCur = -1;
                int nbTabs = CheckboxTabPanel.this.ctrlPane.getTabCount();
                for (int i = 0; i < nbTabs; ++i) {
                    Component tabComponent = CheckboxTabPanel.this.ctrlPane.getTabComponentAt(i);
                    if (tabComponent != _this) continue;
                    indexCur = i;
                    break;
                }
                if (indexCur != -1) {
                    CheckboxTabPanel.this.ctrlPane.setEnabledAt(indexCur, isSelected);
                }
                if (isSelected) {
                    CheckboxTabPanel.this.m_label.setForeground(Color.black);
                } else {
                    CheckboxTabPanel.this.m_label.setForeground(Color.lightGray);
                }
            }
        });
    }

    public void setSelected(boolean isSelected) {
        this.m_checkBox.setSelected(isSelected);
        if (isSelected) {
            this.m_label.setForeground(Color.black);
        } else {
            this.m_label.setForeground(Color.lightGray);
        }
    }

    public boolean isSelected() {
        return this.m_checkBox.isSelected();
    }

    public String getText() {
        return this.m_label.getText();
    }

    public void setText(String text) {
        this.m_label.setText(text);
    }

    public String getSheetId() {
        return this.m_sheetId;
    }

    public void setSheetId(String sheetId) {
        this.m_sheetId = sheetId;
    }
}

