/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.extendedtablemodel;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.BestGraphicsInterface;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import java.util.ArrayList;
import java.util.Map;

public class LockedDataModel
implements ExtendedTableModelInterface,
BestGraphicsInterface {
    private ExtendedTableModelInterface m_src;
    private final int m_rowCount;
    private final int m_columnCount;
    private final String[] m_columnIdentifiers;
    private final Class[] m_columnClasses;
    private final int[] m_keysColumns;
    private final int m_infoCol;
    private final String m_name;
    private final Object[][] m_data;
    private final long[] m_uniqueIDs;

    public LockedDataModel(ExtendedTableModelInterface src) {
        int i;
        this.m_src = src;
        this.m_rowCount = src.getRowCount();
        this.m_columnCount = src.getColumnCount();
        this.m_columnIdentifiers = new String[this.m_columnCount];
        this.m_columnClasses = new Class[this.m_columnCount];
        for (i = 0; i < this.m_columnCount; ++i) {
            this.m_columnIdentifiers[i] = src.getDataColumnIdentifier(i);
            this.m_columnClasses[i] = src.getDataColumnClass(i);
        }
        this.m_keysColumns = src.getKeysColumn();
        this.m_name = src.getName();
        this.m_data = new Object[this.m_rowCount][this.m_columnCount];
        this.m_uniqueIDs = new long[this.m_rowCount];
        for (i = 0; i < this.m_rowCount; ++i) {
            this.m_uniqueIDs[i] = src.row2UniqueId(i);
            for (int j = 0; j < this.m_columnCount; ++j) {
                this.m_data[i][j] = src.getDataValueAt(i, j);
            }
        }
        this.m_infoCol = src.getInfoColumn();
    }

    public ExtendedTableModelInterface getSrcDataInterface() {
        return this.m_src;
    }

    @Override
    public int getInfoColumn() {
        return this.m_infoCol;
    }

    @Override
    public int getRowCount() {
        return this.m_rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.m_columnCount;
    }

    @Override
    public String getDataColumnIdentifier(int columnIndex) {
        return this.m_columnIdentifiers[columnIndex];
    }

    @Override
    public Class getDataColumnClass(int columnIndex) {
        return this.m_columnClasses[columnIndex];
    }

    @Override
    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.m_data[rowIndex][columnIndex];
    }

    @Override
    public int[] getKeysColumn() {
        return this.m_keysColumns;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public PlotType getBestPlotType() {
        if (this.m_src instanceof BestGraphicsInterface) {
            return ((BestGraphicsInterface)((Object)this.m_src)).getBestPlotType();
        }
        return null;
    }

    @Override
    public int[] getBestColIndex(PlotType plotType) {
        if (this.m_src instanceof BestGraphicsInterface) {
            return ((BestGraphicsInterface)((Object)this.m_src)).getBestColIndex(plotType);
        }
        return null;
    }

    @Override
    public Map<String, Object> getExternalData() {
        return this.m_src.getExternalData();
    }

    @Override
    public PlotInformation getPlotInformation() {
        return this.m_src.getPlotInformation();
    }

    @Override
    public long row2UniqueId(int rowIndex) {
        return this.m_uniqueIDs[rowIndex];
    }

    @Override
    public int uniqueId2Row(long id) {
        int nb = this.m_uniqueIDs.length;
        for (int i = 0; i < nb; ++i) {
            if (id != this.m_uniqueIDs[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return this.m_src.getExtraDataTypes();
    }

    @Override
    public Object getValue(Class c) {
        return this.m_src.getValue(c);
    }

    @Override
    public Object getRowValue(Class c, int row) {
        return this.m_src.getRowValue(c, row);
    }

    @Override
    public Object getColValue(Class c, int col) {
        return this.m_src.getColValue(c, col);
    }

    @Override
    public void addSingleValue(Object v) {
    }

    @Override
    public Object getSingleValue(Class c) {
        return this.m_src.getSingleValue(c);
    }

    @Override
    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }
}

