/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife.mgf;

import fr.profi.mzknife.mgf.MGFRewriter;
import fr.profi.mzscope.InvalidMGFFormatException;
import fr.profi.mzscope.MGFConstants;
import fr.profi.mzscope.MSMSSpectrum;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGFFilter
extends MGFRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(MGFFilter.class);
    List<Integer> charges;
    Boolean toExclude;

    public MGFFilter(File srcFile, File dstFile) throws InvalidMGFFormatException {
        super(srcFile, dstFile);
    }

    public void setExcludeCharges(List<Integer> charges2Exclude) {
        this.charges = charges2Exclude;
        this.toExclude = true;
    }

    public void setCharges(List<Integer> charges2Keep) {
        this.charges = charges2Keep;
        this.toExclude = false;
    }

    @Override
    protected MSMSSpectrum getSpectrum2Export(MSMSSpectrum inSpectrum) {
        boolean sameCharge = this.charges.contains(inSpectrum.getPrecursorCharge());
        if (sameCharge && this.toExclude.booleanValue() || !sameCharge && !this.toExclude.booleanValue()) {
            LOG.debug(" Spectrum {} is rejected.", inSpectrum.getAnnotation(MGFConstants.TITLE));
            return null;
        }
        return inSpectrum;
    }
}

