/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.primitives;

public class BytesUtils {
    public static final int BYTE_LEN = 1;
    public static final int SHORT_LEN = 2;
    public static final int INT_LEN = 4;
    public static final int FLOAT_LEN = 4;
    public static final int LONG_LEN = 8;
    public static final int DOUBLE_LEN = 8;

    public static int intToBytes(int num, byte[] bytes, int startIndex) {
        bytes[startIndex] = (byte)(num & 0xFF);
        bytes[startIndex + 1] = (byte)(num >> 8 & 0xFF);
        bytes[startIndex + 2] = (byte)(num >> 16 & 0xFF);
        bytes[startIndex + 3] = (byte)(num >> 24 & 0xFF);
        return startIndex + 4;
    }

    public static int bytesToInt(byte[] bytes, int startIndex) {
        return bytes[startIndex] & 0xFF | (bytes[startIndex + 1] & 0xFF) << 8 | (bytes[startIndex + 2] & 0xFF) << 16 | (bytes[startIndex + 3] & 0xFF) << 24;
    }

    public static int floatToBytes(float fnum, byte[] bytes, int startIndex) {
        return BytesUtils.intToBytes(Float.floatToIntBits(fnum), bytes, startIndex);
    }

    public static float bytesToFloat(byte[] bytes, int startIndex) {
        return Float.intBitsToFloat(BytesUtils.bytesToInt(bytes, startIndex));
    }

    public static int shortToBytes(short num, byte[] bytes, int startIndex) {
        bytes[startIndex] = (byte)(num & 0xFF);
        bytes[startIndex + 1] = (byte)(num >> 8 & 0xFF);
        return startIndex + 2;
    }

    public static short bytesToShort(byte[] bytes, int startIndex) {
        return (short)(bytes[startIndex] & 0xFF | (bytes[startIndex + 1] & 0xFF) << 8);
    }

    public static int stringToBytes(String str, byte[] bytes, int startIndex) {
        int len = str.length();
        byte[] temp = str.getBytes();
        if (len > 255) {
            System.err.println("String has more than 255 bytes in \"stringToBytes\", it will be truncated.");
            bytes[startIndex++] = -1;
            System.arraycopy(temp, 0, bytes, startIndex, 255);
            return startIndex + 255;
        }
        bytes[startIndex++] = (byte)len;
        System.arraycopy(temp, 0, bytes, startIndex, len);
        return startIndex + len;
    }

    public static String bytesToString(byte[] bytes, int startIndex) {
        int len = bytes[startIndex++] & 0xFF;
        return new String(bytes, startIndex, len);
    }

    public static int longToBytes(long lnum, byte[] bytes, int startIndex) {
        for (int i = 0; i < 8; ++i) {
            bytes[startIndex + i] = (byte)(lnum >> i * 8 & 0xFFL);
        }
        return startIndex + 8;
    }

    public static long bytesToLong(byte[] bytes, int startIndex) {
        return (long)bytes[startIndex] & 0xFFL | ((long)bytes[startIndex + 1] & 0xFFL) << 8 | ((long)bytes[startIndex + 2] & 0xFFL) << 16 | ((long)bytes[startIndex + 3] & 0xFFL) << 24 | ((long)bytes[startIndex + 4] & 0xFFL) << 32 | ((long)bytes[startIndex + 5] & 0xFFL) << 40 | ((long)bytes[startIndex + 6] & 0xFFL) << 48 | ((long)bytes[startIndex + 7] & 0xFFL) << 56;
    }

    public static int doubleToBytes(double dnum, byte[] bytes, int startIndex) {
        return BytesUtils.longToBytes(Double.doubleToLongBits(dnum), bytes, startIndex);
    }

    public static double bytesToDouble(byte[] bytes, int startIndex) {
        return Double.longBitsToDouble(BytesUtils.bytesToLong(bytes, startIndex));
    }
}

