/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AtomChain;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.pride.CvTerm;
import java.util.HashMap;

public class NeutralLoss
extends ExperimentObject {
    static final long serialVersionUID = 5540846193082177391L;
    public static final NeutralLoss H2O = new NeutralLoss("H2O", AtomChain.getAtomChain("H(2)O"), false, new char[]{'D', 'E', 'S', 'T'});
    public static final NeutralLoss NH3 = new NeutralLoss("NH3", AtomChain.getAtomChain("NH(3)"), false, new char[]{'K', 'N', 'Q', 'R'});
    public static final NeutralLoss H3PO4 = new NeutralLoss("H3PO4", AtomChain.getAtomChain("H(3)PO(4)"), false);
    public static final NeutralLoss HPO3 = new NeutralLoss("HPO3", AtomChain.getAtomChain("HPO(3)"), false);
    public static final NeutralLoss CH4OS = new NeutralLoss("CH4OS", AtomChain.getAtomChain("CH(4)OS"), false);
    public static final NeutralLoss C3H9N = new NeutralLoss("C3H9N", AtomChain.getAtomChain("C(3)H(9)N"), false);
    private Double mass;
    private AtomChain composition;
    public final String name;
    private Boolean fixed = false;
    private static HashMap<String, NeutralLoss> neutralLosses;
    private CvTerm psiCvTerm = null;
    public final char[] aminoAcids;

    public NeutralLoss(String name, AtomChain composition, boolean fixed, char[] aminoAcids) {
        this(name, composition, fixed, aminoAcids, true);
    }

    public NeutralLoss(String name, AtomChain composition, boolean fixed) {
        this(name, composition, fixed, null, true);
    }

    public NeutralLoss(String name, AtomChain composition, boolean fixed, char[] aminoAcids, boolean save) {
        this.name = name;
        this.composition = composition;
        this.fixed = fixed;
        this.aminoAcids = aminoAcids;
        if (save) {
            NeutralLoss.addNeutralLoss(this);
        }
    }

    public static void addNeutralLoss(NeutralLoss neutralLoss) {
        if (neutralLosses == null) {
            neutralLosses = new HashMap();
        }
        neutralLosses.put(neutralLoss.name, neutralLoss);
    }

    public static NeutralLoss getNeutralLoss(String name) {
        if (neutralLosses == null) {
            return null;
        }
        return neutralLosses.get(name);
    }

    public static void removeNeutralLoss(String name) {
        if (neutralLosses != null) {
            neutralLosses.remove(name);
        }
    }

    public CvTerm getPsiMsCvTerm() {
        if (this.psiCvTerm != null) {
            return this.psiCvTerm;
        }
        this.psiCvTerm = new CvTerm("PSI-MS", "MS:1000336", "neutral loss", this.composition.toString());
        return this.psiCvTerm;
    }

    public boolean isFixed() {
        if (this.fixed == null) {
            this.fixed = false;
        }
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public AtomChain getComposition() {
        return this.composition;
    }

    public void setComposition(AtomChain composition) {
        this.composition = composition;
    }

    public Double getMass() {
        if (this.composition != null) {
            return this.composition.getMass();
        }
        return this.mass;
    }

    public boolean isSameAs(NeutralLoss anotherNeutralLoss) {
        if (anotherNeutralLoss.getComposition() == null || this.getComposition() == null) {
            return anotherNeutralLoss.name.equals(this.name) && anotherNeutralLoss.mass.equals(this.mass);
        }
        return anotherNeutralLoss.name.equals(this.name) && anotherNeutralLoss.getComposition().isSameCompositionAs(this.getComposition());
    }

    public NeutralLoss clone() {
        return new NeutralLoss(this.name, this.composition.clone(), this.fixed, this.aminoAcids, false);
    }
}

