/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PrecursorIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;

public abstract class SpectrumIdentificationAssumption
extends ExperimentObject {
    static final long serialVersionUID = 496273793273328259L;
    protected int rank;
    protected int advocate;
    protected Charge identificationCharge;
    protected Double score;
    protected String identificationFile;
    protected Double rawScore;
    protected ArrayList<double[]> aminoAcidScores = null;

    public int getRank() {
        return this.rank;
    }

    public void setRank(int aRank) {
        this.rank = aRank;
    }

    public int getAdvocate() {
        return this.advocate;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String getIdentificationFile() {
        return this.identificationFile;
    }

    public Charge getIdentificationCharge() {
        return this.identificationCharge;
    }

    public void setIdentificationCharge(Charge identificationCharge) {
        this.identificationCharge = identificationCharge;
    }

    public abstract Double getTheoreticMass() throws InterruptedException;

    public Double getTheoreticMz() throws InterruptedException {
        return (this.getTheoreticMass() + ElementaryIon.proton.getTheoreticMass() * (double)this.identificationCharge.value) / (double)this.identificationCharge.value;
    }

    public Double getDeltaMass(double measuredMZ, boolean ppm, int minIsotope, int maxIsotope) throws InterruptedException {
        return this.getPrecursorMatch(new Peak(measuredMZ, 0.0, 0.0)).getError(ppm, minIsotope, maxIsotope);
    }

    public int getIsotopeNumber(double measuredMZ, int minIsotope, int maxIsotope) throws InterruptedException {
        return this.getPrecursorMatch(new Peak(measuredMZ, 0.0, 0.0)).getIsotopeNumber(minIsotope, maxIsotope);
    }

    public IonMatch getPrecursorMatch(Peak precursorPeak) throws InterruptedException {
        return new IonMatch(precursorPeak, new PrecursorIon(this.getTheoreticMass()), this.getIdentificationCharge().value);
    }

    public Double getRawScore() {
        return this.rawScore;
    }

    public void setRawScore(Double rawScore) {
        this.rawScore = rawScore;
    }

    public ArrayList<double[]> getAminoAcidScores() {
        return this.aminoAcidScores;
    }

    public void setAminoAcidScores(ArrayList<double[]> aminoAcidScores) {
        this.aminoAcidScores = aminoAcidScores;
    }
}

