/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.executable;

import com.compomics.util.exceptions.exception_handlers.CommandLineExceptionHandler;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.MassGap;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.amino_acid_tags.matchers.TagMatcher;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.protein_inference.PeptideMapper;
import com.compomics.util.experiment.identification.protein_inference.PeptideMapperType;
import com.compomics.util.experiment.identification.protein_inference.PeptideProteinMapping;
import com.compomics.util.experiment.identification.protein_inference.fm_index.FMIndex;
import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTree;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.PeptideVariantsPreferences;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class PeptideMapping {
    public static void main(String[] args) {
        if (args.length > 0 && (args[0].equals("-h") || args[0].equals("--help")) || args.length < 4 || !args[0].equals("-p") && !args[0].equals("-t")) {
            System.err.println("PeptideMapping: a tool to map peptides or sequence tags against a given proteome.");
            System.err.println("usage: PeptideMapping -[p|t] input-fasta input-peptide/tag-csv output-csv [utilities-parameter-file]");
            System.err.println();
            System.err.println("Options are:");
            System.err.println("\t-p\tpeptide mapping");
            System.err.println("\t-t\tsequence tag mapping");
            System.err.println("\t-h\tprint this info");
            System.err.println();
            System.err.println("Default parameters:");
            System.err.println("\tindexing method:\t\tfm-index");
            System.err.println("\tframentation tolerance [Da]:\t0.02");
            System.exit(-1);
        }
        PeptideMapperType peptideMapperType = PeptideMapperType.fm_index;
        System.err.println("Start reading FASTA file");
        WaitingHandlerCLIImpl waitingHandlerCLIImpl = new WaitingHandlerCLIImpl();
        File sequences = new File(args[1]);
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        try {
            sequenceFactory.loadFastaFile(sequences, waitingHandlerCLIImpl);
        }
        catch (Exception e) {
            System.err.println("Error: cound not open FASTA file");
            System.exit(-1);
        }
        SearchParameters searchParameters = null;
        PeptideVariantsPreferences peptideVariantsPreferences = null;
        SequenceMatchingPreferences sequenceMatchingPreferences = null;
        if (args.length >= 5) {
            File parameterFile = new File(args[4]);
            IdentificationParameters identificationParameters = null;
            try {
                identificationParameters = IdentificationParameters.getIdentificationParameters(parameterFile);
            }
            catch (Exception e) {
                System.err.println("Error: cound not open / parse parameter file");
                System.exit(-1);
            }
            if (peptideMapperType != identificationParameters.getSequenceMatchingPreferences().getPeptideMapperType()) {
                peptideMapperType = identificationParameters.getSequenceMatchingPreferences().getPeptideMapperType();
                System.err.println("New mapping index: " + peptideMapperType.name);
            }
            peptideVariantsPreferences = PeptideVariantsPreferences.getNoVariantPreferences();
            sequenceMatchingPreferences = identificationParameters.getSequenceMatchingPreferences();
            searchParameters = identificationParameters.getSearchParameters();
        } else {
            peptideVariantsPreferences = PeptideVariantsPreferences.getNoVariantPreferences();
            searchParameters = new SearchParameters();
            searchParameters.setPtmSettings(new PtmSettings());
            searchParameters.setFragmentIonAccuracy(0.02);
            searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.DA);
            sequenceMatchingPreferences = new SequenceMatchingPreferences();
            sequenceMatchingPreferences.setSequenceMatchingType(SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids);
            sequenceMatchingPreferences.setLimitX(0.25);
        }
        System.err.println("Start indexing proteome");
        long startTimeIndex = System.nanoTime();
        PeptideMapper peptideMapper = null;
        if (peptideMapperType == PeptideMapperType.fm_index) {
            peptideMapper = new FMIndex((WaitingHandler)waitingHandlerCLIImpl, true, peptideVariantsPreferences, searchParameters);
        } else {
            try {
                peptideMapper = new ProteinTree(1000, 1000);
                CommandLineExceptionHandler exceptionHandler = new CommandLineExceptionHandler();
                ((ProteinTree)peptideMapper).initiateTree(3, 50, 50, waitingHandlerCLIImpl, exceptionHandler, true, false, 1);
            }
            catch (Exception e) {
                System.err.println("Error: could not set up index");
                System.exit(-1);
            }
        }
        double diffTimeIndex = System.nanoTime() - startTimeIndex;
        System.err.println();
        if (peptideMapperType == PeptideMapperType.fm_index) {
            System.err.println("Indexing took " + diffTimeIndex / 1.0E9 + " seconds and consumes " + (double)((FMIndex)peptideMapper).getAllocatedBytes() / 1000000.0 + " MB");
        } else {
            System.err.println("Indexing took " + diffTimeIndex / 1.0E9 + " seconds");
        }
        if (args[0].equals("-p")) {
            String peptide;
            ArrayList<String> peptides = new ArrayList<String>();
            try {
                String line = "";
                BufferedReader br = new BufferedReader(new FileReader(args[2]));
                while ((line = br.readLine()) != null) {
                    if (!Pattern.matches("[a-zA-Z]+", line)) {
                        System.err.println("Error: invalid character in line '" + line + "'");
                        System.exit(-1);
                    }
                    peptides.add(line.toUpperCase());
                }
                br.close();
            }
            catch (Exception e) {
                System.err.println("Error: cound not open input list");
                System.exit(-1);
            }
            waitingHandlerCLIImpl.setSecondaryProgressCounterIndeterminate(false);
            waitingHandlerCLIImpl.setMaxSecondaryProgressCounter(peptides.size());
            waitingHandlerCLIImpl.setSecondaryProgressCounter(0);
            ArrayList<PeptideProteinMapping> allPeptideProteinMappings = new ArrayList<PeptideProteinMapping>();
            try {
                long startTimeMapping = System.nanoTime();
                for (int i = 0; i < peptides.size(); ++i) {
                    peptide = (String)peptides.get(i);
                    waitingHandlerCLIImpl.increaseSecondaryProgressCounter();
                    ArrayList<PeptideProteinMapping> peptideProteinMappings = peptideMapper.getProteinMapping(peptide, sequenceMatchingPreferences);
                    allPeptideProteinMappings.addAll(peptideProteinMappings);
                }
                long diffTimeMapping = System.nanoTime() - startTimeMapping;
                System.err.println();
                System.err.println("Mapping " + peptides.size() + " peptides took " + (double)diffTimeMapping / 1.0E9 + " seconds");
            }
            catch (Exception e) {
                System.err.println("Error: mapping went wrong for unknown reasons");
                System.exit(-1);
            }
            try {
                PrintWriter writer = new PrintWriter(args[3], "UTF-8");
                for (PeptideProteinMapping peptideProteinMapping : allPeptideProteinMappings) {
                    peptide = peptideProteinMapping.getPeptideSequence();
                    String accession = peptideProteinMapping.getProteinAccession();
                    int startIndex = peptideProteinMapping.getIndex();
                    writer.println(peptide + "," + accession + "," + startIndex);
                }
                writer.close();
            }
            catch (Exception e) {
                System.err.println("Error: could not write into file '" + args[3] + "'");
                System.exit(-1);
            }
        } else {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            ArrayList<Integer> tagIndexes = new ArrayList<Integer>();
            try {
                String line = "";
                BufferedReader br = new BufferedReader(new FileReader(args[2]));
                while ((line = br.readLine()) != null) {
                    Tag tag = new Tag();
                    for (String part : line.split(",")) {
                        if (Pattern.matches("[a-zA-Z]+", part)) {
                            tag.addAminoAcidSequence(new AminoAcidSequence(part));
                            continue;
                        }
                        try {
                            double mass = Double.parseDouble(part);
                            tag.addMassGap(mass);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Error: line contains no valid tag: '" + line + "'");
                            System.exit(-1);
                        }
                    }
                    tags.add(tag);
                }
            }
            catch (Exception e) {
                System.err.println("Error: cound not open input list");
                System.exit(-1);
            }
            waitingHandlerCLIImpl.setSecondaryProgressCounterIndeterminate(false);
            waitingHandlerCLIImpl.setMaxSecondaryProgressCounter(tags.size());
            waitingHandlerCLIImpl.setSecondaryProgressCounter(0);
            ArrayList<PeptideProteinMapping> allPeptideProteinMappings = new ArrayList<PeptideProteinMapping>();
            try {
                ArrayList<String> variableModifications = searchParameters.getPtmSettings().getVariableModifications();
                ArrayList<String> fixedModifications = searchParameters.getPtmSettings().getFixedModifications();
                TagMatcher tagMatcher = new TagMatcher(fixedModifications, variableModifications, sequenceMatchingPreferences);
                long startTimeMapping = System.nanoTime();
                for (int i = 0; i < tags.size(); ++i) {
                    waitingHandlerCLIImpl.increaseSecondaryProgressCounter();
                    ArrayList<PeptideProteinMapping> peptideProteinMappings = peptideMapper.getProteinMapping((Tag)tags.get(i), tagMatcher, sequenceMatchingPreferences, searchParameters.getFragmentIonAccuracyInDaltons());
                    allPeptideProteinMappings.addAll(peptideProteinMappings);
                    for (int j = 0; j < peptideProteinMappings.size(); ++j) {
                        tagIndexes.add(i);
                    }
                }
                long diffTimeMapping = System.nanoTime() - startTimeMapping;
                System.err.println();
                System.err.println("Mapping " + tags.size() + " tags took " + (double)diffTimeMapping / 1.0E9 + " seconds");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Error: an unexpected error happened.");
                System.exit(-1);
            }
            try {
                PrintWriter writer = new PrintWriter(args[3], "UTF-8");
                for (int i = 0; i < allPeptideProteinMappings.size(); ++i) {
                    PeptideProteinMapping peptideProteinMapping = (PeptideProteinMapping)allPeptideProteinMappings.get(i);
                    String peptide = peptideProteinMapping.getPeptideSequence();
                    String accession = peptideProteinMapping.getProteinAccession();
                    int startIndex = peptideProteinMapping.getIndex();
                    for (TagComponent tagComponent : ((Tag)tags.get((Integer)tagIndexes.get(i))).getContent()) {
                        if (tagComponent instanceof MassGap) {
                            writer.print(tagComponent.getMass());
                        }
                        if (tagComponent instanceof AminoAcidSequence) {
                            writer.print(tagComponent.asSequence());
                        }
                        writer.print(",");
                    }
                    writer.println(peptide + "," + accession + "," + startIndex);
                }
                writer.close();
            }
            catch (Exception e) {
                System.err.println("Error: could not write into file '" + args[3] + "'");
                System.exit(-1);
            }
        }
        if (peptideMapperType == PeptideMapperType.tree) {
            try {
                ((ProteinTree)peptideMapper).close();
            }
            catch (Exception e) {
                System.err.println("Error: could not close index");
                System.exit(-1);
            }
        }
    }
}

