/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences.digestion.iterators;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.protein_sequences.AmbiguousSequenceIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.PeptideWithPosition;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ProteinIteratorUtils;
import com.compomics.util.experiment.identification.protein_sequences.digestion.SequenceIterator;

public class NoDigestionCombinationIterator
implements SequenceIterator {
    private ProteinIteratorUtils proteinIteratorUtils;
    private String proteinSequence;
    private char[] proteinSequenceAsCharArray;
    private Double massMin;
    private Double massMax;
    private int index1 = 0;
    private int index2 = 1;
    AmbiguousSequenceIterator ambiguousSequenceIterator = null;

    public NoDigestionCombinationIterator(ProteinIteratorUtils proteinIteratorUtils, String proteinSequence, Double massMin, Double massMax) {
        this.proteinIteratorUtils = proteinIteratorUtils;
        this.proteinSequence = proteinSequence;
        this.massMin = massMin;
        this.massMax = massMax;
        this.ambiguousSequenceIterator = this.getSequenceIterator();
    }

    private AmbiguousSequenceIterator getSequenceIterator() {
        int nCombinations = 0;
        int nX = 0;
        double minPossibleMass = 0.0;
        double maxPossibleMass = 0.0;
        char[] sequenceAsCharArray = this.proteinSequence.toCharArray();
        for (int i = 0; i < sequenceAsCharArray.length; ++i) {
            char aa = sequenceAsCharArray[i];
            if (aa == 'X' && ++nX > this.proteinIteratorUtils.getMaxXsInSequence()) {
                return new AmbiguousSequenceIterator("", 0);
            }
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            if (aminoAcid.iscombination()) {
                double tempMass;
                ++nCombinations;
                char[] possibleAas = aminoAcid.getSubAminoAcids(false);
                char subAa = possibleAas[0];
                AminoAcid subAminoAcid = AminoAcid.getAminoAcid(subAa);
                double tempMassMin = tempMass = subAminoAcid.getMonoisotopicMass();
                double tempMassMax = tempMass;
                for (int j = 1; j < possibleAas.length; ++j) {
                    subAa = possibleAas[j];
                    subAminoAcid = AminoAcid.getAminoAcid(subAa);
                    tempMass = subAminoAcid.getMonoisotopicMass();
                    if (tempMass < tempMassMin) {
                        tempMassMin = tempMass;
                        continue;
                    }
                    if (!(tempMass > tempMassMax)) continue;
                    tempMassMax = tempMass;
                }
                minPossibleMass += tempMassMin;
                maxPossibleMass += tempMassMax;
                continue;
            }
            double tempMass = aminoAcid.getMonoisotopicMass();
            minPossibleMass += tempMass;
            maxPossibleMass += tempMass;
        }
        if (this.massMin != null && maxPossibleMass < this.massMin || this.massMax != null && minPossibleMass > this.massMax) {
            return new AmbiguousSequenceIterator("", 0);
        }
        return new AmbiguousSequenceIterator(this.proteinSequence, nCombinations);
    }

    @Override
    public PeptideWithPosition getNextPeptide() throws InterruptedException {
        char[] sequence = this.ambiguousSequenceIterator.getNextSequence();
        if (sequence == null) {
            return null;
        }
        Peptide peptide = this.proteinIteratorUtils.getPeptideFromProtein(sequence, 0, this.massMin, this.massMax);
        if (peptide != null && (this.massMin == null || peptide.getMass() >= this.massMin) && (this.massMax == null || peptide.getMass() <= this.massMax)) {
            return new PeptideWithPosition(peptide, 0);
        }
        return this.getNextPeptide();
    }
}

