/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.ptm.ptmscores;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.IonFactory;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.maps.KeyUtils;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.math.statistics.distributions.BinomialDistribution;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.math.MathException;
import org.apache.commons.math.util.FastMath;

public class PhosphoRS {
    public static final double WINDOW_SIZE = 100.0;
    public static final int MAX_DEPTH = 8;
    public static final int MIN_DEPTH = 2;
    private static int distributionCacheSize = 1000;
    private static HashMap<Double, HashMap<Integer, BinomialDistribution>> distributionCache = new HashMap();

    public static HashMap<Integer, Double> getSequenceProbabilities(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, AnnotationSettings annotationSettings, SpecificAnnotationSettings specificAnnotationSettings, boolean accountNeutralLosses, SequenceMatchingPreferences sequenceMatchingPreferences, SequenceMatchingPreferences ptmSequenceMatchingPreferences, PeptideSpectrumAnnotator spectrumAnnotator) throws IOException, InterruptedException, ClassNotFoundException, SQLException, MathException {
        if (ptms.isEmpty()) {
            throw new IllegalArgumentException("No PTM given for PhosphoRS calculation.");
        }
        if (spectrumAnnotator == null) {
            spectrumAnnotator = new PeptideSpectrumAnnotator();
        }
        int nPTM = 0;
        if (peptide.isModified()) {
            for (ModificationMatch modMatch : peptide.getModificationMatches()) {
                if (!modMatch.isVariable()) continue;
                for (PTM ptm : ptms) {
                    if (!ptm.getName().equals(modMatch.getTheoreticPtm())) continue;
                    ++nPTM;
                }
            }
        }
        if (nPTM == 0) {
            throw new IllegalArgumentException("Given PTMs not found in the peptide for PhosphoRS calculation.");
        }
        double ptmMass = ptms.get(0).getMass();
        NeutralLossesMap annotationNeutralLosses = specificAnnotationSettings.getNeutralLossesMap();
        NeutralLossesMap scoringLossesMap = new NeutralLossesMap();
        if (accountNeutralLosses) {
            for (String neutralLossName : annotationNeutralLosses.getAccountedNeutralLosses()) {
                NeutralLoss neutralLoss = NeutralLoss.getNeutralLoss(neutralLossName);
                if (!(Math.abs(neutralLoss.getMass() - ptmMass) > specificAnnotationSettings.getFragmentIonAccuracyInDa(spectrum.getMaxMz()))) continue;
                scoringLossesMap.addNeutralLoss(neutralLoss, (Integer)1, (Integer)1);
            }
        }
        SpecificAnnotationSettings scoringAnnotationSetttings = specificAnnotationSettings.clone();
        scoringAnnotationSetttings.setNeutralLossesMap(scoringLossesMap);
        HashMap<Ion.IonType, HashSet<Integer>> ions = specificAnnotationSettings.getIonTypes();
        HashMap<Ion.IonType, HashSet<Integer>> newIons = new HashMap<Ion.IonType, HashSet<Integer>>(1);
        for (Ion.IonType ionType : ions.keySet()) {
            if (ionType != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
            newIons.put(ionType, ions.get((Object)ionType));
        }
        scoringAnnotationSetttings.setSelectedIonsMap(newIons);
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        int peptideLength = peptide.getSequence().length();
        for (PTM ptm : ptms) {
            if (ptm.isNTerm()) {
                if (!peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences).contains(1)) continue;
                possibleSites.add(0);
                continue;
            }
            if (ptm.isCTerm()) {
                if (!peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences).contains(peptideLength)) continue;
                possibleSites.add(peptideLength + 1);
                continue;
            }
            for (int potentialSite : peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences)) {
                if (possibleSites.contains(potentialSite)) continue;
                possibleSites.add(potentialSite);
            }
        }
        Collections.sort(possibleSites);
        HashMap<String, Double> profileToScoreMap = new HashMap<String, Double>(possibleSites.size());
        HashMap<String, ArrayList<Integer>> profileToSitesMap = new HashMap<String, ArrayList<Integer>>(possibleSites.size());
        if (possibleSites.size() > nPTM) {
            spectrum = PhosphoRS.filterSpectrum(spectrum, scoringAnnotationSetttings);
            Peptide noModPeptide = Peptide.getNoModPeptide(peptide, ptms);
            ArrayList<ArrayList<Integer>> possibleProfiles = PhosphoRS.getPossibleModificationProfiles(possibleSites, nPTM);
            ArrayList<String> possibleProfileKeys = new ArrayList<String>(possibleProfiles.size());
            for (ArrayList<Integer> profile : possibleProfiles) {
                String profileKey = KeyUtils.getKey(profile);
                possibleProfileKeys.add(profileKey);
                profileToSitesMap.put(profileKey, profile);
            }
            HashMap<String, Peptide> profileToPeptide = PhosphoRS.getPossiblePeptidesMap(peptide, ptms, possibleProfiles);
            HashMap<String, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>> profileToPossibleFragments = PhosphoRS.getPossiblePeptideFragments(profileToPeptide, scoringAnnotationSetttings);
            HashMap<String, Integer> profileToN = PhosphoRS.getPossiblePeptideToN(profileToPeptide, profileToPossibleFragments, spectrumAnnotator, scoringAnnotationSetttings);
            HashMap<Double, ArrayList<String>> siteDeterminingIonsMap = PhosphoRS.getSiteDeterminingIons(noModPeptide, possibleProfiles, ptms, spectrumAnnotator, scoringAnnotationSetttings);
            ArrayList<Double> siteDeterminingIons = new ArrayList<Double>(siteDeterminingIonsMap.keySet());
            double minMz = spectrum.getMinMz();
            double maxMz = spectrum.getMaxMz();
            HashMap<Double, Peak> reducedSpectrum = new HashMap<Double, Peak>();
            double d = specificAnnotationSettings.getFragmentIonAccuracy();
            double dOverW = d / 100.0;
            dOverW = -FastMath.log10((double)dOverW);
            int nDecimals = (int)dOverW + 1;
            double halfWindow = 50.0;
            while (minMz < maxMz) {
                HashMap<Double, Peak> extractedPeakList;
                double tempMax = minMz + 100.0;
                if (specificAnnotationSettings.isFragmentIonPpm()) {
                    Double refMz = minMz + halfWindow;
                    d = specificAnnotationSettings.getFragmentIonAccuracyInDa(refMz);
                    dOverW = d / 100.0;
                    dOverW = -FastMath.log10((double)dOverW);
                    nDecimals = (int)dOverW + 1;
                }
                if (!(extractedPeakList = spectrum.getSubSpectrum(minMz, tempMax)).isEmpty()) {
                    double currentP;
                    MSnSpectrum tempSpectrum = new MSnSpectrum(spectrum.getLevel(), spectrum.getPrecursor(), spectrum.getSpectrumTitle() + "_PhosphoRS_minMZ_" + minMz, extractedPeakList, spectrum.getFileName());
                    ArrayList<MSnSpectrum> spectra = PhosphoRS.getReducedSpectra(tempSpectrum);
                    HashMap<String, HashSet<Double>> profileToSiteDeterminingIonsMz = new HashMap<String, HashSet<Double>>(siteDeterminingIons.size());
                    for (double ionMz : siteDeterminingIons) {
                        if (!(ionMz > minMz) || !(ionMz <= tempMax)) continue;
                        ArrayList<String> profiles = siteDeterminingIonsMap.get(ionMz);
                        for (String profileKey : profiles) {
                            HashSet<Double> mzs = (HashSet<Double>)profileToSiteDeterminingIonsMz.get(profileKey);
                            if (mzs == null) {
                                mzs = new HashSet<Double>(1);
                                profileToSiteDeterminingIonsMz.put(profileKey, mzs);
                            }
                            mzs.add(ionMz);
                        }
                    }
                    if (!profileToSiteDeterminingIonsMz.isEmpty()) {
                        ArrayList deltas = new ArrayList(spectra.size());
                        int nDeltas = 0;
                        for (MSnSpectrum currentSpectrum : spectra) {
                            ArrayList<Double> bigPs = new ArrayList<Double>(possibleProfileKeys.size());
                            ArrayList<Double> currentDeltas = new ArrayList<Double>(possibleProfileKeys.size());
                            ArrayList<HashSet> scored = new ArrayList<HashSet>(possibleProfileKeys.size());
                            boolean profileWithNoSiteDeterminingIonsScored = false;
                            currentP = PhosphoRS.getp(currentSpectrum, 100.0, d, nDecimals);
                            for (String profileKey : possibleProfileKeys) {
                                Integer n;
                                HashSet tempSiteDeterminingIons = (HashSet)profileToSiteDeterminingIonsMz.get(profileKey);
                                if (tempSiteDeterminingIons == null) {
                                    if (profileWithNoSiteDeterminingIonsScored) continue;
                                    profileWithNoSiteDeterminingIonsScored = true;
                                    Peptide tempPeptide = profileToPeptide.get(profileKey);
                                    HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possibleFragmentIons = profileToPossibleFragments.get(profileKey);
                                    n = profileToN.get(profileKey);
                                    Double bigP = PhosphoRS.getPhosphoRsScoreP(tempPeptide, possibleFragmentIons, currentSpectrum, currentP, n, spectrumAnnotator, annotationSettings, scoringAnnotationSetttings);
                                    BasicMathFunctions.checkProbabilityRange(bigP);
                                    bigPs.add(bigP);
                                    continue;
                                }
                                boolean alreadyScored = false;
                                for (HashSet scoredIons : scored) {
                                    if (!Util.sameSets(tempSiteDeterminingIons, scoredIons)) continue;
                                    alreadyScored = true;
                                    break;
                                }
                                if (alreadyScored) continue;
                                Peptide tempPeptide = profileToPeptide.get(profileKey);
                                n = profileToN.get(profileKey);
                                HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possibleFragmentIons = profileToPossibleFragments.get(profileKey);
                                Double bigP = PhosphoRS.getPhosphoRsScoreP(tempPeptide, possibleFragmentIons, currentSpectrum, currentP, n, spectrumAnnotator, annotationSettings, scoringAnnotationSetttings);
                                BasicMathFunctions.checkProbabilityRange(bigP);
                                bigPs.add(bigP);
                                scored.add(tempSiteDeterminingIons);
                            }
                            Collections.sort(bigPs);
                            for (int j = 0; j < bigPs.size() - 1; ++j) {
                                Double pJ = (Double)bigPs.get(j);
                                Double pJPlusOne = (Double)bigPs.get(j + 1);
                                Double delta = pJ / pJPlusOne;
                                currentDeltas.add(delta);
                            }
                            if (currentDeltas.size() > nDeltas) {
                                nDeltas = currentDeltas.size();
                            }
                            deltas.add(currentDeltas);
                        }
                        int bestI = 0;
                        Double largestDelta = 0.0;
                        for (int j = 0; j < nDeltas && largestDelta == 0.0; ++j) {
                            for (int i = 0; i < deltas.size(); ++i) {
                                ArrayList tempDeltas = (ArrayList)deltas.get(i);
                                if (j >= tempDeltas.size() || !((Double)tempDeltas.get(j) > largestDelta)) continue;
                                largestDelta = (Double)tempDeltas.get(j);
                                bestI = i;
                            }
                        }
                        if (bestI < 1 && 1 < spectra.size()) {
                            bestI = 1;
                        }
                        if (bestI > 7) {
                            bestI = 7;
                        }
                        reducedSpectrum.putAll(spectra.get(bestI).getPeakMap());
                    } else {
                        Double bestP = 0.0;
                        int bestI = 0;
                        HashMap<Integer, ArrayList<Ion>> expectedFragmentIons = spectrumAnnotator.getExpectedIons(scoringAnnotationSetttings, peptide);
                        int nExpectedFragmentIons = 0;
                        for (ArrayList<Ion> expectedIons : expectedFragmentIons.values()) {
                            nExpectedFragmentIons += expectedIons.size();
                        }
                        IonFactory fragmentFactory = IonFactory.getInstance();
                        HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possibleFragmentIons = fragmentFactory.getFragmentIons(peptide, scoringAnnotationSetttings);
                        for (int i = 0; i < spectra.size(); ++i) {
                            MSnSpectrum currentSpectrum = spectra.get(i);
                            currentP = PhosphoRS.getp(currentSpectrum, 100.0, d, nDecimals);
                            Double bigP = PhosphoRS.getPhosphoRsScoreP(peptide, possibleFragmentIons, currentSpectrum, currentP, nExpectedFragmentIons, spectrumAnnotator, annotationSettings, scoringAnnotationSetttings);
                            BasicMathFunctions.checkProbabilityRange(bigP);
                            if (!(bigP < bestP)) continue;
                            bestP = bigP;
                            bestI = i;
                        }
                        reducedSpectrum.putAll(spectra.get(bestI).getPeakMap());
                    }
                }
                minMz = tempMax;
            }
            MSnSpectrum phosphoRsSpectrum = new MSnSpectrum(spectrum.getLevel(), spectrum.getPrecursor(), spectrum.getSpectrumTitle() + "_phosphoRS", reducedSpectrum, spectrum.getFileName());
            double w = spectrum.getMaxMz() - spectrum.getMinMz();
            if (specificAnnotationSettings.isFragmentIonPpm()) {
                Double refMz = spectrum.getMinMz() + w / 2.0;
                d = specificAnnotationSettings.getFragmentIonAccuracyInDa(refMz);
            }
            dOverW = d / w;
            dOverW = -FastMath.log10((double)dOverW);
            nDecimals = (int)dOverW + 1;
            double currentP = PhosphoRS.getp(phosphoRsSpectrum, w, d, nDecimals);
            HashMap<String, Double> pInvMap = new HashMap<String, Double>(possibleProfileKeys.size());
            Double pInvTotal = 0.0;
            for (String profileKey : possibleProfileKeys) {
                Peptide tempPeptide = profileToPeptide.get(profileKey);
                Integer n = profileToN.get(profileKey);
                HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possibleFragmentIons = profileToPossibleFragments.get(profileKey);
                Double bigP = PhosphoRS.getPhosphoRsScoreP(tempPeptide, possibleFragmentIons, phosphoRsSpectrum, currentP, n, spectrumAnnotator, annotationSettings, scoringAnnotationSetttings);
                BasicMathFunctions.checkProbabilityRange(bigP);
                Double pInv = 1.0 / bigP;
                pInvMap.put(profileKey, pInv);
                pInvTotal = pInvTotal + pInv;
            }
            if (pInvTotal <= 0.0) {
                throw new IllegalArgumentException("PhosphoRS probability <= 0.");
            }
            for (String profileKey : possibleProfileKeys) {
                Double phosphoRsProbability = (Double)pInvMap.get(profileKey) / pInvTotal;
                BasicMathFunctions.checkProbabilityRange(phosphoRsProbability);
                phosphoRsProbability = phosphoRsProbability * 100.0;
                profileToScoreMap.put(profileKey, phosphoRsProbability);
            }
        } else if (possibleSites.size() == nPTM) {
            String profileKey = KeyUtils.getKey(possibleSites);
            profileToScoreMap.put(profileKey, 100.0);
            profileToSitesMap.put(profileKey, possibleSites);
        } else {
            throw new IllegalArgumentException("Found less potential modification sites than PTMs during PhosphoRS calculation. Peptide key: " + peptide.getKey());
        }
        HashMap<Integer, Double> scores = new HashMap<Integer, Double>();
        for (String profile : profileToScoreMap.keySet()) {
            Double score = (Double)profileToScoreMap.get(profile);
            ArrayList sites = (ArrayList)profileToSitesMap.get(profile);
            for (Integer site : sites) {
                Double previousScore = scores.get(site);
                if (previousScore == null) {
                    scores.put(site, score);
                    continue;
                }
                Double newScore = score + previousScore;
                scores.put(site, newScore);
            }
        }
        Iterator<Object> iterator = possibleSites.iterator();
        while (iterator.hasNext()) {
            int site = (Integer)iterator.next();
            if (scores.keySet().contains(site)) continue;
            throw new IllegalArgumentException("Site " + site + " not scored for modification " + ptmMass + " in spectrum " + spectrum.getSpectrumTitle() + " of file " + spectrum.getFileName() + ".");
        }
        return scores;
    }

    private static Double getPhosphoRsScoreP(Peptide peptide, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possiblePeptideFragments, MSnSpectrum spectrum, double p, int n, PeptideSpectrumAnnotator spectrumAnnotator, AnnotationSettings annotationSettings, SpecificAnnotationSettings scoringAnnotationSettings) throws MathException, InterruptedException {
        BinomialDistribution distribution = null;
        HashMap<Integer, BinomialDistribution> distributionsAtP = distributionCache.get(p);
        boolean inCache = true;
        if (distributionsAtP != null) {
            distribution = distributionsAtP.get(n);
        }
        if (distribution == null) {
            distribution = new BinomialDistribution(n, p);
            inCache = false;
        }
        ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(annotationSettings, scoringAnnotationSettings, spectrum, peptide, possiblePeptideFragments, false);
        int k = 0;
        for (IonMatch ionMatch : matches) {
            if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
            ++k;
        }
        if (k == 0) {
            return 1.0;
        }
        Double result = distribution.getDescendingCumulativeProbabilityAt(k);
        if (!inCache && !distribution.isCacheEmpty()) {
            PhosphoRS.addDistributionToCache(p, n, distribution);
        }
        return result;
    }

    private static synchronized void addDistributionToCache(double p, int n, BinomialDistribution binomialDistribution) {
        HashMap<Integer, BinomialDistribution> distributionsAtP;
        if (distributionCache.size() >= distributionCacheSize) {
            HashSet<Double> keys = new HashSet<Double>(distributionCache.keySet());
            for (Double key : keys) {
                distributionCache.remove(key);
                if (distributionCache.size() >= distributionCacheSize) continue;
                break;
            }
        }
        if ((distributionsAtP = distributionCache.get(p)) == null) {
            distributionsAtP = new HashMap(2);
            distributionCache.put(p, distributionsAtP);
        }
        distributionsAtP.put(n, binomialDistribution);
    }

    private static double getp(Spectrum spectrum, double w, double d, int nDecimals) {
        if (w == 0.0) {
            return 1.0;
        }
        int N = spectrum.getPeakMap().size();
        if (N <= 1) {
            return 1.0;
        }
        double p = d * (double)N / w;
        if (p > 1.0) {
            p = 1.0;
        }
        double roundedP = Util.floorDouble(p, nDecimals);
        return roundedP;
    }

    private static HashMap<String, Peptide> getPossiblePeptidesMap(Peptide peptide, ArrayList<PTM> ptms, ArrayList<ArrayList<Integer>> possibleProfiles) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        String representativePTM = ptms.get(0).getName();
        HashMap<String, Peptide> result = new HashMap<String, Peptide>(possibleProfiles.size());
        int peptideLength = peptide.getSequence().length();
        for (ArrayList<Integer> profile : possibleProfiles) {
            Peptide tempPeptide = Peptide.getNoModPeptide(peptide, ptms);
            for (int pos : profile) {
                int index = pos;
                if (index == 0) {
                    index = 1;
                } else if (index == peptideLength + 1) {
                    index = peptideLength;
                }
                tempPeptide.addModificationMatch(new ModificationMatch(representativePTM, true, index));
            }
            String profileKey = KeyUtils.getKey(profile);
            result.put(profileKey, tempPeptide);
        }
        return result;
    }

    private static HashMap<String, Integer> getPossiblePeptideToN(HashMap<String, Peptide> possiblePeptides, HashMap<String, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>> possiblePeptideFragments, PeptideSpectrumAnnotator spectrumAnnotator, SpecificAnnotationSettings scoringAnnotationSetttings) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(possiblePeptides.size());
        for (String profileKey : possiblePeptides.keySet()) {
            Peptide peptide = possiblePeptides.get(profileKey);
            HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> fragmentsForProfile = possiblePeptideFragments.get(profileKey);
            HashMap<Integer, ArrayList<Ion>> expectedFragmentIons = spectrumAnnotator.getExpectedIons(scoringAnnotationSetttings, peptide, fragmentsForProfile);
            int n = 0;
            for (ArrayList<Ion> ions : expectedFragmentIons.values()) {
                n += ions.size();
            }
            result.put(profileKey, n);
        }
        return result;
    }

    private static HashMap<String, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>> getPossiblePeptideFragments(HashMap<String, Peptide> possiblePeptides, SpecificAnnotationSettings scoringAnnotationSetttings) {
        HashMap<String, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>> result = new HashMap<String, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>>(possiblePeptides.size());
        IonFactory fragmentFactory = IonFactory.getInstance();
        for (String profileKey : possiblePeptides.keySet()) {
            Peptide peptide = possiblePeptides.get(profileKey);
            HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possibleFragmentIons = fragmentFactory.getFragmentIons(peptide, scoringAnnotationSetttings);
            result.put(profileKey, possibleFragmentIons);
        }
        return result;
    }

    private static ArrayList<ArrayList<Integer>> getPossibleModificationProfiles(ArrayList<Integer> possibleSites, int nPtms) {
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        for (int pos : possibleSites) {
            ArrayList<Integer> profile = new ArrayList<Integer>(nPtms);
            profile.add(pos);
            result.add(profile);
        }
        for (int i = 2; i <= nPtms; ++i) {
            ArrayList<ArrayList<Integer>> resultAtI = new ArrayList<ArrayList<Integer>>((int)(1.5 * (double)result.size()));
            for (ArrayList<Integer> previousProfile : result) {
                int lastPos = previousProfile.get(previousProfile.size() - 1);
                for (int pos : possibleSites) {
                    if (pos <= lastPos) continue;
                    ArrayList<Integer> profile = new ArrayList<Integer>(previousProfile);
                    profile.add(pos);
                    resultAtI.add(profile);
                }
            }
            result = resultAtI;
        }
        return result;
    }

    private static HashMap<Double, ArrayList<String>> getSiteDeterminingIons(Peptide noModPeptide, ArrayList<ArrayList<Integer>> possibleProfiles, ArrayList<PTM> ptms, PeptideSpectrumAnnotator spectrumAnnotator, SpecificAnnotationSettings scoringAnnotationSetttings) {
        String sequence = noModPeptide.getSequence();
        Peptide peptide = new Peptide(sequence, noModPeptide.getModificationMatches());
        int sequenceLength = sequence.length();
        String representativePTM = ptms.get(0).getName();
        HashMap<Double, ArrayList<String>> siteDeterminingIons = new HashMap<Double, ArrayList<String>>();
        HashMap commonIons = new HashMap();
        for (ArrayList<Integer> modificationProfile : possibleProfiles) {
            for (int pos : modificationProfile) {
                int position = pos == 0 ? 1 : (pos == sequenceLength + 1 ? sequenceLength : pos);
                peptide.addModificationMatch(new ModificationMatch(representativePTM, true, position));
            }
            HashSet<Double> mzs = new HashSet<Double>(2);
            for (ArrayList<Ion> ions : spectrumAnnotator.getExpectedIons(scoringAnnotationSetttings, peptide).values()) {
                for (Ion ion : ions) {
                    if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                    for (int charge : scoringAnnotationSetttings.getSelectedCharges()) {
                        double mz = ion.getTheoreticMz(charge);
                        mzs.add(mz);
                    }
                }
            }
            String profileKey = KeyUtils.getKey(modificationProfile);
            Iterator<Object> iterator = mzs.iterator();
            while (iterator.hasNext()) {
                ArrayList<Object> profiles;
                double mz = (Double)iterator.next();
                if (commonIons.isEmpty()) {
                    profiles = new ArrayList(2);
                    commonIons.put(mz, profiles);
                    profiles.add(profileKey);
                    continue;
                }
                if (commonIons.containsKey(mz)) continue;
                profiles = siteDeterminingIons.get(mz);
                if (profiles == null) {
                    profiles = new ArrayList(2);
                    siteDeterminingIons.put(mz, profiles);
                }
                profiles.add(profileKey);
            }
            iterator = new HashSet(commonIons.keySet()).iterator();
            while (iterator.hasNext()) {
                double mz = (Double)iterator.next();
                if (!mzs.contains(mz)) {
                    siteDeterminingIons.put(mz, (ArrayList<String>)commonIons.get(mz));
                    commonIons.remove(mz);
                    continue;
                }
                ((ArrayList)commonIons.get(mz)).add(profileKey);
            }
        }
        return siteDeterminingIons;
    }

    private static ArrayList<MSnSpectrum> getReducedSpectra(MSnSpectrum spectrum) {
        if (spectrum.isEmpty()) {
            throw new IllegalArgumentException("Attempting to extract peaks from an empty spectrum.");
        }
        ArrayList<MSnSpectrum> reducedSpectra = new ArrayList<MSnSpectrum>(8);
        HashMap<Double, ArrayList<Peak>> intensityToPeakMap = new HashMap<Double, ArrayList<Peak>>(spectrum.getPeakMap().size());
        for (Peak peak : spectrum.getPeakList()) {
            double intensity = peak.intensity;
            ArrayList<Peak> peaks = (ArrayList<Peak>)intensityToPeakMap.get(intensity);
            if (peaks == null) {
                peaks = new ArrayList<Peak>();
                intensityToPeakMap.put(intensity, peaks);
            }
            peaks.add(peak);
        }
        ArrayList intensities = new ArrayList(intensityToPeakMap.keySet());
        Collections.sort(intensities, Collections.reverseOrder());
        int depth = 0;
        HashMap<Double, Peak> mzToPeak = new HashMap<Double, Peak>(1);
        Iterator iterator = intensities.iterator();
        while (iterator.hasNext()) {
            double intensity = (Double)iterator.next();
            for (Peak peak : (ArrayList)intensityToPeakMap.get(intensity)) {
                mzToPeak.put(peak.mz, peak);
                reducedSpectra.add(new MSnSpectrum(spectrum.getLevel(), spectrum.getPrecursor(), spectrum.getSpectrumTitle() + "_" + ++depth, mzToPeak, spectrum.getFileName()));
                if (depth > 8) break;
                HashMap<Double, Peak> newMzToPeak = new HashMap<Double, Peak>(depth + 1);
                newMzToPeak.putAll(mzToPeak);
                mzToPeak = newMzToPeak;
            }
            if (depth <= 8) continue;
            break;
        }
        return reducedSpectra;
    }

    private static MSnSpectrum filterSpectrum(MSnSpectrum spectrum, SpecificAnnotationSettings scoringAnnotationSetttings) throws InterruptedException {
        Integer maxPeaks;
        Double window;
        double ms2Tolerance = scoringAnnotationSetttings.getFragmentIonAccuracyInDa(spectrum.getMaxMz());
        if (ms2Tolerance <= 10.0) {
            window = 10.0 * ms2Tolerance;
            maxPeaks = 10;
        } else {
            window = 100.0;
            maxPeaks = (int)(window / ms2Tolerance);
        }
        if (maxPeaks < 1) {
            throw new IllegalArgumentException("All peaks removed by filtering.");
        }
        HashMap<Double, Peak> peakMap = spectrum.getPeakMap();
        HashMap<Double, Peak> newMap = new HashMap<Double, Peak>(peakMap.size());
        HashMap<Double, Peak> tempMap = new HashMap<Double, Peak>();
        Double refMz = null;
        double[] dArray = spectrum.getOrderedMzValues();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double mz = dArray[i];
            if (refMz == null) {
                refMz = mz;
            } else if (mz > refMz + window) {
                if (tempMap.size() <= maxPeaks) {
                    newMap.putAll(tempMap);
                    tempMap.clear();
                } else {
                    ArrayList intensities = new ArrayList(tempMap.keySet());
                    Collections.sort(intensities, Collections.reverseOrder());
                    for (int i2 = 0; i2 < Math.min(intensities.size(), maxPeaks); ++i2) {
                        Double intensity = (Double)intensities.get(i2);
                        Peak peak = (Peak)tempMap.get(intensity);
                        newMap.put(peak.mz, peak);
                    }
                    tempMap.clear();
                }
                refMz = refMz + window;
            }
            Peak peak = peakMap.get(mz);
            tempMap.put(peak.intensity, peak);
        }
        ArrayList intensities = new ArrayList(tempMap.keySet());
        Collections.sort(intensities, Collections.reverseOrder());
        for (int i = 0; i < Math.min(intensities.size(), maxPeaks); ++i) {
            Double intensity = (Double)intensities.get(i);
            Peak peak = (Peak)tempMap.get(intensity);
            newMap.put(peak.mz, peak);
        }
        return new MSnSpectrum(spectrum.getLevel(), spectrum.getPrecursor(), spectrum.getSpectrumTitle() + "_filtered", newMap, spectrum.getFileName());
    }
}

