/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators;

import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.indexes.SpectrumIndex;
import java.util.ArrayList;

public class ReporterIonAnnotator {
    private double[] reporterIonsMz;
    private ReporterIon[] reporterIons;

    public ReporterIonAnnotator(ReporterIon[] reporterIons) {
        this.reporterIons = reporterIons;
        this.reporterIonsMz = new double[reporterIons.length];
        for (int i = 0; i < reporterIons.length; ++i) {
            this.reporterIonsMz[i] = reporterIons[i].getTheoreticMass() + ElementaryIon.proton.getTheoreticMass();
        }
    }

    public ArrayList<IonMatch> getIonMatches(SpectrumIndex spectrumIndex) {
        ArrayList<IonMatch> results = new ArrayList<IonMatch>(this.reporterIons.length);
        for (int i = 0; i < this.reporterIons.length; ++i) {
            ReporterIon reporterIon = this.reporterIons[i];
            double ionMz = this.reporterIonsMz[i];
            ArrayList<Peak> peaks = spectrumIndex.getMatchingPeaks(ionMz);
            for (Peak peak : peaks) {
                results.add(new IonMatch(peak, reporterIon, 1));
            }
        }
        return results;
    }
}

