/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.math.VennDiagram;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import no.uib.jsparklines.data.XYDataPoint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYBoxAnnotation;
import org.jfree.chart.annotations.XYShapeAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYAnnotationEntity;
import org.jfree.chart.labels.StandardXYZToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.TextAnchor;

public class VennDiagramPanel
extends JPanel {
    private HashMap<String, String> tooltipToDatasetMap;
    private VennDiagramType currentVennDiagramType = VennDiagramType.THREE_WAY;
    private HashMap<String, ArrayList<String>> vennDiagramResults;
    private HashMap<String, String> groupNames;
    private ChartPanel chartPanel;
    private int fontSizeValues = 17;
    private int fontSizeLegend = 14;
    private boolean showLegend = true;
    private XYDataPoint legendDatasetAThreeWay = new XYDataPoint(0.86, 0.86);
    private XYDataPoint legendDatasetBThreeWay = new XYDataPoint(1.15, 0.86);
    private XYDataPoint legendDatasetCThreeWay = new XYDataPoint(1.0, 1.22);
    private XYDataPoint legendDatasetAFourWay = new XYDataPoint(0.13, 0.53);
    private XYDataPoint legendDatasetBFourWay = new XYDataPoint(0.23, 0.43);
    private XYDataPoint legendDatasetCFourWay = new XYDataPoint(0.33, 0.33);
    private XYDataPoint legendDatasetDFourWay = new XYDataPoint(0.43, 0.23);
    private Color datasetAColor;
    private Color datasetBColor;
    private Color datasetCColor;
    private Color datasetDColor;
    private JPanel plotPanel;

    public VennDiagramPanel(ArrayList<String> a, ArrayList<String> b, ArrayList<String> c, ArrayList<String> d, String groupA, String groupB, String groupC, String groupD, Color datasetAColor, Color datasetBColor, Color datasetCColor, Color datasetDColor) {
        this.initComponents();
        this.vennDiagramResults = VennDiagram.vennDiagramMaker(a, b, c, d);
        this.currentVennDiagramType = b.isEmpty() && c.isEmpty() && d.isEmpty() ? VennDiagramType.ONE_WAY : (c.isEmpty() && d.isEmpty() ? VennDiagramType.TWO_WAY : (d.isEmpty() ? VennDiagramType.THREE_WAY : VennDiagramType.FOUR_WAY));
        this.groupNames = new HashMap();
        this.groupNames.put("a", groupA);
        this.groupNames.put("b", groupB);
        this.groupNames.put("c", groupC);
        this.groupNames.put("d", groupD);
        this.datasetAColor = datasetAColor;
        this.datasetBColor = datasetBColor;
        this.datasetCColor = datasetCColor;
        this.datasetDColor = datasetDColor;
        this.updatePlot();
    }

    private void initComponents() {
        this.plotPanel = new JPanel();
        this.setOpaque(false);
        this.plotPanel.setOpaque(false);
        this.plotPanel.setLayout(new BoxLayout(this.plotPanel, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.plotPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.plotPanel, -1, -1, Short.MAX_VALUE));
    }

    public void updatePlot() {
        this.plotPanel.removeAll();
        this.tooltipToDatasetMap = new HashMap();
        DefaultXYZDataset xyzDataset = new DefaultXYZDataset();
        JFreeChart chart = ChartFactory.createBubbleChart(null, (String)"X", (String)"Y", (XYZDataset)xyzDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        if (this.currentVennDiagramType == VennDiagramType.ONE_WAY) {
            plot.getRangeAxis().setRange(0.86, 1.24);
            plot.getDomainAxis().setRange(0.85, 1.25);
        } else if (this.currentVennDiagramType == VennDiagramType.TWO_WAY) {
            plot.getRangeAxis().setRange(0.86, 1.24);
            plot.getDomainAxis().setRange(0.85, 1.25);
        } else if (this.currentVennDiagramType == VennDiagramType.THREE_WAY) {
            plot.getRangeAxis().setRange(0.86, 1.24);
            plot.getDomainAxis().setRange(0.85, 1.25);
        } else {
            plot.getRangeAxis().setRange(-0.04, 0.6);
            plot.getDomainAxis().setRange(-0.08, 0.7);
        }
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        double radius = 0.1;
        Ellipse2D.Double ellipse = new Ellipse2D.Double(1.0 - radius, 1.0 - radius, radius + radius, radius + radius);
        XYShapeAnnotation xyShapeAnnotation = new XYShapeAnnotation((Shape)ellipse, (Stroke)new BasicStroke(2.0f), (Paint)new Color(140, 140, 140, 150), (Paint)this.datasetAColor);
        plot.addAnnotation((XYAnnotation)xyShapeAnnotation);
        if (this.currentVennDiagramType == VennDiagramType.TWO_WAY || this.currentVennDiagramType == VennDiagramType.THREE_WAY) {
            ellipse = new Ellipse2D.Double(1.0 - radius + 0.1, 1.0 - radius, radius + radius, radius + radius);
            xyShapeAnnotation = new XYShapeAnnotation((Shape)ellipse, (Stroke)new BasicStroke(2.0f), (Paint)new Color(140, 140, 140, 150), (Paint)this.datasetBColor);
            plot.addAnnotation((XYAnnotation)xyShapeAnnotation);
        }
        if (this.currentVennDiagramType == VennDiagramType.THREE_WAY) {
            ellipse = new Ellipse2D.Double(1.0 - radius + 0.05, 1.0 - radius + 0.1, radius + radius, radius + radius);
            xyShapeAnnotation = new XYShapeAnnotation((Shape)ellipse, (Stroke)new BasicStroke(2.0f), (Paint)new Color(140, 140, 140, 150), (Paint)this.datasetCColor);
            plot.addAnnotation((XYAnnotation)xyShapeAnnotation);
        }
        if (this.currentVennDiagramType == VennDiagramType.ONE_WAY) {
            XYTextAnnotation anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("a").size(), 1.0, 1.0);
            anotation.setToolTipText(this.groupNames.get("a"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "a");
            if (this.showLegend) {
                anotation = new XYTextAnnotation(this.groupNames.get("a"), this.legendDatasetAThreeWay.getX(), this.legendDatasetAThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
            }
        } else if (this.currentVennDiagramType == VennDiagramType.TWO_WAY) {
            XYTextAnnotation anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("a").size(), 0.96, 1.0);
            anotation.setToolTipText(this.groupNames.get("a"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "a");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("b").size(), 1.14, 1.0);
            anotation.setToolTipText(this.groupNames.get("b"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "b");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ab").size(), 1.05, 1.0);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ab");
            if (this.showLegend) {
                anotation = new XYTextAnnotation(this.groupNames.get("a"), this.legendDatasetAThreeWay.getX(), this.legendDatasetAThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("b"), this.legendDatasetBThreeWay.getX(), this.legendDatasetBThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
            }
        } else if (this.currentVennDiagramType == VennDiagramType.THREE_WAY) {
            XYTextAnnotation anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("a").size(), 0.96, 0.97);
            anotation.setToolTipText(this.groupNames.get("a"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "a");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("b").size(), 1.14, 0.97);
            anotation.setToolTipText(this.groupNames.get("b"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "b");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ab").size(), 1.05, 0.97);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ab");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("c").size(), 1.05, 1.14);
            anotation.setToolTipText(this.groupNames.get("c"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "c");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ac").size(), 0.99, 1.065);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + "  &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ac");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("bc").size(), 1.11, 1.065);
            anotation.setToolTipText("<html>" + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "bc");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("abc").size(), 1.05, 1.036);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + "  &#8745; " + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "abc");
            if (this.showLegend) {
                anotation = new XYTextAnnotation(this.groupNames.get("a"), this.legendDatasetAThreeWay.getX(), this.legendDatasetAThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("b"), this.legendDatasetBThreeWay.getX(), this.legendDatasetBThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("c"), this.legendDatasetCThreeWay.getX(), this.legendDatasetCThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
            }
        } else if (this.currentVennDiagramType == VennDiagramType.FOUR_WAY) {
            XYBoxAnnotation anotation2 = new XYBoxAnnotation(0.0, 0.0, 0.2, 0.5, (Stroke)new BasicStroke(2.0f), (Paint)Color.LIGHT_GRAY, (Paint)this.datasetAColor);
            plot.addAnnotation((XYAnnotation)anotation2);
            anotation2 = new XYBoxAnnotation(0.1, 0.0, 0.3, 0.4, (Stroke)new BasicStroke(2.0f), (Paint)Color.LIGHT_GRAY, (Paint)this.datasetBColor);
            plot.addAnnotation((XYAnnotation)anotation2);
            anotation2 = new XYBoxAnnotation(0.0, 0.1, 0.4, 0.3, (Stroke)new BasicStroke(2.0f), (Paint)Color.LIGHT_GRAY, (Paint)this.datasetCColor);
            plot.addAnnotation((XYAnnotation)anotation2);
            anotation2 = new XYBoxAnnotation(0.0, 0.0, 0.5, 0.2, (Stroke)new BasicStroke(2.0f), (Paint)Color.LIGHT_GRAY, (Paint)this.datasetDColor);
            plot.addAnnotation((XYAnnotation)anotation2);
            XYTextAnnotation anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("a").size(), 0.15, 0.45);
            anotation.setToolTipText(this.groupNames.get("a"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "a");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ab").size(), 0.15, 0.35);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ab");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("abc").size(), 0.15, 0.25);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "abc");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("abcd").size(), 0.15, 0.15);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "abcd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("abd").size(), 0.15, 0.05);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "abd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ac").size(), 0.05, 0.25);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ac");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("acd").size(), 0.05, 0.15);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("c") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "acd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ad").size(), 0.05, 0.05);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ad");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("b").size(), 0.25, 0.35);
            anotation.setToolTipText("<html>" + this.groupNames.get("b") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "b");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("bc").size(), 0.25, 0.25);
            anotation.setToolTipText("<html>" + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "bc");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("bcd").size(), 0.25, 0.15);
            anotation.setToolTipText("<html>" + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "bcd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("bd").size(), 0.25, 0.05);
            anotation.setToolTipText("<html>" + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "bd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("c").size(), 0.35, 0.25);
            anotation.setToolTipText("<html>" + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "c");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("cd").size(), 0.35, 0.15);
            anotation.setToolTipText("<html>" + this.groupNames.get("c") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "cd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("d").size(), 0.45, 0.15);
            anotation.setToolTipText("<html>" + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "d");
            if (this.showLegend) {
                anotation = new XYTextAnnotation(this.groupNames.get("a"), this.legendDatasetAFourWay.getX(), this.legendDatasetAFourWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("b"), this.legendDatasetBFourWay.getX(), this.legendDatasetBFourWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("c"), this.legendDatasetCFourWay.getX(), this.legendDatasetCFourWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("d"), this.legendDatasetDFourWay.getX(), this.legendDatasetDFourWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
            }
        }
        XYBubbleRenderer renderer = new XYBubbleRenderer(2);
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYZToolTipGenerator());
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setForegroundAlpha(0.5f);
        plot.getDomainAxis().setUpperMargin(0.0);
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        chart.getPlot().setOutlineVisible(false);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setPopupMenu(null);
        this.chartPanel.setBackground(Color.WHITE);
        this.plotPanel.add((Component)this.chartPanel);
        this.plotPanel.revalidate();
        this.plotPanel.repaint();
        this.chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent cme) {
                VennDiagramPanel.this.mouseClickedInChart(cme);
            }

            public void chartMouseMoved(ChartMouseEvent cme) {
                VennDiagramPanel.this.mouseMovedInChart(cme);
            }
        });
        this.chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mouseClicked(e);
            }
        });
    }

    private void mouseClickedInChart(ChartMouseEvent event) {
        ArrayList<ChartEntity> entities = this.getEntitiesForPoint(event.getTrigger().getPoint().x, event.getTrigger().getPoint().y);
        if (entities.isEmpty()) {
            return;
        }
        boolean dataPointFound = false;
        String dataPointTooltip = "";
        for (ChartEntity tempEntity : entities) {
            if (!(tempEntity instanceof XYAnnotationEntity) || ((XYAnnotationEntity)tempEntity).getToolTipText() == null) continue;
            dataPointFound = true;
            dataPointTooltip = ((XYAnnotationEntity)tempEntity).getToolTipText();
        }
        if (dataPointFound) {
            String dataset = this.tooltipToDatasetMap.get(dataPointTooltip);
            JOptionPane.showMessageDialog(this, dataPointTooltip + ":\n" + this.vennDiagramResults.get(dataset), "Selected Values", 1);
        }
    }

    private void mouseMovedInChart(ChartMouseEvent event) {
        ArrayList<ChartEntity> entities = this.getEntitiesForPoint(event.getTrigger().getPoint().x, event.getTrigger().getPoint().y);
        boolean dataPointFound = false;
        for (ChartEntity tempEntity : entities) {
            if (!(tempEntity instanceof XYAnnotationEntity) || ((XYAnnotationEntity)tempEntity).getToolTipText() == null) continue;
            dataPointFound = true;
        }
        if (dataPointFound) {
            this.chartPanel.setCursor(new Cursor(12));
        } else {
            this.chartPanel.setCursor(new Cursor(0));
        }
    }

    public ArrayList<ChartEntity> getEntitiesForPoint(int viewX, int viewY) {
        ArrayList<ChartEntity> entitiesForPoint = new ArrayList<ChartEntity>();
        ChartRenderingInfo info = this.chartPanel.getChartRenderingInfo();
        if (info != null) {
            Insets insets = this.chartPanel.getInsets();
            double x = (double)(viewX - insets.left) / this.chartPanel.getScaleX();
            double y = (double)(viewY - insets.top) / this.chartPanel.getScaleY();
            EntityCollection allEntities = info.getEntityCollection();
            int numEntities = allEntities.getEntityCount();
            for (int i = 0; i < numEntities; ++i) {
                ChartEntity entity = allEntities.getEntity(i);
                if (!entity.getArea().contains(x, y)) continue;
                entitiesForPoint.add(entity);
            }
        }
        return entitiesForPoint;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public HashMap<String, String> getGroupNames() {
        return this.groupNames;
    }

    public XYDataPoint getLegendDatasetAThreeWay() {
        return this.legendDatasetAThreeWay;
    }

    public void setLegendDatasetAThreeWay(XYDataPoint legendDatasetAThreeWay) {
        this.legendDatasetAThreeWay = legendDatasetAThreeWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetBThreeWay() {
        return this.legendDatasetBThreeWay;
    }

    public void setLegendDatasetBThreeWay(XYDataPoint legendDatasetBThreeWay) {
        this.legendDatasetBThreeWay = legendDatasetBThreeWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetCThreeWay() {
        return this.legendDatasetCThreeWay;
    }

    public void setLegendDatasetCThreeWay(XYDataPoint legendDatasetCThreeWay) {
        this.legendDatasetCThreeWay = legendDatasetCThreeWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetAFourWay() {
        return this.legendDatasetAFourWay;
    }

    public void setLegendDatasetAFourWay(XYDataPoint legendDatasetAFourWay) {
        this.legendDatasetAFourWay = legendDatasetAFourWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetBFourWay() {
        return this.legendDatasetBFourWay;
    }

    public void setLegendDatasetBFourWay(XYDataPoint legendDatasetBFourWay) {
        this.legendDatasetBFourWay = legendDatasetBFourWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetCFourWay() {
        return this.legendDatasetCFourWay;
    }

    public void setLegendDatasetCFourWay(XYDataPoint legendDatasetCFourWay) {
        this.legendDatasetCFourWay = legendDatasetCFourWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetDFourWay() {
        return this.legendDatasetDFourWay;
    }

    public void setLegendDatasetDFourWay(XYDataPoint legendDatasetDFourWay) {
        this.legendDatasetDFourWay = legendDatasetDFourWay;
        this.updatePlot();
    }

    public VennDiagramType getCurrentVennDiagramType() {
        return this.currentVennDiagramType;
    }

    public void resizePlot(int parentWidth, int parentHeight) {
        if (this.currentVennDiagramType != VennDiagramType.FOUR_WAY) {
            int min = Math.min(parentWidth, parentHeight);
            this.setMaximumSize(new Dimension(min, min));
            this.setPreferredSize(new Dimension(min, min));
            this.updatePlot();
        } else {
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.updatePlot();
        }
    }

    public boolean showLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public int getFontSize() {
        return this.fontSizeValues;
    }

    public void setFontSize(int fontSizeValues) {
        this.fontSizeValues = fontSizeValues;
    }

    public int getFontSizeLegend() {
        return this.fontSizeLegend;
    }

    public void setFontSizeLegend(int fontSizeLegend) {
        this.fontSizeLegend = fontSizeLegend;
    }

    public static enum VennDiagramType {
        ONE_WAY,
        TWO_WAY,
        THREE_WAY,
        FOUR_WAY;

    }
}

