/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.export.graphics;

import com.compomics.util.Export;
import com.compomics.util.enumeration.ImageType;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.preferences.LastSelectedFolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.transcoder.TranscoderException;
import org.jfree.chart.ChartPanel;

public class ExportGraphicsDialog
extends JDialog {
    private ChartPanel chartPanel;
    private Component graphicsPanel;
    private ProgressDialogX progressDialog;
    private JFrame frame;
    private Image normalIcon;
    private Image waitingIcon;
    private LastSelectedFolder lastSelectedFolder = new LastSelectedFolder();
    private JPanel backgroundPanel;
    private ButtonGroup buttonGroup;
    private JButton cancelJButton;
    private JButton exportJButton;
    private JRadioButton pdfJRadioButton;
    private JPanel plottingTypeJPanel;
    private JRadioButton pngJRadioButton;
    private JRadioButton svgJRadioButton;
    private JRadioButton tiffJRadioButton;

    public ExportGraphicsDialog(JFrame frame, Image normalIcon, Image waitingIcon, boolean modal, Component graphicsPanel, LastSelectedFolder lastSelectedFolder) {
        super((Frame)frame, modal);
        this.frame = frame;
        this.graphicsPanel = graphicsPanel;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.initComponents();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    public ExportGraphicsDialog(JFrame frame, Image normalIcon, Image waitingIcon, boolean modal, ChartPanel chartPanel, LastSelectedFolder lastSelectedFolder) {
        super((Frame)frame, modal);
        this.frame = frame;
        this.chartPanel = chartPanel;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.initComponents();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    public ExportGraphicsDialog(JDialog dialog, Image normalIcon, Image waitingIcon, boolean modal, Component graphicsPanel, LastSelectedFolder lastSelectedFolder) {
        super((Dialog)dialog, modal);
        this.frame = (JFrame)dialog.getParent();
        this.graphicsPanel = graphicsPanel;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.initComponents();
        this.setLocationRelativeTo(dialog);
        this.setVisible(true);
    }

    public ExportGraphicsDialog(JDialog dialog, Image normalIcon, Image waitingIcon, boolean modal, ChartPanel chartPanel, LastSelectedFolder lastSelectedFolder) {
        super((Dialog)dialog, modal);
        this.frame = (JFrame)dialog.getParent();
        this.chartPanel = chartPanel;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.initComponents();
        this.setLocationRelativeTo(dialog);
        this.setVisible(true);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.backgroundPanel = new JPanel();
        this.plottingTypeJPanel = new JPanel();
        this.pngJRadioButton = new JRadioButton();
        this.tiffJRadioButton = new JRadioButton();
        this.pdfJRadioButton = new JRadioButton();
        this.svgJRadioButton = new JRadioButton();
        this.exportJButton = new JButton();
        this.cancelJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export Plot");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.plottingTypeJPanel.setBorder(BorderFactory.createTitledBorder("Plot Type"));
        this.plottingTypeJPanel.setOpaque(false);
        this.buttonGroup.add(this.pngJRadioButton);
        this.pngJRadioButton.setSelected(true);
        this.pngJRadioButton.setText("PNG (Portable Network Graphics)");
        this.pngJRadioButton.setIconTextGap(15);
        this.pngJRadioButton.setOpaque(false);
        this.buttonGroup.add(this.tiffJRadioButton);
        this.tiffJRadioButton.setText("TIFF (Tagged Image File Format)");
        this.tiffJRadioButton.setIconTextGap(15);
        this.tiffJRadioButton.setOpaque(false);
        this.buttonGroup.add(this.pdfJRadioButton);
        this.pdfJRadioButton.setText("PDF (Portable Document Format)");
        this.pdfJRadioButton.setIconTextGap(15);
        this.pdfJRadioButton.setOpaque(false);
        this.buttonGroup.add(this.svgJRadioButton);
        this.svgJRadioButton.setText("SVG (Scalable Vector Graphics)");
        this.svgJRadioButton.setIconTextGap(15);
        this.svgJRadioButton.setOpaque(false);
        GroupLayout plottingTypeJPanelLayout = new GroupLayout(this.plottingTypeJPanel);
        this.plottingTypeJPanel.setLayout(plottingTypeJPanelLayout);
        plottingTypeJPanelLayout.setHorizontalGroup(plottingTypeJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plottingTypeJPanelLayout.createSequentialGroup().addContainerGap().addGroup(plottingTypeJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.svgJRadioButton).addComponent(this.pdfJRadioButton).addComponent(this.tiffJRadioButton).addComponent(this.pngJRadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
        plottingTypeJPanelLayout.setVerticalGroup(plottingTypeJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plottingTypeJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pngJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tiffJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pdfJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.svgJRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.exportJButton.setText("Export");
        this.exportJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportGraphicsDialog.this.exportJButtonActionPerformed(evt);
            }
        });
        this.cancelJButton.setText("Cancel");
        this.cancelJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportGraphicsDialog.this.cancelJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.plottingTypeJPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.exportJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelJButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelJButton, this.exportJButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.plottingTypeJPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelJButton).addComponent(this.exportJButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void exportJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        this.setVisible(false);
        JFileChooser chooser = new JFileChooser(this.getLastSelectedFolder());
        this.addFileFilter(chooser);
        int selection = chooser.showSaveDialog(this);
        if (selection == 0) {
            String selectedFile = chooser.getSelectedFile().getAbsolutePath();
            this.lastSelectedFolder.setLastSelectedFolder("export", selectedFile);
            this.savePanel(selectedFile, true);
        }
        this.setCursor(new Cursor(0));
    }

    private void cancelJButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void savePanel(String selectedFile, boolean aShowSavedMessage) {
        int option;
        final boolean showSavedMessage = aShowSavedMessage;
        if (this.pngJRadioButton.isSelected()) {
            if (!selectedFile.endsWith(ImageType.PNG.getExtension())) {
                selectedFile = selectedFile + ImageType.PNG.getExtension();
            }
        } else if (this.tiffJRadioButton.isSelected()) {
            if (!selectedFile.endsWith(ImageType.TIFF.getExtension())) {
                selectedFile = selectedFile + ImageType.TIFF.getExtension();
            }
        } else if (this.pdfJRadioButton.isSelected()) {
            if (!selectedFile.endsWith(ImageType.PDF.getExtension())) {
                selectedFile = selectedFile + ImageType.PDF.getExtension();
            }
        } else if (this.svgJRadioButton.isSelected() && !selectedFile.endsWith(ImageType.SVG.getExtension())) {
            selectedFile = selectedFile + ImageType.SVG.getExtension();
        }
        boolean saveFile = true;
        if (new File(selectedFile).exists() && (option = JOptionPane.showConfirmDialog(this, "The file " + selectedFile + " already exists. Overwrite?", "Overwrite?", 1)) != 0) {
            saveFile = false;
        }
        if (saveFile) {
            this.frame.setCursor(new Cursor(3));
            this.lastSelectedFolder.setLastSelectedFolder("export", selectedFile);
            final String finalSelectedFile = selectedFile;
            final ExportGraphicsDialog tempRef = this;
            this.progressDialog = new ProgressDialogX((Frame)this.frame, this.normalIcon, this.waitingIcon, true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Saving Figure. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ExportGraphicsDialog.this.progressDialog.setVisible(true);
                }
            }, "ProgressDialog").start();
            new Thread("SaveFigureThread"){

                @Override
                public void run() {
                    try {
                        ImageType currentImageType = ExportGraphicsDialog.this.pngJRadioButton.isSelected() ? ImageType.PNG : (ExportGraphicsDialog.this.tiffJRadioButton.isSelected() ? ImageType.TIFF : (ExportGraphicsDialog.this.pdfJRadioButton.isSelected() ? ImageType.PDF : ImageType.SVG));
                        if (ExportGraphicsDialog.this.chartPanel != null) {
                            Export.exportChart(ExportGraphicsDialog.this.chartPanel.getChart(), ExportGraphicsDialog.this.chartPanel.getBounds(), new File(finalSelectedFile), currentImageType);
                        } else {
                            Export.exportComponent(ExportGraphicsDialog.this.graphicsPanel, ExportGraphicsDialog.this.graphicsPanel.getBounds(), new File(finalSelectedFile), currentImageType);
                        }
                        ExportGraphicsDialog.this.progressDialog.setRunFinished();
                        ExportGraphicsDialog.this.frame.setCursor(new Cursor(0));
                        if (showSavedMessage) {
                            JOptionPane.showMessageDialog(ExportGraphicsDialog.this.frame, "Plot saved to " + finalSelectedFile, "Plot Saved", 1);
                            tempRef.dispose();
                        }
                    }
                    catch (IOException e) {
                        ExportGraphicsDialog.this.progressDialog.setRunFinished();
                        tempRef.setVisible(false);
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(tempRef, "Unable to export plot: " + e.getMessage(), "Error Exporting Plot", 1);
                        tempRef.dispose();
                    }
                    catch (TranscoderException e) {
                        ExportGraphicsDialog.this.progressDialog.setRunFinished();
                        tempRef.setVisible(false);
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(tempRef, "Unable to export plot: " + e.getMessage(), "Error Exporting Plot", 1);
                        tempRef.dispose();
                    }
                }
            }.start();
        }
    }

    private void addFileFilter(JFileChooser chooser) {
        FileFilter filter = null;
        if (this.pngJRadioButton.isSelected()) {
            filter = new FileFilter(){

                @Override
                public boolean accept(File myFile) {
                    return myFile.getName().toLowerCase().endsWith("png") || myFile.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "PNG (Portable Network Graphics) (.png)";
                }
            };
        } else if (this.tiffJRadioButton.isSelected()) {
            filter = new FileFilter(){

                @Override
                public boolean accept(File myFile) {
                    return myFile.getName().toLowerCase().endsWith("tif") || myFile.getName().toLowerCase().endsWith("tiff") || myFile.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "TIFF (Tagged Image File Format) (.tif)";
                }
            };
        } else if (this.pdfJRadioButton.isSelected()) {
            filter = new FileFilter(){

                @Override
                public boolean accept(File myFile) {
                    return myFile.getName().toLowerCase().endsWith("pdf") || myFile.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "PDF (Portable Document Format) (.pdf)";
                }
            };
        } else if (this.svgJRadioButton.isSelected()) {
            filter = new FileFilter(){

                @Override
                public boolean accept(File myFile) {
                    return myFile.getName().toLowerCase().endsWith("svg") || myFile.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "SVG (Scalable Vector Graphics) (.svg)";
                }
            };
        }
        chooser.setFileFilter(filter);
    }

    private String getLastSelectedFolder() {
        String result = this.lastSelectedFolder.getLastSelectedFolder("export");
        if (result == null) {
            result = this.lastSelectedFolder.getLastSelectedFolder();
        }
        return result;
    }
}

