/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters;

import com.compomics.util.experiment.identification.ptm.PtmScore;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.preferences.FractionSettings;
import com.compomics.util.preferences.IdMatchValidationPreferences;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.PSProcessingPreferences;
import com.compomics.util.preferences.PTMScoringPreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class OldProcessingPreferencesDialog
extends JDialog {
    private PSProcessingPreferences processingPreferences;
    private IdentificationParameters identificationParameters;
    private boolean editable;
    private boolean canceled = false;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JPanel fractionsPanel;
    private JButton helpJButton;
    private JComboBox neutralLossesCmb;
    private JComboBox neutralLossesCmb2;
    private JLabel neutralLossesLabel;
    private JLabel neutralLossesLabel2;
    private JButton okButton;
    private JLabel peptideFdrLabel;
    private JTextField peptideFdrTxt;
    private JLabel percentLabel;
    private JLabel percentLabel2;
    private JLabel percentLabel3;
    private JLabel percentLabel4;
    private JPanel processingParamsPanel;
    private JTextField proteinConfidenceMwTxt;
    private JLabel proteinFdrLabel;
    private JTextField proteinFdrTxt;
    private JLabel proteinMwLabel;
    private JLabel psmFdrLabel;
    private JTextField psmFdrTxt;
    private JPanel ptmScoringPanel;
    private JComboBox scoreCmb;
    private JLabel scoreTypeLabel;
    private JComboBox thresholdAutpoCmb;
    private JLabel thresholdAutpoLabel;
    private JLabel thresholdLabel;
    private JTextField thresholdTxt;

    public OldProcessingPreferencesDialog(Frame parent, boolean editable, IdentificationParameters identificationParameters, PSProcessingPreferences processingPreferences) {
        super(parent, true);
        this.initComponents();
        this.processingPreferences = processingPreferences;
        this.identificationParameters = identificationParameters;
        this.editable = editable;
        this.setUpGui();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public OldProcessingPreferencesDialog(JDialog parent, boolean editable, IdentificationParameters identificationParameters, PSProcessingPreferences processingPreferences) {
        super((Dialog)parent, true);
        this.initComponents();
        this.processingPreferences = processingPreferences;
        this.identificationParameters = identificationParameters;
        this.editable = editable;
        this.setUpGui();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGui() {
        IdMatchValidationPreferences idMatchValidationPreferences = this.identificationParameters.getIdValidationPreferences();
        this.proteinFdrTxt.setText(idMatchValidationPreferences.getDefaultProteinFDR() + "");
        this.peptideFdrTxt.setText(idMatchValidationPreferences.getDefaultPeptideFDR() + "");
        this.psmFdrTxt.setText(idMatchValidationPreferences.getDefaultPsmFDR() + "");
        this.proteinFdrTxt.setEditable(this.editable);
        this.peptideFdrTxt.setEditable(this.editable);
        this.psmFdrTxt.setEditable(this.editable);
        this.proteinFdrTxt.setEnabled(this.editable);
        this.peptideFdrTxt.setEnabled(this.editable);
        this.psmFdrTxt.setEnabled(this.editable);
        this.proteinConfidenceMwTxt.setEnabled(this.editable);
        PTMScoringPreferences ptmScoringPreferences = this.identificationParameters.getPtmScoringPreferences();
        this.scoreCmb.setSelectedItem((Object)ptmScoringPreferences.getSelectedProbabilisticScore());
        if (ptmScoringPreferences.isProbabilitsticScoreCalculation().booleanValue()) {
            this.scoreCmb.setEnabled(this.editable);
            this.neutralLossesCmb.setEnabled(this.editable);
            if (ptmScoringPreferences.isProbabilisticScoreNeutralLosses().booleanValue()) {
                this.neutralLossesCmb.setSelectedIndex(0);
            } else {
                this.neutralLossesCmb.setSelectedIndex(1);
            }
            this.thresholdAutpoCmb.setEnabled(this.editable);
            if (ptmScoringPreferences.isEstimateFlr()) {
                this.thresholdAutpoCmb.setSelectedIndex(0);
                this.thresholdTxt.setEnabled(false);
                this.thresholdTxt.setEditable(false);
            } else {
                this.thresholdAutpoCmb.setSelectedIndex(1);
                this.thresholdTxt.setEnabled(this.editable);
                this.thresholdTxt.setEditable(this.editable);
                this.thresholdTxt.setText(ptmScoringPreferences.getProbabilisticScoreThreshold() + "");
            }
        } else {
            this.neutralLossesCmb.setEnabled(false);
            this.thresholdAutpoCmb.setEnabled(false);
            this.thresholdTxt.setEnabled(false);
            this.thresholdTxt.setEditable(false);
        }
        FractionSettings fractionSettings = this.identificationParameters.getFractionSettings();
        this.proteinConfidenceMwTxt.setText(fractionSettings.getProteinConfidenceMwPlots() + "");
        this.thresholdAutpoCmb.setRenderer(new AlignedListCellRenderer(0));
        this.neutralLossesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.scoreCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private boolean validateInput() {
        int outcome;
        Double temp;
        try {
            temp = new Double(this.proteinFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the protein FDR.", "Input Error", 0);
                this.proteinFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the protein FDR.", "Input Error", 0);
            this.proteinFdrTxt.requestFocus();
            return false;
        }
        try {
            temp = new Double(this.peptideFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the peptide FDR.", "Input Error", 0);
                this.peptideFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the peptide FDR.", "Input Error", 0);
            this.peptideFdrTxt.requestFocus();
            return false;
        }
        try {
            temp = new Double(this.psmFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the PSM FDR.", "Input Error", 0);
                this.psmFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the PSM FDR.", "Input Error", 0);
            this.psmFdrTxt.requestFocus();
            return false;
        }
        try {
            if (this.scoreCmb.getSelectedItem() != PtmScore.None && this.thresholdAutpoCmb.getSelectedIndex() == 1 && ((temp = new Double(this.thresholdTxt.getText().trim())) < 0.0 || temp > 100.0)) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the score threshold.", "Input Error", 0);
                this.thresholdTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the score threshold.", "Input Error", 0);
            this.thresholdTxt.requestFocus();
            return false;
        }
        try {
            temp = new Double(this.proteinConfidenceMwTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the Protein Confidence MW.", "Input Error", 0);
                this.proteinConfidenceMwTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the Protein Confidence MW.", "Input Error", 0);
            this.proteinConfidenceMwTxt.requestFocus();
            return false;
        }
        if (this.scoreCmb.getSelectedItem() == PtmScore.None && ((outcome = JOptionPane.showConfirmDialog(this, "Disabling the probabilistic score will impair PTM localization and thus distinction\nbetween peptides. See help for more details. Continue with this setting?", "Warning", 2)) == 2 || outcome == -1)) {
            return false;
        }
        return this.scoreCmb.getSelectedItem() == PtmScore.None || this.neutralLossesCmb.getSelectedIndex() != 0 || (outcome = JOptionPane.showConfirmDialog(this, "In our experience probabilistic scores perform poorly when accounting for\nneutral losses. See help for more details. Continue with this setting?", "Warning", 2)) != 2 && outcome != -1;
    }

    private void initComponents() {
        this.neutralLossesLabel2 = new JLabel();
        this.neutralLossesCmb2 = new JComboBox();
        this.backgroundPanel = new JPanel();
        this.processingParamsPanel = new JPanel();
        this.proteinFdrLabel = new JLabel();
        this.peptideFdrLabel = new JLabel();
        this.psmFdrLabel = new JLabel();
        this.psmFdrTxt = new JTextField();
        this.percentLabel = new JLabel();
        this.peptideFdrTxt = new JTextField();
        this.percentLabel2 = new JLabel();
        this.proteinFdrTxt = new JTextField();
        this.percentLabel3 = new JLabel();
        this.ptmScoringPanel = new JPanel();
        this.scoreCmb = new JComboBox();
        this.thresholdTxt = new JTextField();
        this.thresholdLabel = new JLabel();
        this.scoreTypeLabel = new JLabel();
        this.neutralLossesLabel = new JLabel();
        this.neutralLossesCmb = new JComboBox();
        this.thresholdAutpoLabel = new JLabel();
        this.thresholdAutpoCmb = new JComboBox();
        this.fractionsPanel = new JPanel();
        this.proteinMwLabel = new JLabel();
        this.proteinConfidenceMwTxt = new JTextField();
        this.percentLabel4 = new JLabel();
        this.helpJButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.neutralLossesLabel2.setText("Account Neutral Losses");
        this.neutralLossesCmb2.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.setDefaultCloseOperation(2);
        this.setTitle("Processing");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OldProcessingPreferencesDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.processingParamsPanel.setBorder(BorderFactory.createTitledBorder("Processing Parameters"));
        this.processingParamsPanel.setOpaque(false);
        this.proteinFdrLabel.setText("Protein FDR");
        this.peptideFdrLabel.setText("Peptide FDR");
        this.psmFdrLabel.setText("PSM FDR");
        this.psmFdrTxt.setHorizontalAlignment(0);
        this.psmFdrTxt.setText("1");
        this.percentLabel.setText("%");
        this.peptideFdrTxt.setHorizontalAlignment(0);
        this.peptideFdrTxt.setText("1");
        this.percentLabel2.setText("%");
        this.proteinFdrTxt.setHorizontalAlignment(0);
        this.proteinFdrTxt.setText("1");
        this.percentLabel3.setText("%");
        GroupLayout processingParamsPanelLayout = new GroupLayout(this.processingParamsPanel);
        this.processingParamsPanel.setLayout(processingParamsPanelLayout);
        processingParamsPanelLayout.setHorizontalGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingParamsPanelLayout.createSequentialGroup().addContainerGap().addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinFdrLabel).addComponent(this.peptideFdrLabel).addComponent(this.psmFdrLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 92, Short.MAX_VALUE).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, processingParamsPanelLayout.createSequentialGroup().addComponent(this.proteinFdrTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel3)).addGroup(GroupLayout.Alignment.TRAILING, processingParamsPanelLayout.createSequentialGroup().addComponent(this.peptideFdrTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel2)).addGroup(GroupLayout.Alignment.TRAILING, processingParamsPanelLayout.createSequentialGroup().addComponent(this.psmFdrTxt, -2, 185, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel))).addContainerGap()));
        processingParamsPanelLayout.setVerticalGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingParamsPanelLayout.createSequentialGroup().addContainerGap().addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinFdrTxt, -2, -1, -2).addComponent(this.percentLabel3).addComponent(this.proteinFdrLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideFdrTxt, -2, -1, -2).addComponent(this.percentLabel2).addComponent(this.peptideFdrLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psmFdrLabel).addComponent(this.psmFdrTxt, -2, -1, -2).addComponent(this.percentLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.ptmScoringPanel.setBorder(BorderFactory.createTitledBorder("PTM Scoring"));
        this.ptmScoringPanel.setOpaque(false);
        this.scoreCmb.setModel(new DefaultComboBoxModel<PtmScore>(PtmScore.getScoresAsList()));
        this.scoreCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OldProcessingPreferencesDialog.this.scoreCmbActionPerformed(evt);
            }
        });
        this.thresholdTxt.setHorizontalAlignment(0);
        this.thresholdLabel.setText("Threshold");
        this.scoreTypeLabel.setText("Probabilistic Score");
        this.neutralLossesLabel.setText("Account Neutral Losses");
        this.neutralLossesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.thresholdAutpoLabel.setText("Threshold Auto");
        this.thresholdAutpoCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.thresholdAutpoCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OldProcessingPreferencesDialog.this.thresholdAutpoCmbActionPerformed(evt);
            }
        });
        GroupLayout ptmScoringPanelLayout = new GroupLayout(this.ptmScoringPanel);
        this.ptmScoringPanel.setLayout(ptmScoringPanelLayout);
        ptmScoringPanelLayout.setHorizontalGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addContainerGap().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.neutralLossesLabel).addGroup(ptmScoringPanelLayout.createSequentialGroup().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addComponent(this.thresholdAutpoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 74, Short.MAX_VALUE).addComponent(this.thresholdAutpoCmb, -2, 185, -2)).addGroup(ptmScoringPanelLayout.createSequentialGroup().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scoreTypeLabel).addComponent(this.thresholdLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, ptmScoringPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.scoreCmb, GroupLayout.Alignment.TRAILING, 0, 185, Short.MAX_VALUE).addComponent(this.neutralLossesCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE)).addComponent(this.thresholdTxt, GroupLayout.Alignment.TRAILING, -2, 185, -2)))).addGap(29, 29, 29)))));
        ptmScoringPanelLayout.setVerticalGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addContainerGap().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scoreTypeLabel).addComponent(this.scoreCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.neutralLossesLabel).addComponent(this.neutralLossesCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.thresholdAutpoLabel).addComponent(this.thresholdAutpoCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.thresholdLabel).addComponent(this.thresholdTxt, -2, -1, -2)).addContainerGap()));
        this.fractionsPanel.setBorder(BorderFactory.createTitledBorder("Fractions (Beta)"));
        this.fractionsPanel.setOpaque(false);
        this.proteinMwLabel.setText("Protein Confidence MW");
        this.proteinMwLabel.setToolTipText("<html>\nThe minium protein confidence required to be included in the<br>\naverage molecular weight analysis in the Fractions tab.\n</html>");
        this.proteinConfidenceMwTxt.setHorizontalAlignment(0);
        this.proteinConfidenceMwTxt.setText("95");
        this.proteinConfidenceMwTxt.setToolTipText("<html>\nThe minium protein confidence required to be included in the<br>\naverage molecular weight analysis in the Fractions tab.\n</html>");
        this.percentLabel4.setText("%");
        GroupLayout fractionsPanelLayout = new GroupLayout(this.fractionsPanel);
        this.fractionsPanel.setLayout(fractionsPanelLayout);
        fractionsPanelLayout.setHorizontalGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fractionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinMwLabel).addGap(30, 30, 30).addComponent(this.proteinConfidenceMwTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel4).addContainerGap()));
        fractionsPanelLayout.setVerticalGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fractionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinConfidenceMwTxt, -2, -1, -2).addComponent(this.percentLabel4).addComponent(this.proteinMwLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OldProcessingPreferencesDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OldProcessingPreferencesDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OldProcessingPreferencesDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OldProcessingPreferencesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OldProcessingPreferencesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.ptmScoringPanel, -1, -1, Short.MAX_VALUE).addComponent(this.fractionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.processingParamsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.processingParamsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ptmScoringPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fractionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.editable && this.validateInput()) {
            IdMatchValidationPreferences idMatchValidationPreferences = this.identificationParameters.getIdValidationPreferences();
            idMatchValidationPreferences.setDefaultProteinFDR(new Double(this.proteinFdrTxt.getText().trim()));
            idMatchValidationPreferences.setDefaultPeptideFDR(new Double(this.peptideFdrTxt.getText().trim()));
            idMatchValidationPreferences.setDefaultPsmFDR(new Double(this.psmFdrTxt.getText().trim()));
            PTMScoringPreferences ptmScoringPreferences = this.identificationParameters.getPtmScoringPreferences();
            ptmScoringPreferences.setProbabilitsticScoreCalculation(this.scoreCmb.getSelectedItem() != PtmScore.None);
            ptmScoringPreferences.setSelectedProbabilisticScore((PtmScore)((Object)this.scoreCmb.getSelectedItem()));
            ptmScoringPreferences.setProbabilisticScoreNeutralLosses(this.neutralLossesCmb.getSelectedIndex() == 0);
            if (this.thresholdAutpoCmb.getSelectedIndex() == 0) {
                ptmScoringPreferences.setEstimateFlr(true);
            } else {
                ptmScoringPreferences.setEstimateFlr(false);
                ptmScoringPreferences.setProbabilisticScoreThreshold(new Double(this.thresholdTxt.getText().trim()));
            }
            this.processingPreferences.setProteinConfidenceMwPlots(new Double(this.proteinConfidenceMwTxt.getText().trim()));
            this.dispose();
        }
    }

    private void thresholdAutpoCmbActionPerformed(ActionEvent evt) {
        if (this.thresholdAutpoCmb.getSelectedIndex() == 1) {
            this.thresholdTxt.setEnabled(true);
            this.thresholdTxt.setEditable(true);
        } else {
            this.thresholdTxt.setEnabled(false);
            this.thresholdTxt.setEditable(false);
        }
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/ProcessingPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), null, "Processing - Help");
        this.setCursor(new Cursor(0));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void scoreCmbActionPerformed(ActionEvent evt) {
        if (this.scoreCmb.getSelectedItem() != PtmScore.None) {
            this.neutralLossesCmb.setEnabled(true);
            this.thresholdAutpoCmb.setEnabled(true);
            if (this.thresholdAutpoCmb.getSelectedIndex() == 1) {
                this.thresholdTxt.setEnabled(true);
                this.thresholdTxt.setEditable(true);
            } else {
                this.thresholdTxt.setEnabled(false);
                this.thresholdTxt.setEditable(false);
            }
        } else {
            this.neutralLossesCmb.setEnabled(false);
            this.thresholdAutpoCmb.setEnabled(false);
            this.thresholdTxt.setEnabled(false);
            this.thresholdTxt.setEditable(false);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

