/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification_parameters;

import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.preferences.LastSelectedFolder;
import com.compomics.util.preferences.ProteinInferencePreferences;
import com.compomics.util.protein_sequences_manager.gui.SequenceDbDetailsDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ProteinInferenceSettingsDialog
extends JDialog {
    private Frame parentFrame;
    private Image normalIcon;
    private Image waitingIcon;
    private final LastSelectedFolder lastSelectedFolder;
    private boolean canceled = false;
    private boolean editable;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JPanel dataBasePanelSettings;
    private JLabel databaseSettingsLbl;
    private JTextField databaseSettingsTxt;
    private JButton editDatabaseDetailsButton;
    private JButton helpJButton;
    private JButton okButton;
    private JPanel proteinGroupPanel;
    private JComboBox simplifyCharacterizationCmb;
    private JLabel simplifyCharacterizationLbl;
    private JComboBox simplifyEnzymaticityCmb;
    private JLabel simplifyEnzymaticityLbl;
    private JComboBox simplifyEvidenceCmb;
    private JLabel simplifyEvidenceLbl;
    private JComboBox simplifyGroupsCmb;
    private JLabel simplifyGroupsLbl;
    private JComboBox simplifyScoreCmb;
    private JLabel simplifyScoreLbl;

    public ProteinInferenceSettingsDialog(Frame parentFrame, ProteinInferencePreferences proteinInferencePreferences, Image normalIcon, Image waitingIcon, LastSelectedFolder lastSelectedFolder, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.lastSelectedFolder = lastSelectedFolder;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(proteinInferencePreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public ProteinInferenceSettingsDialog(Dialog owner, Frame parentFrame, ProteinInferencePreferences proteinInferencePreferences, Image normalIcon, Image waitingIcon, LastSelectedFolder lastSelectedFolder, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.lastSelectedFolder = lastSelectedFolder;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(proteinInferencePreferences);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        if (!this.editable) {
            this.editDatabaseDetailsButton.setText("View");
        }
        this.simplifyGroupsCmb.setEnabled(this.editable);
        this.simplifyScoreCmb.setEnabled(this.editable);
        this.simplifyEnzymaticityCmb.setEnabled(this.editable);
        this.simplifyEvidenceCmb.setEnabled(this.editable);
        this.simplifyCharacterizationCmb.setEnabled(this.editable);
        this.simplifyGroupsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.simplifyScoreCmb.setRenderer(new AlignedListCellRenderer(0));
        this.simplifyEnzymaticityCmb.setRenderer(new AlignedListCellRenderer(0));
        this.simplifyEvidenceCmb.setRenderer(new AlignedListCellRenderer(0));
        this.simplifyCharacterizationCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void populateGUI(ProteinInferencePreferences proteinInferencePreferences) {
        if (proteinInferencePreferences.getProteinSequenceDatabase() != null) {
            this.databaseSettingsTxt.setText(proteinInferencePreferences.getProteinSequenceDatabase().getAbsolutePath());
            this.okButton.setEnabled(true);
        }
        if (proteinInferencePreferences.getSimplifyGroups().booleanValue()) {
            this.simplifyGroupsCmb.setSelectedIndex(0);
        } else {
            this.simplifyGroupsCmb.setSelectedIndex(1);
            this.simplifyScoreCmb.setEnabled(false);
            this.simplifyEnzymaticityCmb.setEnabled(false);
            this.simplifyEvidenceCmb.setEnabled(false);
            this.simplifyCharacterizationCmb.setEnabled(false);
        }
        if (proteinInferencePreferences.getSimplifyGroupsScore().booleanValue()) {
            this.simplifyScoreCmb.setSelectedIndex(0);
        } else {
            this.simplifyScoreCmb.setSelectedIndex(1);
        }
        if (proteinInferencePreferences.getSimplifyGroupsEnzymaticity().booleanValue()) {
            this.simplifyEnzymaticityCmb.setSelectedIndex(0);
        } else {
            this.simplifyEnzymaticityCmb.setSelectedIndex(1);
        }
        if (proteinInferencePreferences.getSimplifyGroupsEvidence().booleanValue()) {
            this.simplifyEvidenceCmb.setSelectedIndex(0);
        } else {
            this.simplifyEvidenceCmb.setSelectedIndex(1);
        }
        if (proteinInferencePreferences.getSimplifyGroupsUncharacterized().booleanValue()) {
            this.simplifyCharacterizationCmb.setSelectedIndex(0);
        } else {
            this.simplifyCharacterizationCmb.setSelectedIndex(1);
        }
    }

    public ProteinInferencePreferences getProteinInferencePreferences() {
        ProteinInferencePreferences proteinInferencePreferences = new ProteinInferencePreferences();
        proteinInferencePreferences.setProteinSequenceDatabase(new File(this.databaseSettingsTxt.getText()));
        proteinInferencePreferences.setSimplifyGroups(this.simplifyGroupsCmb.getSelectedIndex() == 0);
        proteinInferencePreferences.setSimplifyGroupsScore(this.simplifyScoreCmb.getSelectedIndex() == 0);
        proteinInferencePreferences.setSimplifyGroupsEvidence(this.simplifyEvidenceCmb.getSelectedIndex() == 0);
        proteinInferencePreferences.setSimplifyGroupsEnzymaticity(this.simplifyEnzymaticityCmb.getSelectedIndex() == 0);
        proteinInferencePreferences.setSimplifyGroupsUncharacterized(this.simplifyCharacterizationCmb.getSelectedIndex() == 0);
        return proteinInferencePreferences;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.dataBasePanelSettings = new JPanel();
        this.databaseSettingsLbl = new JLabel();
        this.databaseSettingsTxt = new JTextField();
        this.editDatabaseDetailsButton = new JButton();
        this.proteinGroupPanel = new JPanel();
        this.simplifyGroupsLbl = new JLabel();
        this.simplifyScoreLbl = new JLabel();
        this.simplifyEnzymaticityLbl = new JLabel();
        this.simplifyEvidenceLbl = new JLabel();
        this.simplifyCharacterizationLbl = new JLabel();
        this.simplifyGroupsCmb = new JComboBox();
        this.simplifyScoreCmb = new JComboBox();
        this.simplifyEnzymaticityCmb = new JComboBox();
        this.simplifyEvidenceCmb = new JComboBox();
        this.simplifyCharacterizationCmb = new JComboBox();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Protein Inference");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProteinInferenceSettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.dataBasePanelSettings.setBorder(BorderFactory.createTitledBorder("Database"));
        this.dataBasePanelSettings.setOpaque(false);
        this.databaseSettingsLbl.setText("Database (FASTA)");
        this.databaseSettingsTxt.setEditable(false);
        this.editDatabaseDetailsButton.setText("Edit");
        this.editDatabaseDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceSettingsDialog.this.editDatabaseDetailsButtonActionPerformed(evt);
            }
        });
        GroupLayout dataBasePanelSettingsLayout = new GroupLayout(this.dataBasePanelSettings);
        this.dataBasePanelSettings.setLayout(dataBasePanelSettingsLayout);
        dataBasePanelSettingsLayout.setHorizontalGroup(dataBasePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataBasePanelSettingsLayout.createSequentialGroup().addContainerGap().addComponent(this.databaseSettingsLbl, -2, 116, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.databaseSettingsTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editDatabaseDetailsButton, -2, 80, -2).addContainerGap()));
        dataBasePanelSettingsLayout.setVerticalGroup(dataBasePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataBasePanelSettingsLayout.createSequentialGroup().addContainerGap().addGroup(dataBasePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.databaseSettingsLbl).addComponent(this.editDatabaseDetailsButton).addComponent(this.databaseSettingsTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.proteinGroupPanel.setBorder(BorderFactory.createTitledBorder("Protein Groups Simplification"));
        this.proteinGroupPanel.setOpaque(false);
        this.simplifyGroupsLbl.setText("Simplify Protein Groups");
        this.simplifyScoreLbl.setText("- Based on Score");
        this.simplifyEnzymaticityLbl.setText("- Based on Enzymaticity");
        this.simplifyEvidenceLbl.setText("- Based on UniProt Evidence Level");
        this.simplifyCharacterizationLbl.setText("- Based on Protein Characterization");
        this.simplifyGroupsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.simplifyGroupsCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceSettingsDialog.this.simplifyGroupsCmbActionPerformed(evt);
            }
        });
        this.simplifyScoreCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.simplifyEnzymaticityCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.simplifyEvidenceCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.simplifyCharacterizationCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout proteinGroupPanelLayout = new GroupLayout(this.proteinGroupPanel);
        this.proteinGroupPanel.setLayout(proteinGroupPanelLayout);
        proteinGroupPanelLayout.setHorizontalGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinGroupPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.simplifyGroupsLbl).addGroup(proteinGroupPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.simplifyScoreLbl).addComponent(this.simplifyEnzymaticityLbl).addComponent(this.simplifyEvidenceLbl).addComponent(this.simplifyCharacterizationLbl)))).addGap(61, 61, 61).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.simplifyScoreCmb, 0, 296, Short.MAX_VALUE).addComponent(this.simplifyEnzymaticityCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.simplifyEvidenceCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.simplifyCharacterizationCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.simplifyGroupsCmb, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        proteinGroupPanelLayout.setVerticalGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinGroupPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.simplifyGroupsLbl).addComponent(this.simplifyGroupsCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.simplifyScoreLbl).addComponent(this.simplifyScoreCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.simplifyEnzymaticityLbl).addComponent(this.simplifyEnzymaticityCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.simplifyEvidenceLbl).addComponent(this.simplifyEvidenceCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.simplifyCharacterizationLbl).addComponent(this.simplifyCharacterizationCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceSettingsDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceSettingsDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceSettingsDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.proteinGroupPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.dataBasePanelSettings, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.dataBasePanelSettings, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proteinGroupPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void editDatabaseDetailsButtonActionPerformed(ActionEvent evt) {
        SequenceDbDetailsDialog sequenceDbDetailsDialog;
        boolean success;
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        if (this.databaseSettingsTxt.getText().trim().length() == 0) {
            try {
                sequenceFactory.clearFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Failed to clear the sequence factory.", "File Error", 0);
            }
        }
        if (success = (sequenceDbDetailsDialog = new SequenceDbDetailsDialog(this.parentFrame, this.lastSelectedFolder, this.editable, this.normalIcon, this.waitingIcon)).selectDB(true)) {
            sequenceDbDetailsDialog.setVisible(true);
            this.okButton.setEnabled(true);
        }
        if (sequenceFactory.getCurrentFastaFile() != null) {
            this.databaseSettingsTxt.setText(sequenceFactory.getCurrentFastaFile().getAbsolutePath());
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void simplifyGroupsCmbActionPerformed(ActionEvent evt) {
        this.simplifyScoreCmb.setEnabled(this.editable && this.simplifyGroupsCmb.getSelectedIndex() == 0);
        this.simplifyEnzymaticityCmb.setEnabled(this.editable && this.simplifyGroupsCmb.getSelectedIndex() == 0);
        this.simplifyEvidenceCmb.setEnabled(this.editable && this.simplifyGroupsCmb.getSelectedIndex() == 0);
        this.simplifyCharacterizationCmb.setEnabled(this.editable && this.simplifyGroupsCmb.getSelectedIndex() == 0);
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/ProteinInferencePreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Protein Inference - Help");
        this.setCursor(new Cursor(0));
    }
}

